/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssRulesetWrappingElement;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.impl.LESSElementVisitor;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.impl.LessParameterList;
import org.jetbrains.plugins.less.psi.stubs.impl.LessMixinStub;

public class LESSPrimitiveMixin
extends LESSMixin
implements CssRulesetWrappingElement {
    public LESSPrimitiveMixin(@NotNull LessMixinStub stub, @NotNull CssNamedStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/less/psi/impl/LESSPrimitiveMixin", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "org/jetbrains/plugins/less/psi/impl/LESSPrimitiveMixin", "<init>"));
        }
        super(stub, nodeType);
    }

    public LESSPrimitiveMixin(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/less/psi/impl/LESSPrimitiveMixin", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public String getName() {
        LessMixinStub stub = (LessMixinStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LESSPrimitiveMixin", "getName"));
            }
            return string;
        }
        CssSelectorSuffix fullNameIdentifier = this.getFullNameIdentifier();
        String string = fullNameIdentifier != null ? fullNameIdentifier.getName() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LESSPrimitiveMixin", "getName"));
        }
        return string;
    }

    @NotNull
    public CssRuleset[] getRulesets() {
        CssRuleset[] cssRulesetArray = (CssRuleset[])this.findChildrenByType((IElementType)CssElementTypes.CSS_RULESET, CssRuleset.class);
        if (cssRulesetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LESSPrimitiveMixin", "getRulesets"));
        }
        return cssRulesetArray;
    }

    @Override
    @NotNull
    public String getParametersString() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LESSPrimitiveMixin", "getParametersString"));
        }
        return "";
    }

    @Override
    public Icon getIcon(int flags) {
        return StringUtil.startsWithChar((CharSequence)this.getFullName(), (char)'#') ? AllIcons.Xml.Html_id : AllIcons.Xml.Css_class;
    }

    @Override
    @Nullable
    public LessParameterList getParameterListElement() {
        return null;
    }

    @Nullable
    public CssSelectorSuffix getFullNameIdentifier() {
        CssRuleset ruleset = (CssRuleset)this.getStubOrPsiChild((IStubElementType)CssElementTypes.CSS_RULESET);
        if (ruleset == null) {
            return null;
        }
        CssSelector firstSelector = (CssSelector)ArrayUtil.getFirstElement((Object[])ruleset.getSelectors());
        if (firstSelector == null) {
            return null;
        }
        CssSimpleSelector firstSimpleSelector = (CssSimpleSelector)ArrayUtil.getFirstElement((Object[])firstSelector.getSimpleSelectors());
        if (firstSimpleSelector == null) {
            return null;
        }
        return (CssSelectorSuffix)ArrayUtil.getFirstElement((Object[])firstSimpleSelector.getSelectorSuffixes());
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        PsiElement[] children = this.getStubOrPsiChildren(LESSMixinName.MIXIN_NAME_TOKENS, PsiElement.ARRAY_FACTORY);
        if (children.length > 0) {
            return children[0];
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/less/psi/impl/LESSPrimitiveMixin", "accept"));
        }
        if (visitor instanceof LESSElementVisitor) {
            ((LESSElementVisitor)visitor).visitPrimitiveMixin(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @NotNull
    public PsiElement getTargetForReference() {
        CssSelectorSuffix fullNameIdentifier = this.getFullNameIdentifier();
        Object object = fullNameIdentifier != null ? fullNameIdentifier : this;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LESSPrimitiveMixin", "getTargetForReference"));
        }
        return object;
    }
}

