/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.references;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.css.impl.CssFileImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.psi.LESSFile;
import org.jetbrains.plugins.less.references.LessImportReference;

public class LessImportReferenceSet
extends FileReferenceSet {
    @NotNull
    private final PsiElement myRefContainingFile;
    private final Condition<PsiFileSystemItem> COMPLETION_FILTER;

    public LessImportReferenceSet(@NotNull PsiElement element, PsiReferenceProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/references/LessImportReferenceSet", "<init>"));
        }
        super(StringUtil.stripQuotesAroundValue((String)element.getText()), element, LessImportReferenceSet.offset(element.getText()), provider, SystemInfo.isFileSystemCaseSensitive);
        this.COMPLETION_FILTER = new Condition<PsiFileSystemItem>(){

            public boolean value(PsiFileSystemItem item) {
                return LessImportReferenceSet.this.myRefContainingFile != item && (item.isDirectory() || item instanceof CssFileImpl || item instanceof LESSFile);
            }
        };
        this.myRefContainingFile = element.getContainingFile().getOriginalFile();
    }

    private static int offset(String text) {
        return text.length() > 0 && (text.charAt(0) == '\'' || text.charAt(0) == '\"') ? 1 : 0;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new LessImportReference(this, range, index, text);
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return this.COMPLETION_FILTER;
    }
}

