/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.exports;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportsNode {
    private final String myName;
    private final LinkedHashMap<String, ExportsNode> myChildByNameMap;
    private final PsiElement myNavigateTo;

    public ExportsNode(@NotNull String name, @Nullable PsiElement navigateTo) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/testFramework/exports/ExportsNode", "<init>"));
        }
        this.myName = name;
        this.myNavigateTo = navigateTo;
        this.myChildByNameMap = new LinkedHashMap();
    }

    @Nullable
    public ExportsNode getChild(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/testFramework/exports/ExportsNode", "getChild"));
        }
        return this.myChildByNameMap.get(name);
    }

    public void addChild(@NotNull ExportsNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/javascript/testFramework/exports/ExportsNode", "addChild"));
        }
        this.myChildByNameMap.put(child.myName, child);
    }

    @NotNull
    public Collection<ExportsNode> getChildren() {
        Collection<ExportsNode> collection = this.myChildByNameMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/exports/ExportsNode", "getChildren"));
        }
        return collection;
    }

    public boolean isEmpty() {
        return this.myChildByNameMap.isEmpty();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/exports/ExportsNode", "getName"));
        }
        return string;
    }

    @Nullable
    public PsiElement getNavigateTo() {
        return this.myNavigateTo;
    }
}

