/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.interfaces.mochaTdd;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.AbstractMochaTddElement;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddSuite;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddTest;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaTddFileStructure
extends AbstractTestFileStructure {
    private final List<MochaTddSuite> myChildren;

    public MochaTddFileStructure(@NotNull JSFile jsFile, @NotNull List<AbstractMochaTddElement> children) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "<init>"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "<init>"));
        }
        super(jsFile);
        this.myChildren = MochaTddFileStructure.filterSuites(children);
    }

    @NotNull
    private static List<MochaTddSuite> filterSuites(@NotNull List<AbstractMochaTddElement> children) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "filterSuites"));
        }
        if (children.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "filterSuites"));
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.copyOf((Iterable)Iterables.filter(children, MochaTddSuite.class));
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "filterSuites"));
        }
        return immutableList;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @Nullable
    public JstdRunElement findJstdRunElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "findJstdRunElement"));
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement findPsiElement(@NotNull String suiteName, @Nullable String testName) {
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "findPsiElement"));
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getTopLevelElements() {
        if (this.myChildren.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "getTopLevelElements"));
            }
            return list;
        }
        ArrayList out = ContainerUtil.newArrayListWithCapacity((int)this.myChildren.size());
        for (MochaTddSuite suite : this.myChildren) {
            out.add(suite.getName());
        }
        ArrayList arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "getTopLevelElements"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> getChildrenOf(@NotNull String topLevelElementName) {
        if (topLevelElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelElementName", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "getChildrenOf"));
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "getChildrenOf"));
        }
        return list;
    }

    @Override
    public boolean contains(@NotNull String testCaseName, @Nullable String testMethodName) {
        if (testCaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCaseName", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "contains"));
        }
        return false;
    }

    @NotNull
    public List<MochaTddSuite> getTopLevelSuites() {
        List<MochaTddSuite> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "getTopLevelSuites"));
        }
        return list;
    }

    @Nullable
    public PsiElement findPsiElement(@NotNull List<String> suiteNames, @Nullable String testName) {
        if (suiteNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteNames", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "findPsiElement"));
        }
        if (suiteNames.isEmpty()) {
            return null;
        }
        String firstSuiteName = suiteNames.get(0);
        MochaTddSuite currentSuite = null;
        for (MochaTddSuite suite : this.myChildren) {
            if (!suite.getName().equals(firstSuiteName)) continue;
            currentSuite = suite;
            break;
        }
        if (currentSuite == null) {
            return null;
        }
        for (int i = 1; i < suiteNames.size(); ++i) {
            if ((currentSuite = currentSuite.findSuiteByName(suiteNames.get(i))) != null) continue;
            return null;
        }
        if (testName != null) {
            MochaTddTest test = currentSuite.findTestByName(testName);
            return test == null ? null : test.getCallExpression();
        }
        return currentSuite.getEnclosingCallExpression();
    }

    @Nullable
    public AbstractMochaTddElement findDeepestElementContainingElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "findDeepestElementContainingElement"));
        }
        for (MochaTddSuite suite : this.myChildren) {
            AbstractMochaTddElement result = suite.findDeepestElementContainingRange(textRange);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public JsTestElementPath findTestElementPath(@NotNull TextRange range) {
        JSCallExpression psiElement;
        String testName;
        MochaTddSuite suite;
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddFileStructure", "findTestElementPath"));
        }
        AbstractMochaTddElement element = this.findDeepestElementContainingElement(range);
        if (element == null) {
            return null;
        }
        if (element instanceof MochaTddSuite) {
            suite = (MochaTddSuite)element;
            testName = null;
            psiElement = suite.getEnclosingCallExpression();
        } else {
            MochaTddTest test = (MochaTddTest)element;
            suite = element.getParent();
            testName = element.getName();
            psiElement = test.getCallExpression();
        }
        List suites = ContainerUtil.newSmartList();
        while (suite != null) {
            suites.add(suite.getName());
            suite = suite.getParent();
        }
        Collections.reverse(suites);
        return new JsTestElementPath(suites, testName, (PsiElement)psiElement);
    }
}

