/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit.codeInsight;

import com.intellij.javascript.testFramework.codeInsight.AbstractJsGenerateAction;
import com.intellij.javascript.testFramework.codeInsight.GenerateActionContext;
import com.intellij.javascript.testFramework.codeInsight.JsGeneratorUtils;
import com.intellij.javascript.testFramework.qunit.AbstractQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractQUnitGenerateMissingLifecycleMethodAction
extends AbstractJsGenerateAction {
    AbstractQUnitGenerateMissingLifecycleMethodAction() {
    }

    @Override
    @NotNull
    public abstract String getHumanReadableDescription();

    @NotNull
    public abstract String getMethodName();

    @Override
    public boolean isEnabled(@NotNull GenerateActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/qunit/codeInsight/AbstractQUnitGenerateMissingLifecycleMethodAction", "isEnabled"));
        }
        Runnable generator = this.createGenerator(context);
        return generator != null;
    }

    @Override
    public void actionPerformed(@NotNull GenerateActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/qunit/codeInsight/AbstractQUnitGenerateMissingLifecycleMethodAction", "actionPerformed"));
        }
        Runnable generator = this.createGenerator(context);
        if (generator != null) {
            generator.run();
        }
    }

    @Nullable
    private static QUnitModuleStructure findModuleStructure(@NotNull GenerateActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/qunit/codeInsight/AbstractQUnitGenerateMissingLifecycleMethodAction", "findModuleStructure"));
        }
        QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
        QUnitFileStructure fileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure(context.getJsFile());
        if (fileStructure.hasQUnitSymbols()) {
            AbstractQUnitModuleStructure ms;
            QUnitTestMethodStructure testMethodStructure = fileStructure.findTestMethodStructureContainingOffset(context.getDocumentCaretOffset());
            if (testMethodStructure != null && (ms = testMethodStructure.getModuleStructure()) instanceof QUnitModuleStructure) {
                return (QUnitModuleStructure)ms;
            }
            QUnitModuleStructure moduleStructure = fileStructure.findModuleStructureContainingOffset(context.getDocumentCaretOffset());
            if (moduleStructure != null) {
                return moduleStructure;
            }
        }
        return null;
    }

    @Nullable
    private Runnable createGenerator(@NotNull GenerateActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/qunit/codeInsight/AbstractQUnitGenerateMissingLifecycleMethodAction", "createGenerator"));
        }
        QUnitModuleStructure moduleStructure = AbstractQUnitGenerateMissingLifecycleMethodAction.findModuleStructure(context);
        if (moduleStructure != null) {
            boolean noNeededMethod;
            boolean bl = noNeededMethod = moduleStructure.findLifecycleMethodByName(this.getMethodName()) == null;
            if (noNeededMethod) {
                return this.createGenerator(context, moduleStructure);
            }
        }
        return null;
    }

    @Nullable
    private Runnable createGenerator(final @NotNull GenerateActionContext context, final @NotNull QUnitModuleStructure moduleStructure) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/qunit/codeInsight/AbstractQUnitGenerateMissingLifecycleMethodAction", "createGenerator"));
        }
        if (moduleStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleStructure", "com/intellij/javascript/testFramework/qunit/codeInsight/AbstractQUnitGenerateMissingLifecycleMethodAction", "createGenerator"));
        }
        return new Runnable(){

            @Override
            public void run() {
                JSObjectLiteralExpression lifecycleObjectLiteral = moduleStructure.getLifecycleObjectLiteral();
                String str = AbstractQUnitGenerateMissingLifecycleMethodAction.this.getMethodName() + ": function() {|}";
                if (lifecycleObjectLiteral != null) {
                    JsGeneratorUtils.generateProperty(lifecycleObjectLiteral, context, str);
                } else {
                    JSArgumentList argumentList = moduleStructure.getEnclosingCallExpression().getArgumentList();
                    if (argumentList != null) {
                        JsGeneratorUtils.generateObjectLiteralWithPropertyAsArgument(context, "{\n" + str + "\n}", argumentList, 1);
                    }
                }
            }
        };
    }
}

