/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit.codeInsight;

import com.intellij.codeInsight.template.Template;
import com.intellij.javascript.testFramework.codeInsight.AbstractJsGenerateAction;
import com.intellij.javascript.testFramework.codeInsight.GenerateActionContext;
import com.intellij.javascript.testFramework.codeInsight.JsGeneratorUtils;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QUnitGenerateNewTestAction
extends AbstractJsGenerateAction {
    @Override
    @NotNull
    public String getHumanReadableDescription() {
        if ("QUnit Test" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/codeInsight/QUnitGenerateNewTestAction", "getHumanReadableDescription"));
        }
        return "QUnit Test";
    }

    @Override
    public boolean isEnabled(@NotNull GenerateActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/qunit/codeInsight/QUnitGenerateNewTestAction", "isEnabled"));
        }
        Runnable generator = QUnitGenerateNewTestAction.createGenerator(context);
        return generator != null;
    }

    @Override
    public void actionPerformed(@NotNull GenerateActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/qunit/codeInsight/QUnitGenerateNewTestAction", "actionPerformed"));
        }
        Runnable generator = QUnitGenerateNewTestAction.createGenerator(context);
        if (generator != null) {
            generator.run();
        }
    }

    @Nullable
    private static Runnable createGenerator(@NotNull GenerateActionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/qunit/codeInsight/QUnitGenerateNewTestAction", "createGenerator"));
        }
        QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
        QUnitFileStructure fileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure(context.getJsFile());
        return QUnitGenerateNewTestAction.createGenerator(context, fileStructure);
    }

    @Nullable
    private static Runnable createGenerator(final @NotNull GenerateActionContext context, final @NotNull QUnitFileStructure fileStructure) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/testFramework/qunit/codeInsight/QUnitGenerateNewTestAction", "createGenerator"));
        }
        if (fileStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStructure", "com/intellij/javascript/testFramework/qunit/codeInsight/QUnitGenerateNewTestAction", "createGenerator"));
        }
        if (fileStructure.hasQUnitSymbols()) {
            final PsiElement psiElement = context.getPsiElementUnderCaret();
            if (psiElement == null) {
                return null;
            }
            return new Runnable(){

                @Override
                public void run() {
                    QUnitModuleStructure moduleStructureUnderCaret;
                    int caretOffset = context.getDocumentCaretOffset();
                    QUnitTestMethodStructure testMethodStructure = fileStructure.findTestMethodStructureContainingOffset(caretOffset);
                    PsiElement element = psiElement;
                    if (testMethodStructure != null) {
                        element = testMethodStructure.getCallExpression();
                    }
                    if ((moduleStructureUnderCaret = fileStructure.findModuleStructureContainingOffset(caretOffset)) != null) {
                        element = moduleStructureUnderCaret.getEnclosingCallExpression();
                    }
                    int suitableCaretOffset = JsGeneratorUtils.findSuitableOffsetForNewStatement(element, caretOffset);
                    context.getCaretModel().moveToOffset(suitableCaretOffset);
                    String name = JsPsiUtils.wrapWithMostFrequentQuote(context.getJsFile(), "${test name}");
                    Template template = JsGeneratorUtils.createDefaultTemplate("test(" + name + ", function() {|});");
                    context.startTemplate(template);
                }
            };
        }
        return null;
    }
}

