/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserStacktraceFilter
implements Filter {
    private final String myBrowserName;
    private final Function<String, File> myFileFinder;
    private final Project myProject;

    public BrowserStacktraceFilter(@NotNull Project project, @NotNull String browserName, @NotNull Function<String, File> fileFinder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter", "<init>"));
        }
        if (browserName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserName", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter", "<init>"));
        }
        if (fileFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileFinder", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter", "<init>"));
        }
        this.myProject = project;
        this.myBrowserName = browserName;
        this.myFileFinder = fileFinder;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        Pattern[] urlPatterns;
        HyperlinkBuilder hyperlinkBuilder = this.findHyperlinkBuilder();
        if (hyperlinkBuilder == null) {
            return null;
        }
        for (Pattern urlPattern : urlPatterns = hyperlinkBuilder.getAllPossibleUrlPatterns()) {
            void var10_10;
            void var11_11;
            int hyperlinkStartInd;
            String text;
            Matcher matcher = urlPattern.matcher(line);
            if (!matcher.find()) continue;
            if (matcher.groupCount() == 1) {
                text = matcher.group(1);
                hyperlinkStartInd = matcher.start(1);
            } else {
                if (matcher.groupCount() != 3) continue;
                text = matcher.group(3) + ":" + matcher.group(1);
                try {
                    int column = Integer.parseInt(matcher.group(2));
                    text = text + ":" + ++column;
                }
                catch (NumberFormatException column) {
                    // empty catch block
                }
                hyperlinkStartInd = matcher.start(3);
            }
            Filter.Result result = this.buildLineWithHyperlink((int)var11_11, (String)var10_10);
            if (result == null) continue;
            if (matcher.groupCount() == 3) {
                return new Filter.Result((int)var11_11, matcher.end(3), result.hyperlinkInfo);
            }
            return result;
        }
        return null;
    }

    @Nullable
    private Filter.Result buildLineWithHyperlink(int hyperlinkStartInd, @NotNull String urlWithPositionStr) {
        HyperlinkInfo link;
        if (urlWithPositionStr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlWithPositionStr", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter", "buildLineWithHyperlink"));
        }
        UrlWithPosition urlWithPosition = UrlWithPosition.parse(urlWithPositionStr);
        int lineNumber = -1;
        int columnNumber = -1;
        TIntArrayList positions = urlWithPosition.getPositions();
        List positionStrings = urlWithPosition.getPositionStrings();
        int hyperlinkEndInd = hyperlinkStartInd + urlWithPosition.getUrl().length();
        if (positions.size() > 0) {
            lineNumber = positions.get(0);
            hyperlinkEndInd += 1 + ((String)positionStrings.get(0)).length();
            if (positions.size() > 1) {
                columnNumber = positions.get(1);
                hyperlinkEndInd += 1 + ((String)positionStrings.get(1)).length();
            }
        }
        if ((link = this.createHyperlinkInfo(this.myProject, urlWithPosition.getUrl(), Math.max(-1, lineNumber - 1), Math.max(-1, columnNumber - 1))) == null) {
            return null;
        }
        return new Filter.Result(hyperlinkStartInd, hyperlinkEndInd, link);
    }

    @Nullable
    private HyperlinkInfo createHyperlinkInfo(Project project, @NotNull String url, int lineNumber, int columnNumber) {
        VirtualFile virtualFile;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter", "createHyperlinkInfo"));
        }
        File file = (File)this.myFileFinder.fun((Object)url);
        if (file != null && (virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false)) != null) {
            return new OpenFileHyperlinkInfo(project, virtualFile, lineNumber, columnNumber);
        }
        return null;
    }

    @Nullable
    private HyperlinkBuilder findHyperlinkBuilder() {
        String browserName = this.myBrowserName.toLowerCase();
        if (browserName.startsWith("chrome")) {
            return ChromeHyperlinkBuilder.INSTANCE;
        }
        if (browserName.startsWith("firefox")) {
            return FirefoxHyperlinkBuilder.INSTANCE;
        }
        if (browserName.startsWith("opera")) {
            return OperaHyperlinkBuilder.INSTANCE;
        }
        if (browserName.startsWith("safari")) {
            return SafariHyperlinkBuilder.INSTANCE;
        }
        if (browserName.startsWith("ie") || browserName.contains("internet explorer")) {
            return IEHyperlinkBuilder.INSTANCE;
        }
        return null;
    }

    private static class UrlWithPosition {
        private final String myUrl;
        private final TIntArrayList myPositions;
        private final List<String> myPositionStrings;

        private UrlWithPosition(@NotNull String url, @NotNull TIntArrayList positions, @NotNull List<String> positionStrings) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$UrlWithPosition", "<init>"));
            }
            if (positions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positions", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$UrlWithPosition", "<init>"));
            }
            if (positionStrings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positionStrings", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$UrlWithPosition", "<init>"));
            }
            this.myUrl = url;
            this.myPositions = positions;
            this.myPositionStrings = positionStrings;
        }

        private static UrlWithPosition parse(@NotNull String urlWithPosition) {
            int colonInd;
            if (urlWithPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlWithPosition", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$UrlWithPosition", "parse"));
            }
            TIntArrayList positions = new TIntArrayList(2);
            ArrayList<String> positionStrings = new ArrayList<String>(2);
            int prevColonInd = urlWithPosition.length();
            while (positions.size() < 2 && (colonInd = urlWithPosition.lastIndexOf(58, prevColonInd - 1)) != -1) {
                try {
                    String positionStr = urlWithPosition.substring(colonInd + 1, prevColonInd);
                    int position = Integer.parseInt(positionStr);
                    positions.add(position);
                    positionStrings.add(positionStr);
                    prevColonInd = colonInd;
                }
                catch (NumberFormatException e) {
                    break;
                }
            }
            positions.reverse();
            Collections.reverse(positionStrings);
            return new UrlWithPosition(urlWithPosition.substring(0, prevColonInd), positions, positionStrings);
        }

        @NotNull
        private String getUrl() {
            String string = this.myUrl;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$UrlWithPosition", "getUrl"));
            }
            return string;
        }

        @NotNull
        private TIntArrayList getPositions() {
            TIntArrayList tIntArrayList = this.myPositions;
            if (tIntArrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$UrlWithPosition", "getPositions"));
            }
            return tIntArrayList;
        }

        @NotNull
        private List<String> getPositionStrings() {
            List<String> list = this.myPositionStrings;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$UrlWithPosition", "getPositionStrings"));
            }
            return list;
        }
    }

    private static class IEHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final IEHyperlinkBuilder INSTANCE = new IEHyperlinkBuilder();
        private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("^\\s*at.*\\(([^\\)]*)\\)$")};

        private IEHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (PATTERNS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$IEHyperlinkBuilder", "getAllPossibleUrlPatterns"));
            }
            return PATTERNS;
        }
    }

    private static class SafariHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final SafariHyperlinkBuilder INSTANCE = new SafariHyperlinkBuilder();
        private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("^.*@([^\\(@]*)$")};

        private SafariHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (PATTERNS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$SafariHyperlinkBuilder", "getAllPossibleUrlPatterns"));
            }
            return PATTERNS;
        }
    }

    private static class OperaHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final OperaHyperlinkBuilder INSTANCE = new OperaHyperlinkBuilder();
        private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("^\\s*called from line (\\d+), column (\\d+) in .* in ([^:]*):$"), Pattern.compile("^.*\\(.*\\)@([^\\(@]*)$")};

        private OperaHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (PATTERNS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$OperaHyperlinkBuilder", "getAllPossibleUrlPatterns"));
            }
            return PATTERNS;
        }
    }

    private static class FirefoxHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final FirefoxHyperlinkBuilder INSTANCE = new FirefoxHyperlinkBuilder();
        private static final Pattern[] FIREFOX_URL_WITH_LINE = new Pattern[]{Pattern.compile("^.*@(.*)$")};

        private FirefoxHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (FIREFOX_URL_WITH_LINE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$FirefoxHyperlinkBuilder", "getAllPossibleUrlPatterns"));
            }
            return FIREFOX_URL_WITH_LINE;
        }
    }

    private static class ChromeHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final ChromeHyperlinkBuilder INSTANCE = new ChromeHyperlinkBuilder();
        private static final Pattern[] URL_PATTERNS = new Pattern[]{Pattern.compile("^\\s*at\\s+([^\\s\\(].*)$"), Pattern.compile("^\\s*at\\s.*\\(([^\\(]*)\\)$")};

        private ChromeHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (URL_PATTERNS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$ChromeHyperlinkBuilder", "getAllPossibleUrlPatterns"));
            }
            return URL_PATTERNS;
        }
    }

    private static abstract class HyperlinkBuilder {
        private HyperlinkBuilder() {
        }

        @NotNull
        public abstract Pattern[] getAllPossibleUrlPatterns();
    }
}

