/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public enum DialectOptionHolder {
    ECMA_4("ECMA_4"),
    ECMA_6("ECMA_6"),
    JS_1_5("JS_1_5"),
    JS_1_6("JS_1_6"),
    JS_1_7("JS_1_7"),
    JS_1_8("JS_1_8"),
    E4X("E4X"),
    JSX("JSX"),
    GWT("GWT"),
    APPLE_JS("APPLE_JS"),
    TS("TS"),
    TSX("TSX"),
    NASHORN("NASHORN"),
    FLOW("FLOW"),
    OTHER("OTHER");

    public final boolean isECMA4;
    private final boolean isJavaScript1_6_OrHigher;
    private final boolean hasE4X;
    private final boolean isJavaScript1_7_OrHigher;
    private final boolean isJavaScript1_8_OrHigher;
    public final boolean isGwt;
    public final boolean isAppleJS;
    public final boolean isECMA6;
    public final boolean isTypeScript;
    public final boolean isNashorn;
    public final boolean isFlow;
    public final boolean isTSX;
    public final boolean isJSX;
    private final ImmutableSet<JSLanguageFeature> myFeatures;

    private DialectOptionHolder(String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/DialectOptionHolder", "<init>"));
        }
        this.isECMA4 = "ECMA_4".equals(name);
        this.isGwt = "GWT".equals(name);
        this.isFlow = "FLOW".equals(name);
        this.isTSX = "TSX".equals(name);
        this.isJavaScript1_8_OrHigher = "JS_1_8".equals(name);
        this.isJavaScript1_7_OrHigher = this.isJavaScript1_8_OrHigher || "JS_1_7".equals(name);
        this.isJavaScript1_6_OrHigher = this.isJavaScript1_7_OrHigher || "JS_1_6".equals(name);
        this.hasE4X = this.isJavaScript1_6_OrHigher || "E4X".equals(name) || "JSX".equals(name) || this.isFlow || this.isTSX;
        this.isAppleJS = "APPLE_JS".equals(name);
        this.isECMA6 = "ECMA_6".equals(name) || "JSX".equals(name) || this.isFlow;
        this.isTypeScript = "TS".equals(name) || this.isTSX;
        this.isJSX = this.isTSX || this.isFlow || "JSX".equals(name);
        this.isNashorn = "NASHORN".equals(name);
        this.myFeatures = this.defineFeatures();
    }

    private ImmutableSet<JSLanguageFeature> defineFeatures() {
        EnumSet<JSLanguageFeature> features = EnumSet.noneOf(JSLanguageFeature.class);
        if (this.hasE4X || this.isJavaScript1_6_OrHigher || this.isECMA4) {
            features.add(JSLanguageFeature.E4X);
        }
        if (this.isJavaScript1_6_OrHigher || this.isECMA4 || this.isNashorn) {
            features.add(JSLanguageFeature.FOR_EACH);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.FOR_OF);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.LET_DEFINITIONS);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.YIELD_GENERATORS);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6) {
            features.add(JSLanguageFeature.ARRAY_COMPREHENSIONS);
        }
        if (this.isJavaScript1_7_OrHigher) {
            features.add(JSLanguageFeature.LET_SCOPE);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6) {
            features.add(JSLanguageFeature.DESTRUCTURING_ASSIGNMENT);
        }
        if (this.isJavaScript1_8_OrHigher || this.isNashorn) {
            features.add(JSLanguageFeature.EXPRESSION_CLOSURES);
        }
        if (this.isJavaScript1_8_OrHigher) {
            features.add(JSLanguageFeature.GENERATOR_EXPRESSIONS);
        }
        features.add(JSLanguageFeature.ACCESSORS);
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.ARROW_FUNCTIONS);
        }
        if (this.isECMA4 || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.REST_PARAMETERS);
        }
        if (this.isTypeScript || this.isFlow) {
            features.add(JSLanguageFeature.GENERICS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.IMPORT_DECLARATIONS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.EXPORT_DECLARATIONS);
        }
        if (this.isECMA4 || this.isTypeScript || this.isECMA6) {
            features.add(JSLanguageFeature.CLASSES);
        }
        if (this.isTypeScript || this.isECMA6) {
            features.add(JSLanguageFeature.ANNOTATIONS);
            features.add(JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
        }
        if (this.isTypeScript) {
            features.add(JSLanguageFeature.ASYNC_AWAIT);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
            features.add(JSLanguageFeature.COMPUTED_PROPERTY_NAMES);
            features.add(JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS);
        }
        if (this.isECMA6 || this.isTypeScript || this.isNashorn) {
            features.add(JSLanguageFeature.STRING_TEMPLATES);
        }
        if (this.isECMA6) {
            features.add(JSLanguageFeature.BIND_EXPRESSIONS);
        }
        return Sets.immutableEnumSet(features);
    }

    public boolean hasFeature(@NotNull JSLanguageFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/intellij/lang/javascript/DialectOptionHolder", "hasFeature"));
        }
        return this.myFeatures.contains((Object)feature);
    }

    public boolean isJavaScript() {
        return this != ECMA_4 && this != TS && this != TSX && this != OTHER;
    }
}

