/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface JSFunction
extends JSQualifiedNamedElement,
JSSourceElement,
JSAttributeListOwner,
StubBasedPsiElement<JSFunctionStubBase>,
JSExecutionScope,
JSFunctionItem {
    public static final JSFunction[] EMPTY_ARRAY = new JSFunction[0];
    public static final ArrayFactory<JSFunction> ARRAY_FACTORY = new ArrayFactory<JSFunction>(){

        @NotNull
        public JSFunction[] create(int count) {
            JSFunction[] jSFunctionArray = count == 0 ? EMPTY_ARRAY : new JSFunction[count];
            if (jSFunctionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSFunction$1", "create"));
            }
            return jSFunctionArray;
        }
    };
    @NonNls
    public static final String ARGUMENTS_VAR_NAME = "arguments";

    public JSParameterList getParameterList();

    @NotNull
    public JSSourceElement[] getBody();

    public boolean isConstructor();

    public String getReturnTypeString();

    public PsiElement getReturnTypeElement();

    public boolean isReferencesThis();

    @NotNull
    public JSParameter[] getParameters();

    @NotNull
    public FunctionKind getKind();

    public boolean constructorCanBeInvokedWithoutNew();

    public boolean isAnonymousFunctionCall();

    public boolean isGenerator();

    public static enum FunctionKind {
        GETTER,
        SETTER,
        CONSTRUCTOR,
        SIMPLE;

    }
}

