/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.GenerateEJBReferenceHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GenerateResourceReferenceHandler
implements CodeInsightActionHandler {
    @NonNls
    private static final String FIELD_VAR_NAME = "field";

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/GenerateResourceReferenceHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/GenerateResourceReferenceHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/GenerateResourceReferenceHandler", "invoke"));
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiTypeParameter) {
        }
        final PsiClass aClass = (PsiClass)element;
        if (aClass == null || aClass.isInterface()) {
            return;
        }
        assert (aClass.isValid());
        assert (aClass.getContainingFile() != null);
        assert (aClass.getContainingFile() == file);
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        template.setToReformat(true);
        final Set<String> types = EjbUtil.getAllowedResourceTypeNames(aClass);
        final LookupElement[] typeLookupItems = (LookupElement[])ContainerUtil.map2Array(types, LookupElement.class, (Function)new Function<String, LookupElement>(){

            public LookupElement fun(String s) {
                PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createTypeByFQClassName(s, GlobalSearchScope.allScope((Project)aClass.getProject()));
                return PsiTypeLookupItem.createLookupItem((PsiType)psiClassType, null);
            }
        });
        Expression typeExpression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult((String)types.iterator().next());
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return typeLookupItems;
            }
        };
        Expression fieldNameExpression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                TextResult typeResult = TemplateManagerImpl.getTemplateState((Editor)editor).getVariableValue("type");
                return new TextResult(StringUtil.decapitalize((String)(StringUtil.getShortName((String)typeResult.getText()) + "Ref")));
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                TextRange textRange = TemplateManagerImpl.getTemplateState((Editor)editor).getVariableRange("type");
                PsiElement psiElement = file.findElementAt(textRange.getStartOffset());
                if (psiElement == null || !(psiElement.getParent() instanceof PsiJavaCodeReferenceElement)) {
                    return null;
                }
                PsiClassType classType = JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory().createType((PsiJavaCodeReferenceElement)psiElement.getParent());
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.FIELD, null, null, (PsiType)classType);
                SuggestedNameInfo suggestedNameInfo2 = codeStyleManager.suggestUniqueVariableName(suggestedNameInfo, psiElement, true);
                LookupElement[] items = new LookupElement[suggestedNameInfo2.names.length + 1];
                int i = 0;
                String defaultName = StringUtil.decapitalize((String)(StringUtil.getShortName((String)classType.getClassName()) + "Ref"));
                items[i++] = LookupElementBuilder.create((String)defaultName);
                for (String name : suggestedNameInfo2.names) {
                    items[i++] = LookupElementBuilder.create((String)name);
                }
                return items;
            }
        };
        template.addTextSegment("\n@javax.annotation.Resource");
        template.addTextSegment("\nprivate ");
        template.addVariable("type", typeExpression, typeExpression, true);
        template.addTextSegment(" ");
        template.addVariable(FIELD_VAR_NAME, fieldNameExpression, fieldNameExpression, true);
        template.addTextSegment(";\n");
        template.addEndVariable();
        editor.getCaretModel().moveToOffset(GenerateEJBReferenceHandler.getInsertOffset(editor, file));
        manager.startTemplate(editor, template);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

