/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jsp.JspBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.source.jsp.el.impl.MethodSignatureFilter;
import com.intellij.psi.impl.source.jsp.el.impl.StringMethodSignatureFilter;
import com.intellij.psi.jsp.el.ELElementVisitor;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELSelectExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ElMethodSignatureInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/codeInspection/jsp/ElMethodSignatureInspection", "buildVisitor"));
        }
        ELElementVisitor eLElementVisitor = new ELElementVisitor(){

            public void visitELExpressionHolder(ELExpressionHolder expressionHolder) {
                PsiElement[] children = expressionHolder.getChildren();
                if (children.length == 1) {
                    PsiElement child = children[0];
                    if (!(child instanceof ELSelectExpression)) {
                        return;
                    }
                    ELVariable method = ((ELSelectExpression)child).getField();
                    if (method != null) {
                        ElMethodSignatureInspection.checkCallExpression(method, expressionHolder, problemsHolder);
                    }
                }
            }
        };
        if (eLElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ElMethodSignatureInspection", "buildVisitor"));
        }
        return eLElementVisitor;
    }

    private static void checkCallExpression(ELVariable method, ELExpressionHolder elHolder, ProblemsHolder problemsHolder) {
        PsiReference reference = method.getReference();
        if (reference == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (!(element instanceof PsiMethod)) {
            return;
        }
        MethodSignatureFilter filter = StringMethodSignatureFilter.getDeferredMethodSignatureFilter(elHolder);
        if (filter != null && !filter.isAcceptable((PsiMethod)element)) {
            String s = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)259, (int)2);
            problemsHolder.registerProblem((PsiElement)method, JspBundle.message("method.does.not.match", s, filter.getSignature()), new LocalQuickFix[0]);
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ElMethodSignatureInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("EL method signature inspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ElMethodSignatureInspection", "getDisplayName"));
        }
        return "EL method signature inspection";
    }

    @NotNull
    public String getShortName() {
        if ("ELMethodSignatureInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ElMethodSignatureInspection", "getShortName"));
        }
        return "ELMethodSignatureInspection";
    }
}

