/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jsp.JspBundle;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelfIncludingJspFilesInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    @NonNls
    public String getShortName() {
        if ("SelfIncludingJspFiles" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/SelfIncludingJspFilesInspection", "getShortName"));
        }
        return "SelfIncludingJspFiles";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/SelfIncludingJspFilesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/SelfIncludingJspFilesInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = JspBundle.message("inspection.self.including.jsp.files", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/SelfIncludingJspFilesInspection", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(final @NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/jsp/SelfIncludingJspFilesInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/jsp/SelfIncludingJspFilesInspection", "checkFile"));
        }
        Language language = file.getViewProvider().getBaseLanguage();
        if (language != StdLanguages.JSP && language != StdLanguages.JSPX) {
            return null;
        }
        SmartList problems = new SmartList();
        file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((List)problems, manager, isOnTheFly){
            final /* synthetic */ List val$problems;
            final /* synthetic */ InspectionManager val$manager;
            final /* synthetic */ boolean val$isOnTheFly;
            {
                this.val$problems = list;
                this.val$manager = inspectionManager;
                this.val$isOnTheFly = bl;
            }

            public void visitXmlTag(XmlTag tag) {
                if (JspUtil.getDirectiveKindByTag((XmlTag)tag) == JspDirectiveKind.INCLUDE) {
                    JspFile jspFile = JspUtil.resolveIncludeDirective(tag);
                    if (jspFile != null && jspFile.equals(file)) {
                        this.val$problems.add(this.val$manager.createProblemDescriptor((PsiElement)tag, JspBundle.message("inspection.problem.jsp.file.must.not.include.itself", new Object[0]), this.val$isOnTheFly, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    }
                } else {
                    super.visitXmlTag(tag);
                }
            }
        });
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }
}

