/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.appServerIntegrations;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.impl.FrameworkTypeUtil;
import com.intellij.j2ee.appServerIntegrations.ApplicationServersModelProvider;
import com.intellij.j2ee.appServerIntegrations.ChooseModulesFromAllProjectsDialog;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServerImpl;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServersManagerImpl;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.AppServerLibrariesProvider;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.appServers.library.AppServerFrameworkLibraryProperties;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.supportProvider.appServers.AppServerFrameworkLibrariesFetcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.Processor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationServerConfigurable
implements UnnamedConfigurable {
    private final ApplicationServerImpl myAppServerInstallation;
    private JPanel myPanel;
    private JTextField myName;
    private boolean myIsModified = false;
    private JPanel myServerSpecificSettings;
    private final ApplicationServerPersistentDataEditor<ApplicationServerPersistentData> myServerEditor;
    private boolean myIsInUpdating = false;
    private JLabel myNameLabel;
    private final ApplicationServersModelProvider myAppServersModelProvider;
    private List<FrameworkType> myAvailableFrameworks;
    private final LibraryRootsComponent myLibraryRootsComponent;
    private JPanel myLibrariesPanel;
    private CheckBoxList myFrameworksList;
    private JPanel myFrameworkLibrariesPanel;
    private final ExistingLibraryEditor myLibraryEditor;
    private final Map<FrameworkType, List<Module>> myTargetModulesForAddedLibraries;
    private AppServerLibrariesProvider myCurrentFrameworkLibrariesProvider;
    private Map<FrameworkType, List<File>> myFrameworkLibraries;

    public ApplicationServerConfigurable(ApplicationServerImpl applicationServer, ApplicationServersModelProvider appServersModelProvider) {
        this.$$$setupUI$$$();
        this.myAvailableFrameworks = Collections.emptyList();
        this.myTargetModulesForAddedLibraries = new HashMap<FrameworkType, List<Module>>();
        this.myFrameworkLibraries = Collections.emptyMap();
        this.myAppServersModelProvider = appServersModelProvider;
        this.myNameLabel.setLabelFor(this.myName);
        this.myAppServerInstallation = applicationServer;
        this.myServerEditor = this.createServerConfigurable();
        Library library = this.myAppServersModelProvider.getApplicationServersModel().getLibrary((ApplicationServer)this.myAppServerInstallation);
        this.myLibraryEditor = new ExistingLibraryEditor(library, null);
        Disposer.register(this.myServerEditor, (Disposable)this.myLibraryEditor);
        this.myLibraryRootsComponent = new LibraryRootsComponent(null, (LibraryEditor)this.myLibraryEditor);
        Disposer.register(this.myServerEditor, (Disposable)this.myLibraryRootsComponent);
        this.myFrameworkLibrariesPanel.setVisible(false);
        this.myServerEditor.addSettingsEditorListener((SettingsEditorListener)new SettingsEditorListener<ApplicationServerPersistentData>(){

            public void stateChanged(SettingsEditor<ApplicationServerPersistentData> settingsEditor) {
                if (ApplicationServerConfigurable.this.myIsInUpdating) {
                    return;
                }
                ApplicationServerConfigurable.this.updateFrameworkLibrariesList();
                ApplicationServerConfigurable.this.myIsModified = true;
            }
        });
        this.myServerSpecificSettings.setLayout(new BorderLayout());
        JComponent specificComponent = this.myServerEditor.getComponent();
        if (specificComponent != null) {
            this.myServerSpecificSettings.add(specificComponent);
            this.myServerSpecificSettings.setVisible(true);
        } else {
            this.myServerSpecificSettings.setVisible(false);
        }
        this.myLibrariesPanel.setLayout(new BorderLayout());
        this.myLibrariesPanel.add((Component)this.myLibraryRootsComponent.getComponent(), "Center");
        this.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                ApplicationServerConfigurable.this.myIsModified = true;
            }
        });
        this.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                ApplicationServerConfigurable.this.updateName();
            }
        });
        this.updateFrameworkLibrariesList();
    }

    private void updateFrameworkLibrariesList() {
        AppServerLibrariesProvider provider = this.getFrameworkLibrariesProvider();
        if (Comparing.equal((Object)provider, (Object)this.myCurrentFrameworkLibrariesProvider)) {
            return;
        }
        if (provider == null) {
            this.updateFrameworkLibrariesList(Collections.<FrameworkType, List<File>>emptyMap());
        } else {
            this.myFrameworksList.setEmptyText("Loading available libraries...");
            AppServerFrameworkLibrariesFetcher.fetchLibraries(provider, new ParameterizedRunnable<Map<FrameworkType, List<File>>>(){

                public void run(Map<FrameworkType, List<File>> map) {
                    ApplicationServerConfigurable.this.updateFrameworkLibrariesList(map);
                }
            });
        }
        this.myCurrentFrameworkLibrariesProvider = provider;
        this.myFrameworkLibrariesPanel.setVisible(provider != null);
    }

    private void updateFrameworkLibrariesList(@NotNull Map<FrameworkType, List<File>> frameworkLibraries) {
        if (frameworkLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkLibraries", "com/intellij/j2ee/appServerIntegrations/ApplicationServerConfigurable", "updateFrameworkLibrariesList"));
        }
        this.myFrameworkLibraries = frameworkLibraries;
        this.myAvailableFrameworks = new ArrayList<FrameworkType>(frameworkLibraries.keySet());
        this.myFrameworksList.setEmptyText("No libraries available");
        Collections.sort(this.myAvailableFrameworks, FrameworkTypeUtil.FRAMEWORK_TYPE_COMPARATOR);
        this.myFrameworksList.setItems(this.myAvailableFrameworks, (Function)new Function<FrameworkType, String>(){

            public String fun(FrameworkType frameworkType) {
                return frameworkType.getPresentableName();
            }
        });
        for (FrameworkType type : this.myAvailableFrameworks) {
            this.myFrameworksList.setItemSelected((Object)type, this.myAppServerInstallation.getFrameworkLibrary(type) != null);
        }
    }

    public String getCurrentServerName() {
        return this.myLibraryEditor.getName();
    }

    private void updateName() {
        this.myLibraryRootsComponent.renameLibrary(this.myName.getText());
    }

    @Nullable
    private ApplicationServerHelper getHelper() {
        AppServerIntegration serverIntegration = this.myAppServerInstallation.getSourceIntegration();
        return serverIntegration != null ? serverIntegration.getApplicationServerHelper() : null;
    }

    private ApplicationServerPersistentDataEditor<ApplicationServerPersistentData> createServerConfigurable() {
        ApplicationServerHelper helper = this.getHelper();
        if (helper == null) {
            return new NullApplicationServerPersistentDataEditor();
        }
        ApplicationServerPersistentDataEditor result = helper.createConfigurable();
        if (result == null) {
            return new NullApplicationServerPersistentDataEditor();
        }
        return result;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.myIsModified || this.myLibraryEditor.hasChanges() || this.isFrameworkLibrariesModified();
    }

    private boolean isFrameworkLibrariesModified() {
        for (FrameworkType type : this.myFrameworkLibraries.keySet()) {
            boolean hasLibrary;
            boolean bl = hasLibrary = this.myAppServerInstallation.getFrameworkLibrary(type) != null;
            if (this.myFrameworksList.isItemSelected((Object)type) == hasLibrary) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        this.myLibraryRootsComponent.applyProperties();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ApplicationServerConfigurable.this.myLibraryEditor.commit();
                ApplicationServersManager.ApplicationServersManagerModifiableModel serversModel = ApplicationServerConfigurable.this.myAppServersModelProvider.getApplicationServersModel();
                for (Map.Entry libraryEntry : ApplicationServerConfigurable.this.myFrameworkLibraries.entrySet()) {
                    FrameworkType type = (FrameworkType)libraryEntry.getKey();
                    if (ApplicationServerConfigurable.this.myFrameworksList.isItemSelected((Object)type)) {
                        List files = (List)libraryEntry.getValue();
                        if (files == null) continue;
                        Library library = serversModel.addFrameworkLibrary((ApplicationServer)ApplicationServerConfigurable.this.myAppServerInstallation, type, files);
                        List modules = (List)ApplicationServerConfigurable.this.myTargetModulesForAddedLibraries.get(type);
                        if (modules == null) continue;
                        for (Module module : modules) {
                            ModuleRootModificationUtil.addDependency((Module)module, (Library)library, (DependencyScope)DependencyScope.PROVIDED, (boolean)false);
                        }
                        continue;
                    }
                    serversModel.removeFrameworkLibrary((ApplicationServer)ApplicationServerConfigurable.this.myAppServerInstallation, type);
                    for (Module module : ApplicationServerConfigurable.this.getModulesDependingOnLibrary(type)) {
                        final ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                        for (OrderEntry entry : model.getOrderEntries()) {
                            if (!(entry instanceof LibraryOrderEntry) || !ApplicationServerConfigurable.this.isAppServerFrameworkLibrary(((LibraryOrderEntry)entry).getLibrary(), type)) continue;
                            model.removeOrderEntry(entry);
                        }
                        new WriteAction(){

                            protected void run(@NotNull Result result) {
                                if (result == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/j2ee/appServerIntegrations/ApplicationServerConfigurable$6$1", "run"));
                                }
                                model.commit();
                            }
                        }.execute();
                    }
                }
            }
        });
        this.myServerEditor.applyTo((Object)this.myAppServerInstallation.getPersistentData());
        this.myIsModified = false;
    }

    public void reset() {
        this.myIsInUpdating = true;
        try {
            this.myName.setText(this.myAppServerInstallation.getName());
            this.myLibraryRootsComponent.resetProperties();
            ApplicationServerPersistentData persistentData = this.myAppServerInstallation.getPersistentData();
            this.myServerEditor.resetFrom((Object)persistentData);
            this.updateFrameworkLibrariesList();
            this.myIsModified = false;
        }
        finally {
            this.myIsInUpdating = false;
        }
    }

    private AppServerLibrariesProvider getFrameworkLibrariesProvider() {
        AppServerIntegration integration = this.myAppServerInstallation.getSourceIntegration();
        ApplicationServerPersistentData persistentData = this.myAppServerInstallation.getPersistentData();
        if (integration == null || persistentData == null) {
            return null;
        }
        return integration.createLibrariesProvider(persistentData);
    }

    public void disposeUIResources() {
        Disposer.dispose(this.myServerEditor);
    }

    private void createUIComponents() {
        this.myFrameworksList = new CheckBoxList(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value) {
                FrameworkType type = (FrameworkType)ApplicationServerConfigurable.this.myFrameworksList.getItemAt(index);
                if (value) {
                    if (!ChooseModulesFromAllProjectsDialog.getAllModules().isEmpty()) {
                        ChooseModulesFromAllProjectsDialog dialog = new ChooseModulesFromAllProjectsDialog((Component)ApplicationServerConfigurable.this.myFrameworksList, "Choose Modules", "Library will be added to the selected modules");
                        dialog.show();
                        ApplicationServerConfigurable.this.myTargetModulesForAddedLibraries.put(type, dialog.getChosenElements());
                    }
                } else {
                    List modules = ApplicationServerConfigurable.this.getModulesDependingOnLibrary(type);
                    if (!modules.isEmpty()) {
                        String place = modules.size() == 1 ? "module '" + ((Module)modules.get(0)).getName() + "'" : modules.size() + "modules";
                        String text = "The '" + ApplicationServersManagerImpl.getFrameworkLibraryName(ApplicationServerConfigurable.this.myAppServerInstallation, type) + "' library is used in " + place + ".\nAre you sure you want to delete this library?";
                        if (Messages.showYesNoDialog((Component)ApplicationServerConfigurable.this.myFrameworksList, (String)text, (String)"Delete Library", (Icon)Messages.getQuestionIcon()) != 0) {
                            ApplicationServerConfigurable.this.myFrameworksList.setItemSelected((Object)type, true);
                        }
                    }
                }
            }
        });
    }

    @NotNull
    private List<Module> getModulesDependingOnLibrary(final @NotNull FrameworkType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/j2ee/appServerIntegrations/ApplicationServerConfigurable", "getModulesDependingOnLibrary"));
        }
        final ArrayList<Module> modules = new ArrayList<Module>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (final Module module : ModuleManager.getInstance((Project)project).getModules()) {
                OrderEnumerator.orderEntries((Module)module).librariesOnly().forEachLibrary((Processor)new Processor<Library>(){

                    public boolean process(Library library) {
                        if (ApplicationServerConfigurable.this.isAppServerFrameworkLibrary(library, type)) {
                            modules.add(module);
                            return false;
                        }
                        return true;
                    }
                });
            }
        }
        ArrayList<Module> arrayList = modules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/appServerIntegrations/ApplicationServerConfigurable", "getModulesDependingOnLibrary"));
        }
        return arrayList;
    }

    private boolean isAppServerFrameworkLibrary(@Nullable Library library, @NotNull FrameworkType type) {
        AppServerFrameworkLibraryProperties libraryProperties;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/j2ee/appServerIntegrations/ApplicationServerConfigurable", "isAppServerFrameworkLibrary"));
        }
        if (library == null) {
            return false;
        }
        LibraryProperties properties = ((LibraryEx)library).getProperties();
        return properties instanceof AppServerFrameworkLibraryProperties && (libraryProperties = (AppServerFrameworkLibraryProperties)properties).getFrameworkTypeId().equals(type.getId()) && libraryProperties.getServerName().equals(this.myAppServerInstallation.getName());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel4;
        this.createUIComponents();
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myName = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, 20), null));
        this.myNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.application.server.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLibrariesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/J2EEBundle").getString("label.application.server.containing.libraries"), (int)0, (int)0, null, null));
        this.myServerSpecificSettings = jPanel2 = new JPanel();
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myFrameworkLibrariesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Additional Libraries for Frameworks", 0, 0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        CheckBoxList checkBoxList = this.myFrameworksList;
        jBScrollPane.setViewportView((Component)checkBoxList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class NullApplicationServerPersistentDataEditor
    extends ApplicationServerPersistentDataEditor<ApplicationServerPersistentData> {
        private NullApplicationServerPersistentDataEditor() {
        }

        public void resetEditorFrom(ApplicationServerPersistentData applicationServerPersistentData) {
        }

        public void applyEditorTo(ApplicationServerPersistentData applicationServerPersistentData) {
        }

        public JComponent createEditor() {
            return null;
        }
    }
}

