/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbJarHighlightingVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.IdeBundle;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.model.enums.WebAppVersion;
import com.intellij.javaee.model.xml.web.FilterMapping;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebBundle;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebXmlInspection
extends BasicDomElementsInspection<WebApp> {
    private static final ElementPattern URL_PATTERN_PATTERN = StandardPatterns.not((ElementPattern)StandardPatterns.string().contains((ElementPattern)StandardPatterns.character().whitespace()));

    public WebXmlInspection() {
        super(WebApp.class, new Class[0]);
    }

    protected void checkDomElement(DomElement element, final DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        int oldSize = holder.getSize();
        if (element instanceof ServletMapping) {
            WebXmlInspection.checkUrlPatterns(holder, ((ServletMapping)element).getUrlPatterns());
        } else if (element instanceof FilterMapping) {
            FilterMapping filterMapping = (FilterMapping)element;
            List urlPatterns = filterMapping.getUrlPatterns();
            List servletNames = filterMapping.getServletNames();
            if (urlPatterns.isEmpty() && servletNames.isEmpty()) {
                holder.createProblem(element, WebBundle.message("error.message.servlet.name.or.uri.pattern.should.be.defined", new Object[0]), new LocalQuickFix[0]);
            }
            WebXmlInspection.checkUrlPatterns(holder, urlPatterns);
        } else if (element instanceof WebApp) {
            WebApp webApp = (WebApp)element;
            Consumer<GenericDomValue<String>> duplicateUrlPattern = new Consumer<GenericDomValue<String>>(){

                public void consume(GenericDomValue<String> genericDomValue) {
                    holder.createProblem(genericDomValue, WebBundle.message("error.message.duplicate.url.pattern", new Object[0]), new LocalQuickFix[0]);
                }
            };
            EjbJarHighlightingVisitor.checkDuplicates(webApp.getServletMappings(), new PairConsumer<ServletMapping, PairConsumer<GenericDomValue<String>, Object>>(){

                public void consume(ServletMapping servletMapping, PairConsumer<GenericDomValue<String>, Object> pairConsumer) {
                    for (GenericDomValue value : servletMapping.getUrlPatterns()) {
                        pairConsumer.consume((Object)value, (Object)value.getStringValue());
                    }
                }
            }, duplicateUrlPattern);
        }
        if (oldSize == holder.getSize()) {
            super.checkDomElement(element, holder, helper);
        }
    }

    private static void checkUrlPatterns(DomElementAnnotationHolder holder, List<GenericDomValue<String>> urlPatterns) {
        for (GenericDomValue<String> value : urlPatterns) {
            WebAppVersion version;
            WebApp app;
            String stringValue = value.getStringValue();
            if (!URL_PATTERN_PATTERN.accepts((Object)stringValue)) {
                holder.createProblem(value, WebBundle.message("error.message.uri.pattern.must.not.contain.whitespaces", new Object[0]), new LocalQuickFix[0]);
            }
            if (stringValue == null || !stringValue.isEmpty() || (app = (WebApp)DomUtil.getParentOfType(value, WebApp.class, (boolean)true)) == null || (version = (WebAppVersion)app.getVersion().getValue()) == null || WebAppVersion.WebAppVersion_3_0.compareTo((Enum)version) < 0) continue;
            holder.createProblem(value, IdeBundle.message((String)"value.must.not.be.empty", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = J2EEBundle.message((String)"group.names.javaee.issues", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/web/highlighting/WebXmlInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = J2EEBundle.message((String)"inspection.javaee.web.xml.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/web/highlighting/WebXmlInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("WebProperties" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/web/highlighting/WebXmlInspection", "getShortName"));
        }
        return "WebProperties";
    }
}

