/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.GenerateEqualsHelper;
import com.intellij.ide.util.PackageUtil;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.javaee.EjbDataHolder;
import com.intellij.javaee.EjbUserResponse;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeCodeStyleSettings;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.ejb.CmpFieldUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.JavaeeFieldUpdater;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.xml.DescriptionOwner;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.module.view.ejb.CreateEjbUtil;
import com.intellij.javaee.module.view.ejb.ejbLevel.EjbClassesPropertiesDialog;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.StableElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CmpFieldUpdater
extends JavaeeFieldUpdater<com.intellij.javaee.model.xml.ejb.CmpField> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.ejb.CmpFieldUpdater");
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private final boolean myWasPk;
    private boolean myPk;
    private boolean myLocalGetter;
    private boolean myRemoteGetter;
    private boolean myLocalSetter;
    private boolean myRemoteSetter;
    private final EjbUserResponse myResponse;

    public CmpFieldUpdater(final com.intellij.javaee.model.xml.ejb.EntityBean parent, String description, String name, PsiType type, boolean pk, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter, EjbUserResponse response) {
        this(new Factory<com.intellij.javaee.model.xml.ejb.CmpField>(){

            public com.intellij.javaee.model.xml.ejb.CmpField create() {
                return parent.addCmpField();
            }
        }, parent, description, null, name, null, type, false, pk, localGetter, localSetter, remoteGetter, remoteSetter, response);
    }

    public CmpFieldUpdater(final com.intellij.javaee.model.xml.ejb.CmpField field, EjbUserResponse response) {
        this(new Factory<com.intellij.javaee.model.xml.ejb.CmpField>(){

            public com.intellij.javaee.model.xml.ejb.CmpField create() {
                return field;
            }
        }, (com.intellij.javaee.model.xml.ejb.EntityBean)CommonModelManager.getInstance().getDomElement((CommonModelElement)field.getEntityBean()), null, (String)field.getFieldName().getValue(), EjbUtil.findType((CmpField)field), EjbUtil.isPK((CmpField)field), CmpFieldUtil.hasLocalGetter(field), CmpFieldUtil.hasLocalSetter(field), CmpFieldUtil.hasRemoteGetter(field), CmpFieldUtil.hasRemoteSetter(field), response);
    }

    public CmpFieldUpdater(final com.intellij.javaee.model.xml.ejb.CmpField field, String description, String name, PsiType type, boolean pk, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter, EjbUserResponse response) {
        this(new Factory<com.intellij.javaee.model.xml.ejb.CmpField>(){

            public com.intellij.javaee.model.xml.ejb.CmpField create() {
                return field;
            }
        }, (com.intellij.javaee.model.xml.ejb.EntityBean)CommonModelManager.getInstance().getDomElement((CommonModelElement)field.getEntityBean()), description, (String)field.getFieldName().getValue(), name, EjbUtil.findType((CmpField)field), type, EjbUtil.isPK((CmpField)field), pk, localGetter, localSetter, remoteGetter, remoteSetter, response);
    }

    private CmpFieldUpdater(Factory<com.intellij.javaee.model.xml.ejb.CmpField> factory, com.intellij.javaee.model.xml.ejb.EntityBean parent, String description, String name, PsiType type, boolean pk, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter, EjbUserResponse response) {
        this(factory, parent, description, name, name, type, type, pk, pk, localGetter, localSetter, remoteGetter, remoteSetter, response);
    }

    private CmpFieldUpdater(Factory<com.intellij.javaee.model.xml.ejb.CmpField> factory, com.intellij.javaee.model.xml.ejb.EntityBean parent, String description, String oldName, String newName, PsiType oldType, PsiType newType, boolean wasPk, boolean pk, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter, EjbUserResponse response) {
        super(factory, parent, oldName, description, newType, newName, oldType);
        this.myLocalGetter = localGetter;
        this.myLocalSetter = localSetter;
        this.myPk = pk;
        this.myRemoteGetter = remoteGetter;
        this.myRemoteSetter = remoteSetter;
        this.myWasPk = wasPk;
        this.myResponse = response;
    }

    public void setPk(boolean pk) {
        this.myPk = pk;
    }

    public void setGenerateAccessors(boolean localGetter, boolean remoteGetter, boolean localSetter, boolean remoteSetter) {
        this.myLocalGetter = localGetter;
        this.myRemoteGetter = remoteGetter;
        this.myLocalSetter = localSetter;
        this.myRemoteSetter = remoteSetter;
    }

    public final com.intellij.javaee.model.xml.ejb.CmpField performChange() {
        PsiField field;
        final Ref runnable = Ref.create(null);
        final Ref postRunnable = Ref.create(null);
        final String typeName = this.getNewType();
        final String oldName = this.getOldName();
        final String newName = this.getNewName();
        final GenericDomValue primkeyField = this.getParent().getPrimkeyField();
        if (!this.myWasPk) {
            if (this.myPk) {
                List<CmpField> existingsFields = EjbUtil.getPkFields((EntityBean)this.getParent());
                if (existingsFields.size() == 0) {
                    runnable.set((Object)new ThrowableRunnable<IncorrectOperationException>(){

                        public void run() throws IncorrectOperationException {
                            primkeyField.setStringValue(newName);
                            CmpFieldUpdater.this.setPrimaryKeyClass(typeName);
                        }
                    });
                } else if (existingsFields.size() == 1) {
                    final String newClassName = this.myResponse.getNewPKClassName(this.getParent());
                    if (newClassName != null) {
                        CmpField pkField = existingsFields.get(0);
                        final PsiType existingFieldType = EjbUtil.findType(pkField);
                        final String existingFieldName = (String)pkField.getFieldName().getValue();
                        runnable.set((Object)new ThrowableRunnable<IncorrectOperationException>(){

                            public void run() throws IncorrectOperationException {
                                PsiDirectory baseDir;
                                primkeyField.undefine();
                                CmpFieldUpdater.this.setPrimaryKeyClass(newClassName);
                                PsiClass pkClass = (PsiClass)CmpFieldUpdater.this.getParent().getPrimKeyClass().getValue();
                                if (pkClass == null && (baseDir = CmpFieldUpdater.this.getCompositePrimaryClassBaseDirectory(newClassName)) != null) {
                                    pkClass = new EjbDataHolder((EjbBase)CmpFieldUpdater.this.getParent()).createClass(newClassName, "#DEFAULT_CLASS_TEMPLATE", baseDir);
                                }
                                if (pkClass != null && !(pkClass instanceof PsiCompiledElement) && FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)pkClass)) {
                                    CreateEjbUtil.implementClass(pkClass, "java.io.Serializable");
                                    CmpFieldUpdater.addFieldToPKClass(pkClass, existingFieldName, existingFieldType);
                                    CmpFieldUpdater.addFieldToPKClass(pkClass, newName, (PsiType)CmpFieldUpdater.createPsiType(pkClass));
                                    CmpFieldUpdater.this.queueRegenerateEqualsHashCode((Ref<ThrowableRunnable<IncorrectOperationException>>)postRunnable);
                                }
                            }
                        });
                    }
                } else {
                    runnable.set((Object)new ThrowableRunnable<IncorrectOperationException>(){

                        public void run() throws IncorrectOperationException {
                            PsiClass pkClass = (PsiClass)CmpFieldUpdater.this.getParent().getPrimKeyClass().getValue();
                            if (pkClass != null && FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)pkClass)) {
                                CmpFieldUpdater.addFieldToPKClass(pkClass, newName, (PsiType)CmpFieldUpdater.createPsiType(pkClass));
                                CmpFieldUpdater.this.queueRegenerateEqualsHashCode((Ref<ThrowableRunnable<IncorrectOperationException>>)postRunnable);
                            }
                        }
                    });
                }
            }
        } else {
            final PsiClass pkClass = (PsiClass)this.getParent().getPrimKeyClass().getValue();
            if (!this.myPk) {
                if (pkClass != null && newName != null) {
                    runnable.set((Object)new ThrowableRunnable<IncorrectOperationException>(){

                        public void run() throws IncorrectOperationException {
                            if (newName.equals(primkeyField.getStringValue())) {
                                primkeyField.undefine();
                                JavaeeCodeStyleSettings javaeeSettings = (JavaeeCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)CmpFieldUpdater.this.getParent().getManager().getProject()).getCustomSettings(JavaeeCodeStyleSettings.class);
                                CmpFieldUpdater.this.getParent().getPrimKeyClass().setStringValue(javaeeSettings.ENTITY_PK_CLASS);
                            } else if (!(pkClass instanceof PsiCompiledElement) && FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)pkClass)) {
                                JavaeeFieldUpdater.deleteField(pkClass, oldName);
                                int pkFieldCount = EjbUtil.getPkFields((EntityBean)CmpFieldUpdater.this.getParent()).size();
                                if (pkFieldCount == 1) {
                                    CmpFieldUpdater.this.tryToRemovePrimaryKeyClass();
                                } else if (pkFieldCount > 1) {
                                    CmpFieldUpdater.this.queueRegenerateEqualsHashCode((Ref<ThrowableRunnable<IncorrectOperationException>>)postRunnable);
                                }
                            }
                        }
                    });
                }
            } else if (pkClass != null && (field = pkClass.findFieldByName(oldName, true)) != null && pkClass.getManager().isInProject((PsiElement)field)) {
                postRunnable.set((Object)new ThrowableRunnable<IncorrectOperationException>(){

                    public void run() throws IncorrectOperationException {
                        new RenameProcessor(CmpFieldUpdater.this.getParent().getManager().getProject(), (PsiElement)field, newName, false, false).run();
                    }
                });
            }
        }
        Project project = this.getParent().getManager().getProject();
        field = (StableElement)new WriteCommandAction<StableElement<com.intellij.javaee.model.xml.ejb.CmpField>>(project, new PsiFile[]{this.getParent().getContainingFile()}){

            protected void run(@NotNull Result<StableElement<com.intellij.javaee.model.xml.ejb.CmpField>> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/ejb/CmpFieldUpdater$9", "run"));
                }
                com.intellij.javaee.model.xml.ejb.CmpField field = (com.intellij.javaee.model.xml.ejb.CmpField)CmpFieldUpdater.this.getFactory().create();
                result.setResult((Object)((StableElement)field.createStableCopy()));
                boolean wasPrimKeyField = field.equals(primkeyField.getValue());
                field.getFieldName().setValue((Object)newName);
                if (wasPrimKeyField) {
                    primkeyField.setValue((Object)field);
                    String value = CmpFieldUpdater.this.getNewType();
                    if (value != null) {
                        CmpFieldUpdater.this.getParent().getPrimKeyClass().setStringValue(value);
                    }
                }
                JavaeeUtil.setDescription((DescriptionOwner)field, CmpFieldUpdater.this.getDescription());
                if (CmpFieldUpdater.this.getParent().getCmpVersion().getValue() == CmpVersion.CmpVersion_1_X) {
                    CmpFieldUpdater.this.createProperty();
                }
                CmpFieldUpdater.this.updatePropertyGetters();
                CmpFieldUpdater.this.updatePropertySetters();
                CmpFieldUpdater.runRunnable((Ref<ThrowableRunnable<IncorrectOperationException>>)runnable);
            }
        }.execute().getResultObject();
        CmpFieldUpdater.runRunnable((Ref<ThrowableRunnable<IncorrectOperationException>>)postRunnable);
        return (com.intellij.javaee.model.xml.ejb.CmpField)field.getWrappedElement();
    }

    private static void runRunnable(Ref<ThrowableRunnable<IncorrectOperationException>> runnable) {
        ThrowableRunnable runnable1 = (ThrowableRunnable)runnable.get();
        if (runnable1 != null) {
            try {
                runnable1.run();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void queueRegenerateEqualsHashCode(Ref<ThrowableRunnable<IncorrectOperationException>> postRunnable) {
        postRunnable.set((Object)new ThrowableRunnable<IncorrectOperationException>(){

            public void run() throws IncorrectOperationException {
                CmpFieldUpdater.this.regenerateEqualsAndHashCode();
            }
        });
    }

    private void tryToRemovePrimaryKeyClass() throws IncorrectOperationException {
        List<CmpField> pkFields;
        String pkClassName = this.getParent().getPrimKeyClass().getStringValue();
        PsiClass psiClass = null;
        if (pkClassName != null && !this.pkClassHasAnotherUsages()) {
            psiClass = (PsiClass)this.getParent().getPrimKeyClass().getValue();
        }
        if ((pkFields = EjbUtil.getPkFields((EntityBean)this.getParent())).size() == 1) {
            this.setPkField(pkFields.get(0));
        }
        if (psiClass != null && FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)psiClass)) {
            psiClass.delete();
        }
    }

    public final void setPkField(CmpField pkField) {
        PsiType type = EjbUtil.findType(pkField);
        if (type != null) {
            this.setPrimaryKeyClass(type.getCanonicalText());
        }
        this.getParent().getPrimkeyField().setValue((Object)pkField);
    }

    private boolean pkClassHasAnotherUsages() {
        final GenericDomValue genericDomValue = this.getParent().getPrimKeyClass();
        final PsiClass pkClass = (PsiClass)genericDomValue.getValue();
        if (pkClass == null) {
            return false;
        }
        final boolean[] result = new boolean[]{false};
        DomElement domElement = DomUtil.getRoot((DomElement)this.getParent());
        domElement.accept(new DomElementVisitor(){

            public void visitDomElement(DomElement element) {
                if (result[0]) {
                    return;
                }
                if (genericDomValue != element && element instanceof GenericDomValue) {
                    GenericDomValue domValue = (GenericDomValue)element;
                    Object value = domValue.getValue();
                    if (value == pkClass) {
                        result[0] = true;
                    }
                } else {
                    element.acceptChildren((DomElementVisitor)this);
                }
            }
        });
        return result[0];
    }

    @Nullable
    private PsiDirectory getBaseDir() {
        for (Pair<PsiClass, String> ownedClass : EjbClassesPropertiesDialog.collectRequiredClasses((EjbBase)this.getParent())) {
            PsiClass psiClass = (PsiClass)ownedClass.first;
            if (psiClass == null) continue;
            return psiClass.getContainingFile().getParent();
        }
        return null;
    }

    private void regenerateEqualsAndHashCode() {
        if (EjbUtil.getPkFields((EntityBean)this.getParent()).size() == 1) {
            return;
        }
        final PsiClass pkClass = (PsiClass)this.getParent().getPrimKeyClass().getValue();
        if (pkClass == null) {
            return;
        }
        if (this.myResponse.showYesNoDialog(J2EEBundle.message((String)"confirmation.text.regenerate.equals.and.hashcode.for.class", (Object[])new Object[]{pkClass.getQualifiedName()}), J2EEBundle.message((String)"message.title.primary.key.class.changed", (Object[])new Object[0]), Messages.getQuestionIcon()) != 0) {
            return;
        }
        final PsiClass object = JavaPsiFacade.getInstance((Project)pkClass.getProject()).findClass(JAVA_LANG_OBJECT, pkClass.getResolveScope());
        if (object == null) {
            CmpFieldUpdater.reportObjectNotFound();
            return;
        }
        new WriteCommandAction(pkClass.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/ejb/CmpFieldUpdater$12", "run"));
                }
                JavaeeFieldUpdater.deleteMethod(pkClass, "equals", new PsiType[]{JavaPsiFacade.getInstance((Project)pkClass.getProject()).getElementFactory().createType(object)});
                JavaeeFieldUpdater.deleteMethod(pkClass, "hashCode", new PsiType[0]);
                PsiField[] fields = pkClass.getFields();
                new GenerateEqualsHelper(pkClass.getProject(), pkClass, fields, fields, PsiField.EMPTY_ARRAY, false).run();
            }
        }.execute();
    }

    @Nullable
    private PsiDirectory getCompositePrimaryClassBaseDirectory(String newClassName) throws IncorrectOperationException {
        PsiDirectory baseDir = this.getBaseDir();
        Module module = this.getParent().getModule();
        if (baseDir == null) {
            baseDir = PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)"", null, (boolean)false);
        } else {
            String packageName = ClassUtil.extractPackageName((String)newClassName);
            baseDir = PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)packageName, (PsiDirectory)baseDir, (boolean)false);
            if (baseDir != null) {
                baseDir = CmpFieldUpdater.goToSourceDir(baseDir, packageName);
            }
        }
        return baseDir;
    }

    private static PsiClassType createPsiType(PsiClass pkClass) {
        return JavaPsiFacade.getInstance((Project)pkClass.getProject()).getElementFactory().createType(pkClass);
    }

    private void setPrimaryKeyClass(String className) {
        try {
            this.fixFindByPrimaryKeySignatureIn((PsiClass)this.getParent().getHome().getValue(), className);
            this.fixFindByPrimaryKeySignatureIn((PsiClass)this.getParent().getLocalHome().getValue(), className);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        this.getParent().getPrimKeyClass().setStringValue(className);
    }

    private static void addFieldToPKClass(PsiClass pkClass, String name, PsiType type) throws IncorrectOperationException {
        if (type == null) {
            return;
        }
        if (pkClass.findFieldByName(name, true) != null) {
            return;
        }
        PsiManager psiManager = pkClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        PsiField newField = factory.createField(name, type);
        PsiUtil.setModifierProperty((PsiModifierListOwner)newField, (String)"public", (boolean)true);
        pkClass.add((PsiElement)newField);
    }

    @Nullable
    private static PsiDirectory goToSourceDir(PsiDirectory baseDir, String packageName) {
        if (packageName == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(packageName, "");
        while (stringTokenizer.hasMoreTokens()) {
            names.add(stringTokenizer.nextToken());
        }
        Collections.reverse(names);
        for (String name : names) {
            if (baseDir == null) {
                return null;
            }
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(baseDir);
            if (aPackage == null) {
                return null;
            }
            if (!Comparing.equal((String)name, (String)aPackage.getName(), (boolean)true)) {
                return null;
            }
            baseDir = baseDir.getParent();
        }
        return baseDir;
    }

    private static void reportObjectNotFound() {
        Messages.showErrorDialog((String)J2EEBundle.message((String)"message.text.class.not.fount.in.project", (Object[])new Object[]{JAVA_LANG_OBJECT}), (String)J2EEBundle.message((String)"message.title.class.not.found", (Object[])new Object[]{JAVA_LANG_OBJECT}));
    }

    private void fixFindByPrimaryKeySignatureIn(PsiClass interfaceClass, String newPrimaryKeyClass) throws IncorrectOperationException {
        if (interfaceClass == null || newPrimaryKeyClass == null) {
            return;
        }
        String pkClass = this.getParent().getPrimKeyClass().getStringValue();
        if (pkClass == null) {
            return;
        }
        for (PsiMethod method : interfaceClass.findMethodsByName("findByPrimaryKey", false)) {
            PsiParameter parameter;
            String parameterTypeText;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1 || !Comparing.equal((String)(parameterTypeText = (parameter = parameters[0]).getType().getCanonicalText()), (String)pkClass)) continue;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)parameter.getProject()).getElementFactory();
            PsiClassType type = factory.createTypeByFQClassName(newPrimaryKeyClass, GlobalSearchScope.allScope((Project)this.getParent().getManager().getProject()));
            parameter.replace((PsiElement)factory.createParameter(parameter.getName(), (PsiType)type));
        }
    }

    private void updatePropertyGetters() throws IncorrectOperationException {
        this.updateGetter((PsiClass)this.getParent().getEjbClass().getValue(), false, true);
        this.updateGetter((PsiClass)this.getParent().getLocal().getValue(), false, this.myLocalGetter);
        this.updateGetter((PsiClass)this.getParent().getRemote().getValue(), true, this.myRemoteGetter);
    }

    private void updatePropertySetters() throws IncorrectOperationException {
        this.updateSetter((PsiClass)this.getParent().getEjbClass().getValue(), false, true);
        this.updateSetter((PsiClass)this.getParent().getLocal().getValue(), false, this.myLocalSetter);
        this.updateSetter((PsiClass)this.getParent().getRemote().getValue(), true, this.myRemoteSetter);
    }

    private void createProperty() throws IncorrectOperationException {
        PsiClass ejbClass = (PsiClass)this.getParent().getEjbClass().getValue();
        String newType = this.getNewType();
        if (this.getNewName() == null || newType == null || ejbClass == null) {
            return;
        }
        if (ejbClass.findFieldByName(this.getNewName(), false) == null) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)ejbClass.getProject()).getElementFactory();
            PsiField psiField = factory.createField(this.getNewName(), factory.createTypeFromText(newType, (PsiElement)ejbClass));
            PsiUtil.setModifierProperty((PsiModifierListOwner)psiField, (String)"public", (boolean)true);
            ejbClass.add((PsiElement)psiField);
        }
    }
}

