/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.migration;

import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.migration.ApplyJavaeeStyleDialog;
import com.intellij.javaee.model.common.EnvironmentGroup;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ApplyJavaeeStyleHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleHandler", "invoke"));
        }
        this.invoke(project, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleHandler", "invoke"));
        }
        this.invoke(project, dataContext);
    }

    private void invoke(Project project, DataContext dataContext) {
        Collection ejbFacets;
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (project == null) {
            return;
        }
        final ArrayList<Object> selectedObjects = new ArrayList<Object>();
        EjbFacet ejbFacet = null;
        if (module != null && !(ejbFacets = EjbFacet.getInstances((Module)module)).isEmpty()) {
            ejbFacet = (EjbFacet)ejbFacets.iterator().next();
        }
        if (ejbFacet != null) {
            selectedObjects.addAll(EjbUtil.getAllEnvironmentGroups(project, null, ejbFacet));
        } else if (virtualFile != null) {
            selectedObjects.addAll(EjbUtil.getEnterpriseBeansAndInterceptors(virtualFile, project));
            if (selectedObjects.size() == 0) {
                return;
            }
            ejbFacet = EjbUtil.getEjbFacet((JavaeeModelElement)selectedObjects.iterator().next());
            if (ejbFacet == null) {
                return;
            }
        } else {
            return;
        }
        ApplyJavaeeStyleDialog dialog = new ApplyJavaeeStyleDialog(project, ejbFacet, new Processor<EnvironmentGroup>(){

            public boolean process(EnvironmentGroup environmentGroup) {
                return selectedObjects.contains(environmentGroup);
            }
        });
        dialog.show();
    }
}

