/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations.ejb;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamAnnotation;
import com.intellij.jam.annotations.JamAttribute;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.annotations.ejb.EjbMethodImpl;
import com.intellij.javaee.model.annotations.ejb.EnvironmentGroupImpl;
import com.intellij.javaee.model.annotations.ejb.InterceptorImpl;
import com.intellij.javaee.model.annotations.ejb.SecurityRoleImpl;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.InterceptorMethod;
import com.intellij.javaee.model.common.ejb.SecurityRole;
import com.intellij.javaee.model.enums.TransAttribute;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnterpriseBeanImpl
extends EnvironmentGroupImpl
implements EnterpriseBean {
    public static final JamStringAttributeMeta.Single<String> NAME_ATTRIBUTE_META = JamAttributeMeta.singleString((String)"name");
    public static final JamAnnotationArchetype EJB_ANNO_NAME_META = new JamAnnotationArchetype().addAttribute(NAME_ATTRIBUTE_META);
    public static final JamAttributeMeta<JamEnumAttributeElement<TransAttribute>> TRANSACTION_ATTRIBUTE_VALUE_META = JamAttributeMeta.singleEnum((String)"value", TransAttribute.class);
    public static final JamAnnotationMeta TRANSACTION_ATTRIBUTE_META = new JamAnnotationMeta("javax.ejb.TransactionAttribute").addAttribute(TRANSACTION_ATTRIBUTE_VALUE_META);
    public static final JamAttributeMeta<JamStringAttributeElement<SecurityRole>> RUN_AS_VALUE_META = JamAttributeMeta.singleString((String)"value", (JamConverter)new JamConverter<SecurityRole>(){

        public SecurityRole fromString(@Nullable String s, JamStringAttributeElement<SecurityRole> context) {
            EjbClassRole[] ejbRoles;
            if (StringUtil.isEmpty((String)s)) {
                return null;
            }
            for (EjbClassRole ejbRole : ejbRoles = EjbHelper.getEjbHelper().getEjbRoles((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context.getParentAnnotationElement().getRoot(), PsiClass.class, (boolean)true))) {
                for (SecurityRole securityRole : ejbRole.getFacet().getMergedRoot().getSecurityRoles()) {
                    if (!Comparing.equal((String)((String)securityRole.getRoleName().getValue()), (String)s)) continue;
                    return securityRole;
                }
            }
            return null;
        }
    });
    public static final JamAnnotationMeta RUN_AS_META = new JamAnnotationMeta("javax.annotation.security.RunAs").addAttribute(RUN_AS_VALUE_META);
    public static final JamAttributeMeta<List<JamStringAttributeElement<SecurityRoleImpl>>> ROLES_COLLECTION_VALUE_META = JamAttributeMeta.collectionString((String)"value", (JamConverter)new JamConverter<SecurityRoleImpl>(){

        public SecurityRoleImpl fromString(@Nullable String s, JamStringAttributeElement<SecurityRoleImpl> context) {
            return new SecurityRoleImpl(s, context.getPsiLiteral());
        }
    });
    public static final JamAnnotationMeta DECLARE_ROLES_META = new JamAnnotationMeta("javax.annotation.security.DeclareRoles").addAttribute(ROLES_COLLECTION_VALUE_META);
    public static final JamAnnotationMeta ROLES_ALLOWED_META = new JamAnnotationMeta("javax.annotation.security.RolesAllowed").addAttribute(ROLES_COLLECTION_VALUE_META);
    public static final JamMemberArchetype<PsiClass, EnterpriseBeanImpl> EJB_META_ARCHETYPE = new JamMemberArchetype(ENV_GROUP_ARCHETYPE).addAnnotation(TRANSACTION_ATTRIBUTE_META).addAnnotation(DECLARE_ROLES_META).addAnnotation(ROLES_ALLOWED_META).addPomTargetProducer((PairConsumer)new PairConsumer<EnterpriseBeanImpl, Consumer<PomTarget>>(){

        public void consume(EnterpriseBeanImpl ejb, Consumer<PomTarget> consumer) {
            consumer.consume((Object)ejb.getPomTarget());
        }
    });

    public EnterpriseBeanImpl(PsiClass psiClass) {
        super(psiClass);
    }

    @NotNull
    public EjbDescriptorVersion getEjbVersion() {
        EjbDescriptorVersion ejbDescriptorVersion = EjbDescriptorVersion.EJB_VERSION_3_0;
        if (ejbDescriptorVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/annotations/ejb/EnterpriseBeanImpl", "getEjbVersion"));
        }
        return ejbDescriptorVersion;
    }

    protected abstract PsiElementRef<PsiAnnotation> getAnnoRef();

    public JamStringAttributeElement<String> getEjbName() {
        return NAME_ATTRIBUTE_META.getJam(this.getAnnoRef(), (Factory)new NullableFactory<String>(){

            public String create() {
                return EnterpriseBeanImpl.this.getPsiClass().getName();
            }
        });
    }

    public GenericValue<PsiClass> getEjbClass() {
        return AnnotationGenericValue.getInstance(this.getPsiClass(), (PsiAnnotation)this.getAnnoRef().getPsiElement(), null);
    }

    public void processInterceptorMethods(PsiClass currentClass, Processor<InterceptorMethod> processor) {
        boolean processDeep;
        PsiClass topClass = this.getPsiClass();
        boolean bl = processDeep = currentClass == null;
        if (topClass == null || !processDeep && topClass != currentClass && !topClass.isInheritor(currentClass, true)) {
            return;
        }
        InterceptorImpl.processInterceptorMethodsImpl(processDeep ? topClass : currentClass, processor, processDeep);
    }

    public JamEnumAttributeElement<TransAttribute> getTransactionAttribute() {
        return (JamEnumAttributeElement)TRANSACTION_ATTRIBUTE_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), TRANSACTION_ATTRIBUTE_VALUE_META);
    }

    public GenericValue<? extends SecurityRole> getRunAs() {
        return (GenericValue)RUN_AS_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), RUN_AS_VALUE_META);
    }

    public List<EjbMethodImpl> getEjbMethods() {
        return JamService.getJamService((Project)this.getPsiClass().getProject()).getAnnotatedMembersList(this.getPsiClass(), false, true, false, true, new JamMemberMeta[]{EjbMethodImpl.METHOD_META});
    }

    public GenericValue<Boolean> isPermitAll() {
        return AnnotationModelUtil.getBooleanValue(this.findAnnotation("javax.annotation.security.PermitAll"));
    }

    public GenericValue<Boolean> isDenyAll() {
        return AnnotationModelUtil.getBooleanValue(this.findAnnotation("javax.annotation.security.DenyAll"));
    }

    public List<SecurityRoleImpl> getSecurityRoleRefs() {
        ArrayList result = ContainerUtil.newArrayList();
        for (JamStringAttributeElement<SecurityRoleImpl> jamStringAttributeElement : this.getDeclaredRoles()) {
            ContainerUtil.addIfNotNull((Object)jamStringAttributeElement.getValue(), (Collection)result);
        }
        for (JamStringAttributeElement jamStringAttributeElement : this.getRolesAllowed()) {
            ContainerUtil.addIfNotNull((Object)jamStringAttributeElement.getValue(), (Collection)result);
        }
        return result;
    }

    public List<JamStringAttributeElement<SecurityRoleImpl>> getDeclaredRoles() {
        return (List)DECLARE_ROLES_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), ROLES_COLLECTION_VALUE_META);
    }

    public List<JamStringAttributeElement<SecurityRoleImpl>> getRolesAllowed() {
        return (List)ROLES_ALLOWED_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), ROLES_COLLECTION_VALUE_META);
    }

    public GenericValue<Boolean> isExcludeDefaultInterceptors() {
        return AnnotationModelUtil.getBooleanValue(this.findAnnotation("javax.interceptor.ExcludeDefaultInterceptors"));
    }

    @JamAnnotation(value="javax.interceptor.Interceptors")
    @JamAttribute(value="value")
    public abstract List<JamClassAttributeElement> getClassInterceptors();

    public GenericValue<PsiClass> getHome() {
        return AnnotationGenericValue.nullInstance();
    }

    public GenericValue<PsiClass> getRemote() {
        return AnnotationGenericValue.nullInstance();
    }

    public GenericValue<PsiClass> getLocalHome() {
        return AnnotationGenericValue.nullInstance();
    }

    public GenericValue<PsiClass> getLocal() {
        return AnnotationGenericValue.nullInstance();
    }

    private PomTarget getPomTarget() {
        JamStringAttributeElement<String> nameValue = this.getEjbName();
        return nameValue.getPsiLiteral() == null ? this.getPsiClass() : new JamPomTarget((JamElement)this, nameValue);
    }

    public PsiElement getIdentifyingPsiElement() {
        return PomService.convertToPsi((Project)this.getPsiClass().getProject(), (PomTarget)this.getPomTarget());
    }
}

