/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.annotations.ejb;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.annotations.JamAnnotation;
import com.intellij.jam.annotations.JamAttribute;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.ejb.NonEntityBeanImpl;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.semantic.SemKey;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.GenericValueUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class SessionBeanImpl
extends NonEntityBeanImpl
implements SessionBean {
    public static final JamAnnotationMeta REMOTE_META = new JamAnnotationMeta("javax.ejb.Remote").addAttribute((JamAttributeMeta)JamAttributeMeta.CLASS_VALUE_META);
    public static final JamAnnotationMeta LOCAL_META = new JamAnnotationMeta("javax.ejb.Local").addAttribute((JamAttributeMeta)JamAttributeMeta.CLASS_VALUE_META);
    public static final JamAnnotationMeta LOCAL_HOME_META = new JamAnnotationMeta("javax.ejb.LocalHome").addAttribute((JamAttributeMeta)JamAttributeMeta.CLASS_VALUE_META);
    public static final JamAnnotationMeta REMOTE_HOME_META = new JamAnnotationMeta("javax.ejb.RemoteHome").addAttribute((JamAttributeMeta)JamAttributeMeta.CLASS_VALUE_META);
    public static final JamMemberArchetype<PsiClass, SessionBeanImpl> SESSION_ARCHETYPE = new JamMemberArchetype(EJB_META_ARCHETYPE).addAnnotation(REMOTE_META).addAnnotation(LOCAL_META).addAnnotation(REMOTE_HOME_META).addAnnotation(LOCAL_HOME_META);
    public static final JamClassMeta<Stateful> STATEFUL_META = new JamClassMeta(SESSION_ARCHETYPE, Stateful.class, JAVAEE_ENVIRONMENT_KEY.subKey("@Stateful", new SemKey[0])).addRootAnnotation(new JamAnnotationMeta("javax.ejb.Stateful", EJB_ANNO_NAME_META));
    public static final JamClassMeta<Stateless> STATELESS_META = new JamClassMeta(SESSION_ARCHETYPE, Stateless.class, JAVAEE_ENVIRONMENT_KEY.subKey("@Stateless", new SemKey[0])).addRootAnnotation(new JamAnnotationMeta("javax.ejb.Stateless", EJB_ANNO_NAME_META));
    public static final JamClassMeta<Singleton> SINGLETON_META = new JamClassMeta(SESSION_ARCHETYPE, Singleton.class, JAVAEE_ENVIRONMENT_KEY.subKey("@Singleton", new SemKey[0])).addRootAnnotation(new JamAnnotationMeta("javax.ejb.Singleton", EJB_ANNO_NAME_META));

    public SessionBeanImpl(PsiClass psiClass) {
        super(psiClass);
    }

    @JamAnnotation(value="javax.jws.WebService")
    @JamAttribute(value="endpointInterface")
    public abstract JamClassAttributeElement getServiceEndpoint();

    public List<GenericValue<PsiClass>> getBusinessLocals() {
        return new ArrayList<GenericValue<PsiClass>>(this.collectBusinessInterfaces(true, false));
    }

    public List<GenericValue<PsiClass>> getBusinessRemotes() {
        return new ArrayList<GenericValue<PsiClass>>(this.collectBusinessInterfaces(false, true));
    }

    public GenericValue<Boolean> getLocalBean() {
        PsiAnnotation annotation = this.findAnnotation("javax.ejb.LocalBean");
        return AnnotationGenericValue.getInstance(annotation != null || this.getBusinessInterfaces().contains(this.getEjbClass()), annotation, null);
    }

    public List<GenericValue<PsiClass>> getBusinessInterfaces() {
        Collection<GenericValue<PsiClass>> collection = this.collectBusinessInterfaces(true, true);
        JamClassAttributeElement service = this.getServiceEndpoint();
        if (!service.getParentAnnotationElement().isImaginary()) {
            collection.add((GenericValue<PsiClass>)service);
        }
        if (collection.isEmpty() && EjbDescriptorVersion.EJB_VERSION_3_1.compareTo((Enum)EjbUtil.getVersion((JavaeeModelElement)this)) <= 0) {
            collection.add(this.getEjbClass());
        }
        return new ArrayList<GenericValue<PsiClass>>(collection);
    }

    protected Collection<GenericValue<PsiClass>> collectBusinessInterfaces(boolean local, boolean remote) {
        boolean hasEmptyLocal;
        LinkedHashSet<GenericValue<PsiClass>> result = new LinkedHashSet<GenericValue<PsiClass>>();
        PsiClass ejbClass = (PsiClass)this.getEjbClass().getValue();
        if (ejbClass == null) {
            return result;
        }
        List locals = (List)LOCAL_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), (JamAttributeMeta)JamAttributeMeta.CLASS_COLLECTION_VALUE_META);
        List remotes = (List)REMOTE_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), (JamAttributeMeta)JamAttributeMeta.CLASS_COLLECTION_VALUE_META);
        boolean hasRemoteAnno = REMOTE_META.getAnnotation((PsiModifierListOwner)ejbClass) != null;
        boolean hasEmptyRemote = hasRemoteAnno && remotes.isEmpty();
        boolean bl = hasEmptyLocal = LOCAL_META.getAnnotation((PsiModifierListOwner)ejbClass) != null && locals.isEmpty();
        if (local) {
            result.addAll(locals);
        }
        if (remote) {
            result.addAll(remotes);
        }
        for (PsiClass aClass : ejbClass.getInterfaces()) {
            if (this.isStandardInterface(aClass.getQualifiedName())) continue;
            for (PsiClass psiInterface : JamCommonUtil.getSuperClassList((PsiClass)aClass)) {
                boolean addAsRemote;
                String qName = psiInterface.getQualifiedName();
                if (this.isStandardInterface(qName)) continue;
                boolean explicitRemote = REMOTE_META.getAnnotation((PsiModifierListOwner)psiInterface) != null || GenericValueUtil.containsString((Collection)remotes, (String)qName);
                boolean explicitLocal = LOCAL_META.getAnnotation((PsiModifierListOwner)psiInterface) != null || GenericValueUtil.containsString((Collection)locals, (String)qName);
                boolean addAsLocal = explicitLocal || !explicitRemote && (hasEmptyLocal || !hasEmptyRemote);
                boolean bl2 = addAsRemote = explicitRemote || !explicitLocal && hasEmptyRemote;
                if (local && addAsLocal) {
                    result.add((GenericValue<PsiClass>)this.createClassValue(LOCAL_META, psiInterface));
                }
                if (!remote || !addAsRemote) continue;
                result.add((GenericValue<PsiClass>)this.createClassValue(REMOTE_META, psiInterface));
            }
        }
        return result;
    }

    private JamClassAttributeElement createClassValue(JamAnnotationMeta meta, final PsiClass value) {
        return JamAttributeMeta.CLASS_VALUE_META.getJam(meta.getAnnotationRef((PsiModifierListOwner)this.getPsiClass()), (Factory)new Factory<PsiClass>(){

            public PsiClass create() {
                return value;
            }
        });
    }

    @Override
    public GenericValue<PsiClass> getHome() {
        return (GenericValue)REMOTE_HOME_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), (JamAttributeMeta)JamAttributeMeta.CLASS_VALUE_META);
    }

    @Override
    public GenericValue<PsiClass> getLocalHome() {
        return (GenericValue)LOCAL_HOME_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), (JamAttributeMeta)JamAttributeMeta.CLASS_VALUE_META);
    }

    public static abstract class Singleton
    extends SessionBeanImpl {
        public Singleton(PsiClass psiClass) {
            super(psiClass);
        }

        @Override
        protected JamClassMeta<?> getClassMeta() {
            return SINGLETON_META;
        }

        @Override
        protected PsiElementRef<PsiAnnotation> getAnnoRef() {
            return AnnotationChildLink.createRef((PsiModifierListOwner)this.getPsiClass(), (String)"javax.ejb.Singleton");
        }

        public GenericValue<SessionType> getSessionType() {
            return AnnotationGenericValue.getInstance(SessionType.SINGLETON, (PsiAnnotation)this.getAnnoRef().getPsiElement(), null);
        }
    }

    public static abstract class Stateless
    extends SessionBeanImpl {
        public Stateless(PsiClass psiClass) {
            super(psiClass);
        }

        @Override
        protected JamClassMeta<?> getClassMeta() {
            return STATELESS_META;
        }

        @Override
        protected PsiElementRef<PsiAnnotation> getAnnoRef() {
            return AnnotationChildLink.createRef((PsiModifierListOwner)this.getPsiClass(), (String)"javax.ejb.Stateless");
        }

        public GenericValue<SessionType> getSessionType() {
            return AnnotationGenericValue.getInstance(SessionType.STATELESS, (PsiAnnotation)this.getAnnoRef().getPsiElement(), null);
        }
    }

    public static abstract class Stateful
    extends SessionBeanImpl {
        public Stateful(PsiClass psiClass) {
            super(psiClass);
        }

        @Override
        protected JamClassMeta<?> getClassMeta() {
            return STATEFUL_META;
        }

        @Override
        protected PsiElementRef<PsiAnnotation> getAnnoRef() {
            return AnnotationChildLink.createRef((PsiModifierListOwner)this.getPsiClass(), (String)"javax.ejb.Stateful");
        }

        public GenericValue<SessionType> getSessionType() {
            return AnnotationGenericValue.getInstance(SessionType.STATEFUL, (PsiAnnotation)this.getAnnoRef().getPsiElement(), null);
        }
    }
}

