/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.ejbLevel;

import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.treetable.JamTreeTableView;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.xml.ejb.AssemblyDescriptor;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.InterceptorBinding;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.javaee.module.view.ejb.businessTree.EjbBusinessTreeModuleNodeDescriptor;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.util.AnnotationTextUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class InterceptorBindingsPanel
implements Disposable {
    private JPanel myPanel;
    private JPanel myTreePanel;
    private JCheckBox myDefaultInterceptor;
    private final EjbFacet myEjbFacet;
    private final Project myProject;
    private final EjbBusinessTreeView myTreeView;
    private final HashMap<PsiMember, String> targetMembers;
    private boolean isDefaultInterceptor;
    private final String myInterceptorClass;

    public InterceptorBindingsPanel(Project project, EjbFacet ejbFacet, String interceptorClass) {
        this.$$$setupUI$$$();
        this.targetMembers = new HashMap();
        this.isDefaultInterceptor = false;
        this.myInterceptorClass = interceptorClass;
        this.myEjbFacet = ejbFacet;
        this.myProject = project;
        this.initInterceptorBindings();
        this.myTreeView = new EjbBusinessTreeView(this.myProject, ejbFacet, this.targetMembers);
        Disposer.register((Disposable)this, (Disposable)this.myTreeView);
        this.setupControls();
        this.refreshControls();
    }

    private void initInterceptorBindings() {
        this.targetMembers.clear();
        this.processInterceptorBindings(new PairProcessor<com.intellij.javaee.model.common.ejb.InterceptorBinding, String>(){

            public boolean process(com.intellij.javaee.model.common.ejb.InterceptorBinding s, String t) {
                if (s.getTargetMember() != null) {
                    InterceptorBindingsPanel.this.targetMembers.put(s.getTargetMember(), t);
                } else if ("*".equals(s.getEjbName())) {
                    InterceptorBindingsPanel.this.isDefaultInterceptor = true;
                }
                return true;
            }
        });
    }

    private void processInterceptorBindings(final PairProcessor<com.intellij.javaee.model.common.ejb.InterceptorBinding, String> processor) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myInterceptorClass, GlobalSearchScope.moduleScope((Module)this.myEjbFacet.getModule()));
        for (EjbClassRole role : OldEjbRolesUtil.getEjbRoles(aClass)) {
            if (role.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) continue;
            role.getInterceptor().processInterceptorBindings((Processor)new Processor<com.intellij.javaee.model.common.ejb.InterceptorBinding>(){

                public boolean process(com.intellij.javaee.model.common.ejb.InterceptorBinding binding) {
                    PsiMember member = binding.getTargetMember();
                    if (binding.getEjbName() == null) {
                        if (member != null) {
                            for (EjbClassRole memberRole : OldEjbRolesUtil.getEjbRoles(member instanceof PsiClass ? (PsiClass)member : member.getContainingClass())) {
                                if (memberRole.getEnterpriseBean() == null || processor.process((Object)binding, memberRole.getEnterpriseBean().getEjbName().getValue())) continue;
                                return false;
                            }
                        }
                    } else if (!processor.process((Object)binding, (Object)binding.getEjbName())) {
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    private void refreshControls() {
        this.updateOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeView.getTreeTableView();
    }

    public void dispose() {
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private void setupControls() {
        this.myDefaultInterceptor.setSelected(this.isDefaultInterceptor);
        this.myDefaultInterceptor.setEnabled(this.myEjbFacet.getXmlRoot() != null);
        this.myTreePanel.setLayout(new BorderLayout());
        this.myTreePanel.add((Component)this.myTreeView.getComponent(), "Center");
        this.myPanel.doLayout();
    }

    protected void updateOKAction() {
    }

    public boolean isOKActionEnabled() {
        return true;
    }

    public boolean isDataValid() {
        return this.isOKActionEnabled();
    }

    public void applyInterceptorBindings() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        final HashMap<PsiMember, String> newTargetElements = new HashMap<PsiMember, String>();
        newTargetElements.putAll(this.targetMembers);
        final ArrayList bindingsToRemove = new ArrayList();
        this.processInterceptorBindings(new PairProcessor<com.intellij.javaee.model.common.ejb.InterceptorBinding, String>(){

            public boolean process(com.intellij.javaee.model.common.ejb.InterceptorBinding s, String t) {
                PsiMember member = s.getTargetMember();
                if (member != null) {
                    String boundEjbName = (String)InterceptorBindingsPanel.this.targetMembers.get(member);
                    if (!t.equals(boundEjbName)) {
                        bindingsToRemove.add(s);
                    } else {
                        newTargetElements.remove(member);
                    }
                } else if ("*".equals(s.getEjbName()) && !InterceptorBindingsPanel.this.myDefaultInterceptor.isSelected()) {
                    bindingsToRemove.add(s);
                }
                return true;
            }
        });
        HashSet<Object> allPsiElements = new HashSet<Object>();
        EjbJar ejbJar = this.myEjbFacet.getXmlRoot();
        if (ejbJar != null) {
            allPsiElements.add(ejbJar.getXmlTag());
        }
        allPsiElements.addAll(this.targetMembers.keySet());
        for (com.intellij.javaee.model.common.ejb.InterceptorBinding binding : bindingsToRemove) {
            if (binding.getTargetMember() == null) continue;
            allPsiElements.add(binding.getTargetMember());
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myProject, allPsiElements)) {
            return;
        }
        new WriteCommandAction(this.myProject, J2EEBundle.message((String)"command.apply.interceptor.bindings.command", (Object[])new Object[0]), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/module/view/ejb/ejbLevel/InterceptorBindingsPanel$4", "run"));
                }
                InterceptorBindingsPanel.this.updateInterceptorBindings(bindingsToRemove, newTargetElements);
            }
        }.execute();
    }

    private void updateInterceptorBindings(ArrayList<com.intellij.javaee.model.common.ejb.InterceptorBinding> bindingsToRemove, HashMap<PsiMember, String> newTargetElements) throws IncorrectOperationException {
        for (com.intellij.javaee.model.common.ejb.InterceptorBinding binding : bindingsToRemove) {
            binding.delete();
        }
        if (this.myEjbFacet.getXmlRoot() != null) {
            boolean addDefault = this.myDefaultInterceptor.isSelected() && !this.isDefaultInterceptor;
            InterceptorBindingsPanel.createInterceptorXmlMetadata(this.myEjbFacet.getXmlRoot(), this.myInterceptorClass, newTargetElements, addDefault);
        }
        InterceptorBindingsPanel.createInterceptorAnnotations(this.myInterceptorClass, newTargetElements);
    }

    public static void createInterceptorXmlMetadata(EjbJar ejbJar, String interceptorClassName, Map<PsiMember, String> memberToEjbNameMap, boolean addDefault) {
        AssemblyDescriptor assemblyDescriptor = ejbJar.getAssemblyDescriptor();
        if (addDefault) {
            InterceptorBinding binding = assemblyDescriptor.addInterceptorBinding();
            binding.addInterceptorClass().setStringValue(interceptorClassName);
            binding.getEnterpriseBean().setStringValue("*");
        }
        for (Map.Entry<PsiMember, String> entry : memberToEjbNameMap.entrySet()) {
            String ejbName = entry.getValue();
            PsiMember member = entry.getKey();
            InterceptorBinding binding = assemblyDescriptor.addInterceptorBinding();
            binding.addInterceptorClass().setStringValue(interceptorClassName);
            binding.getEnterpriseBean().setStringValue(ejbName);
            if (!(member instanceof PsiMethod)) continue;
            PsiMethod psiMethod = (PsiMethod)member;
            binding.getMethod().getMethod().setValue((Object)psiMethod);
            MethodParams methodParams = binding.getMethod().getMethodParams();
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                methodParams.addMethodParam().setValue((Object)psiParameter.getType());
            }
        }
    }

    public static void createInterceptorAnnotations(String interceptorClassName, Map<PsiMember, String> memberToEjbNameMap) throws IncorrectOperationException {
        for (Map.Entry<PsiMember, String> entry : memberToEjbNameMap.entrySet()) {
            PsiMember member = entry.getKey();
            InterceptorBindingsPanel.createInterceptorAnnotation(member, interceptorClassName);
        }
    }

    public static void createInterceptorAnnotation(PsiMember member, String interceptorClassName) throws IncorrectOperationException {
        PsiAnnotation curAnnotation = member.getModifierList().findAnnotation("javax.interceptor.Interceptors");
        String text = AnnotationTextUtil.createAnnotationText((PsiElement)member, "javax.interceptor.Interceptors", true, curAnnotation, "value", AnnotationTextUtil.createStringArrayInitializer(Collections.singletonList(interceptorClassName), null, ".class"), null);
        PsiAnnotation psiNewAnnotation = JavaPsiFacade.getInstance((Project)member.getProject()).getElementFactory().createAnnotationFromText(text, (PsiElement)member);
        PsiElement element = curAnnotation != null ? curAnnotation.replace((PsiElement)psiNewAnnotation) : member.getModifierList().addAfter((PsiElement)psiNewAnnotation, null);
        JavaCodeStyleManager.getInstance((Project)member.getProject()).shortenClassReferences(element);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTreePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/J2EEBundle").getString("border.interceptor.binding"), (int)0, (int)0, null, null));
        this.myDefaultInterceptor = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/J2EEBundle").getString("checkbox.default.interceptor"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static class EjbBusinessTreeView
    extends JamTreeTableView {
        private final EjbFacet myEjbFacet;
        private final Map<PsiMember, String> myTargetMembers;

        public EjbBusinessTreeView(Project project, EjbFacet ejbFacet, Map<PsiMember, String> targetMembers) {
            super(project, new EjbBusinessTreeModuleNodeDescriptor(ejbFacet, (Object)new J2EEModuleParameters(true), false));
            this.myEjbFacet = ejbFacet;
            this.myTargetMembers = targetMembers;
            this.getTreeTableView().setShowVerticalLines(true);
            this.getTreeTableView().setIntercellSpacing((Dimension)JBUI.size((int)1, (int)0));
            this.init();
            new TreeTableSpeedSearch((TreeTable)this.getTreeTableView());
        }

        @Override
        protected boolean isShowTree() {
            return !EjbCommonModelUtil.getAllEjbs((Project)this.getProject(), null, (EjbFacet)this.myEjbFacet).isEmpty();
        }

        @Override
        @NotNull
        protected String getEmptyPaneText() {
            String string = J2EEBundle.message((String)"message.text.no.ejbs.in.this.module.no.interceptors", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/ejbLevel/InterceptorBindingsPanel$EjbBusinessTreeView", "getEmptyPaneText"));
            }
            return string;
        }

        @Override
        protected ColumnInfo[] createColumnInfos() {
            return new ColumnInfo[]{new TreeColumnInfo(J2EEBundle.message((String)"column.name.ejb.business.tree.name", (Object[])new Object[0])), new ColumnInfo<JamNodeDescriptor, Boolean>(J2EEBundle.message((String)"column.name.ejb.business.tree.intercept", (Object[])new Object[0])){

                public boolean isCellEditable(JamNodeDescriptor o) {
                    Object element = o.getElement();
                    return element instanceof PsiElement;
                }

                public TableCellEditor getEditor(JamNodeDescriptor o) {
                    Object element = o.getElement();
                    return element instanceof PsiElement ? new BooleanTableCellEditor() : null;
                }

                public TableCellRenderer getRenderer(JamNodeDescriptor o) {
                    Object element = o.getElement();
                    return element instanceof PsiElement ? new BooleanTableCellRenderer() : null;
                }

                public void setValue(JamNodeDescriptor o, Boolean aValue) {
                    String ejbName = this.getEjbNameForNodeDescriptor(o);
                    Object element = o.getElement();
                    assert (element instanceof PsiMember);
                    PsiMember member = (PsiMember)element;
                    if (Boolean.TRUE.equals(aValue)) {
                        EjbBusinessTreeView.this.myTargetMembers.put(member, ejbName);
                    } else {
                        EjbBusinessTreeView.this.myTargetMembers.remove(member);
                    }
                }

                public Boolean valueOf(JamNodeDescriptor o) {
                    Object element = o.getElement();
                    if (element instanceof EnterpriseBean) {
                        return null;
                    }
                    assert (element instanceof PsiMember);
                    PsiMember member = (PsiMember)element;
                    return EjbBusinessTreeView.this.myTargetMembers.containsKey(member);
                }

                private String getEjbNameForNodeDescriptor(JamNodeDescriptor node) {
                    for (JamNodeDescriptor curNode = node; curNode != null; curNode = (JamNodeDescriptor)curNode.getParentDescriptor()) {
                        Object element = curNode.getElement();
                        if (!(element instanceof EnterpriseBean)) continue;
                        EnterpriseBean ejb = (EnterpriseBean)element;
                        return (String)ejb.getEjbName().getValue();
                    }
                    assert (false);
                    return null;
                }
            }};
        }
    }
}

