/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.moduleLevel;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TypePresentationService;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.VerificationException;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.EjbRelationUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.enums.Multiplicity;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.ejb.CmrField;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.EjbRelation;
import com.intellij.javaee.model.xml.ejb.EjbRelationshipRole;
import com.intellij.javaee.module.view.PrefixNameSuffixPanel;
import com.intellij.javaee.module.view.ejb.moduleLevel.RelationshipRolePanel;
import com.intellij.javaee.ui.DialogCommittableTab;
import com.intellij.javaee.ui.DialogElementWrapper;
import com.intellij.javaee.ui.NewElementWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ui.BaseControl;
import com.intellij.util.xml.ui.BigTextPanel;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.DomUIControl;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.TextPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RelationshipEditor
extends DialogCommittableTab<EjbRelation> {
    protected JPanel myPanel;
    protected TextPanel myName;
    protected BigTextPanel myDescription;
    protected JPanel myFirstRolePanel;
    protected JPanel mySecondRolePanel;
    private RelationshipRolePanel myFirstRole;
    private RelationshipRolePanel mySecondRole;
    private final EjbJar myRoot;
    private final EjbRelation myExisting;
    private EjbRelation myRelation;
    @NonNls
    protected static final String SUFFIX_EB = "EB";
    @NonNls
    protected static final String SUFFIX_EJB = "EJB";

    public RelationshipEditor(@NotNull EjbRelation relation) {
        if (relation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relation", "com/intellij/javaee/module/view/ejb/moduleLevel/RelationshipEditor", "<init>"));
        }
        super(J2EEBundle.message((String)"ejb.relationship.editor.general.tab", (Object[])new Object[0]), (JavaeeDomModelElement)relation, EjbFacet.ID);
        this.$$$setupUI$$$();
        this.myRoot = (EjbJar)((DomFileElement)DomUtil.getRoot((DomElement)relation)).getRootElement();
        this.myExisting = relation;
        this.init();
    }

    public RelationshipEditor(final @NotNull EjbJar root, final String firstEntity, final String secondEntity) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/javaee/module/view/ejb/moduleLevel/RelationshipEditor", "<init>"));
        }
        super(J2EEBundle.message((String)"ejb.relationship.editor.general.tab", (Object[])new Object[0]), (DialogElementWrapper)new NewElementWrapper<EjbRelation>(root.getPsiManager().getProject(), EjbRelation.class, (JavaeeFacet)EjbModuleUtil.getEjbFacet((JavaeeModelElement)root)){

            protected void initMockElement(EjbRelation relation) {
                EjbRelationshipRole first = relation.getEjbRelationshipRole1();
                EjbRelationshipRole second = relation.getEjbRelationshipRole2();
                first.getRelationshipRoleSource().getEntityBean().setStringValue(firstEntity);
                first.getMultiplicity().setValue((Object)Multiplicity.ONE);
                second.getRelationshipRoleSource().getEntityBean().setStringValue(secondEntity);
                second.getMultiplicity().setValue((Object)Multiplicity.ONE);
            }

            protected EjbRelation createRealElement() {
                return root.getRelationships().addEjbRelation();
            }
        });
        this.myRoot = root;
        this.myExisting = null;
        this.$$$setupUI$$$();
        this.init();
    }

    private void init() {
        this.myRelation = (EjbRelation)this.getDomElement();
        ((BaseControl)this.addComponent((Committable)DomUIFactory.createTextControl((GenericDomValue)this.myRelation.getEjbRelationName(), (boolean)true))).bind((JComponent)this.myName);
        ((DomUIControl)this.addComponent((Committable)DomUIFactory.createSmallDescriptionControl((DomElement)this.myRelation, (boolean)false))).bind((JComponent)this.myDescription);
        final EjbRelationshipRole role1 = this.myRelation.getEjbRelationshipRole1();
        final EjbRelationshipRole role2 = this.myRelation.getEjbRelationshipRole2();
        this.myFirstRole = (RelationshipRolePanel)this.addComponent((Committable)new RelationshipRolePanel(role1, role2, (Committable)this, this.myRoot){

            @Override
            protected void ejbNameChanged(String oldName, String newName) {
                String name = RelationshipEditor.getEjbName(role2);
                RelationshipEditor.this.ejbChanged(oldName, name, newName, name);
                this.reset();
            }
        });
        this.myFirstRolePanel.setLayout(new BorderLayout());
        this.myFirstRolePanel.add(this.myFirstRole.getComponent());
        this.mySecondRole = (RelationshipRolePanel)this.addComponent((Committable)new RelationshipRolePanel(role2, role1, (Committable)this, this.myRoot){

            @Override
            protected void ejbNameChanged(String oldName, String newName) {
                String name = RelationshipEditor.getEjbName(role1);
                RelationshipEditor.this.ejbChanged(name, oldName, name, newName);
                this.reset();
            }
        });
        this.mySecondRolePanel.setLayout(new BorderLayout());
        this.mySecondRolePanel.add(this.mySecondRole.getComponent());
        GenericDomValue relationName = this.myRelation.getEjbRelationName();
        if (StringUtil.isEmpty((String)((String)relationName.getValue()))) {
            relationName.setValue((Object)this.getDefaultRelationshipName(RelationshipEditor.getEjbName(role1), RelationshipEditor.getEjbName(role2)));
        }
        this.reset();
    }

    public void closeNotify() {
        super.closeNotify();
        EjbRelationUtil.updateRelation((EjbRelation)this.getCreatedElement(), this.myRelation, this.myFirstRole.isGetter(), this.myFirstRole.isSetter(), this.mySecondRole.isGetter(), this.mySecondRole.isSetter());
    }

    private static String getEjbName(EjbRelationshipRole role) {
        return role.getRelationshipRoleSource().getEntityBean().getStringValue();
    }

    private String getDefaultRelationshipName(String ejb1, String ejb2) {
        if (StringUtil.isEmpty((String)ejb1) || StringUtil.isEmpty((String)ejb2)) {
            return "";
        }
        return UniqueNameGenerator.generateUniqueName((String)(ejb1 + " - " + ejb2), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return RelationshipEditor.this.myExisting != null || !RelationshipEditor.this.isRelationNameBusy(s);
            }
        });
    }

    private boolean isRelationNameBusy(String name) {
        EjbRelation found = (EjbRelation)ElementPresentationManager.findByName((Collection)this.myRoot.getRelationships().getEjbRelations(), (String)name);
        return found != null && !found.equals(this.myExisting);
    }

    private void ejbChanged(String oldName1, String oldName2, String newName1, String newName2) {
        String relName = (String)this.myRelation.getEjbRelationName().getValue();
        if (StringUtil.isEmpty((String)relName) || relName.equals(this.getDefaultRelationshipName(oldName1, oldName2))) {
            this.myRelation.getEjbRelationName().setValue((Object)this.getDefaultRelationshipName(newName1, newName2));
        }
    }

    @NotNull
    static String suggestCmrName(EjbRelationshipRole role, String sourceEjb, String targetEjb, String otherName) {
        String name = targetEjb;
        if (StringUtil.isEmpty((String)name)) {
            name = "ejb";
        } else if (name.endsWith(SUFFIX_EB)) {
            name = name.substring(0, name.length() - SUFFIX_EB.length());
        } else if (name.endsWith(SUFFIX_EJB)) {
            name = name.substring(0, name.length() - SUFFIX_EJB.length());
        }
        name = PrefixNameSuffixPanel.suggestIdentifierCompatibleName(name);
        if (name.length() > 0) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        if (name.length() > 1) {
            name = String.valueOf(name.charAt(0)) + Character.toLowerCase(name.charAt(1)) + name.substring(2);
        }
        String suggestedName = name;
        int i = 1;
        while (RelationshipEditor.isFieldAlreadyExists(role, sourceEjb, suggestedName, targetEjb, otherName)) {
            suggestedName = name + i;
            ++i;
        }
        String string = suggestedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/moduleLevel/RelationshipEditor", "suggestCmrName"));
        }
        return string;
    }

    private static boolean isFieldAlreadyExists(EjbRelationshipRole role, String ejbName, String name, String otherEjb, String otherName) {
        if (ejbName == null || StringUtil.isEmpty((String)name)) {
            return false;
        }
        Object ejb = EjbUtil.findEjbByName(role.getModule(), ejbName);
        if (!(ejb instanceof EntityBean)) {
            return false;
        }
        if (Comparing.equal((String)ejbName, (String)RelationshipEditor.getEjbName(role)) && Comparing.equal((String)((String)role.getCmrField().getCmrFieldName().getValue()), (String)name)) {
            return false;
        }
        for (com.intellij.javaee.model.common.ejb.CmrField cmrField : ((EntityBean)ejb).getCmrFields()) {
            if (!Comparing.strEqual((String)((String)cmrField.getCmrFieldName().getValue()), (String)name)) continue;
            return true;
        }
        return ejbName.equals(otherEjb) && Comparing.strEqual((String)name, (String)otherName);
    }

    public String getErrorMessage() {
        try {
            this.checkIsValid();
            return null;
        }
        catch (VerificationException e) {
            return e.getMessage();
        }
    }

    public void checkIsValid() throws VerificationException {
        EjbRelationshipRole role1 = this.myRelation.getEjbRelationshipRole1();
        EjbRelationshipRole role2 = this.myRelation.getEjbRelationshipRole2();
        this.myFirstRole.checkIsValid();
        this.mySecondRole.checkIsValid();
        RelationshipEditor.checkRole(role1, role2);
        RelationshipEditor.checkRole(role2, role1);
        String name1 = (String)role1.getEjbRelationshipRoleName().getValue();
        String name2 = (String)role2.getEjbRelationshipRoleName().getValue();
        if (name1 != null && name1.equals(name2)) {
            throw new VerificationException(J2EEBundle.message((String)"message.text.duplicate.role.names", (Object[])new Object[0]));
        }
        String relationName = this.myRelation.getEjbRelationName().getStringValue();
        if (StringUtil.isNotEmpty((String)relationName) && this.isRelationNameBusy(relationName)) {
            throw new VerificationException(IdeBundle.message((String)"model.highlighting.identity", (Object[])new Object[]{TypePresentationService.getService().getTypePresentableName(EjbRelation.class)}));
        }
    }

    private static void checkRole(EjbRelationshipRole role, EjbRelationshipRole otherRole) throws VerificationException {
        CmrField cmrField = role.getCmrField();
        if (cmrField.getXmlTag() == null) {
            String otherField;
            String otherEjb;
            String name = (String)cmrField.getCmrFieldName().getValue();
            String ejb = RelationshipEditor.getEjbName(role);
            if (RelationshipEditor.isFieldAlreadyExists(role, ejb, name, otherEjb = RelationshipEditor.getEjbName(otherRole), otherField = (String)otherRole.getCmrField().getCmrFieldName().getValue())) {
                throw new VerificationException(J2EEBundle.message((String)"message.text.cmr.field.0.already.defined", (Object[])new Object[]{name, ejb}));
            }
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        BigTextPanel bigTextPanel;
        JPanel jPanel2;
        TextPanel textPanel;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.relationship.relationship.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myName = textPanel = new TextPanel();
        jPanel4.add((Component)textPanel, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFirstRolePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 1, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/J2EEBundle").getString("border.relationship.editor.role.1"), (int)0, (int)0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.relationship.description"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDescription = bigTextPanel = new BigTextPanel();
        jPanel5.add((Component)bigTextPanel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.mySecondRolePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 1, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/J2EEBundle").getString("border.relationship.editor.role.2"), (int)0, (int)0, null, null));
        jLabel.setLabelFor((Component)textPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

