/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.javaee.oss.server.JavaeeServerState;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.DefaultJ2EEServerEvent;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;

public abstract class JavaeeServerConnector
extends DefaultServerInstance {
    private JavaeeServerState myState = JavaeeServerState.STARTING;
    private final Object myConnectingLock = new Object();

    public JavaeeServerConnector(CommonModel runConfiguration) {
        super(runConfiguration);
    }

    public void start(ProcessHandler processHandler) {
        super.start(processHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                JavaeeServerConnector.this.disconnect();
            }
        });
    }

    public boolean connect() throws Exception {
        return this.getCommonModel().isLocal() ? this.connectLocal() : this.connectRemote();
    }

    private boolean connectLocal() throws Exception {
        this.initConnect();
        return false;
    }

    private boolean connectRemote() throws Exception {
        boolean result = false;
        try {
            this.initConnect();
            boolean bl = result = this.checkConnect();
            return bl;
        }
        finally {
            if (!result) {
                this.disconnect();
            }
        }
    }

    protected void initConnect() throws Exception {
    }

    protected boolean ping() {
        return super.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnect() {
        if (!this.ping()) {
            if (this.isStopping()) {
                this.myState = JavaeeServerState.STOPPED;
            }
            return false;
        }
        Object object = this.myConnectingLock;
        synchronized (object) {
            switch (this.myState) {
                case STARTING: {
                    break;
                }
                case RUNNING: {
                    return true;
                }
                case STOPPED: {
                    return false;
                }
                case STOPPING: {
                    return true;
                }
            }
            if (!this.doConnect()) {
                return false;
            }
            this.myState = JavaeeServerState.RUNNING;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!JavaeeServerConnector.this.isRunning()) {
                    return;
                }
                JavaeeServerConnector.this.fireServerListeners((J2EEServerEvent)new DefaultJ2EEServerEvent(true, false));
            }
        }, ModalityState.any());
        return true;
    }

    public final boolean isConnected() {
        return this.checkConnect();
    }

    public final void shutdown() {
        this.notifyBeforeDisconnect();
        this.disconnect();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaeeServerConnector.this.fireServerListeners((J2EEServerEvent)new DefaultJ2EEServerEvent(false, true));
            }
        }, ModalityState.any());
    }

    public final boolean isStopped() {
        return super.isStopped() || this.myState == JavaeeServerState.STOPPED;
    }

    public final boolean isStarting() {
        return this.myState == JavaeeServerState.STARTING;
    }

    protected final boolean isRunning() {
        return this.myState == JavaeeServerState.RUNNING;
    }

    private boolean isStopping() {
        return this.myState == JavaeeServerState.STOPPING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.myConnectingLock;
        synchronized (object) {
            if (this.isStopped() || this.isStopping()) {
                return;
            }
            this.doDisconnect();
            this.myState = JavaeeServerState.STOPPING;
        }
    }

    protected abstract boolean doConnect();

    protected abstract void doDisconnect();
}

