/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process.common;

import com.intellij.javaee.process.common.Base64;
import java.io.UnsupportedEncodingException;

public class EncodingUtil {
    public static final String UTF8 = "UTF8";
    private static final String NULL_TEXT = "_null_";

    public static String encodeBase64(String text) {
        if (text == null) {
            return NULL_TEXT;
        }
        try {
            return Base64.encode(text.getBytes(UTF8));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeBase64(String encodedText) {
        if (NULL_TEXT.equals(encodedText)) {
            return null;
        }
        try {
            return new String(Base64.decode(encodedText), UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private EncodingUtil() {
    }
}

