/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.JavaeeRunConfigurationCommonSettingsBean;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.OutputProcessor;
import com.intellij.javaee.serverInstances.J2EEServerEvent;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerStateListener;
import com.intellij.javaee.serverInstances.RunAppServerInstanceManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class J2EEProcessHandlerHelper {
    private final OutputProcessor myOutputProcessor;
    private final J2EEServerInstance myServerInstance;
    private final J2EEServerStateListener myServerStateListener;
    private final CommonStrategy myCommonStrategy;
    private boolean myOpenInBrowserFlag = false;
    private final J2EEProcess myJ2EEProcess;
    private final DeploymentManagerEx myDeploymentManager;
    private static final int INITIAL = 0;
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 2;
    private static final int DETACHED = 3;
    private static final int BEFORE_DISCONNECTING = 4;
    private final AtomicInteger myState = new AtomicInteger(0);
    private boolean myTerminated = false;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.run.execution.J2EEProcessHandlerHelper");
    private boolean mySomeResponseWasReceived = false;
    private int myUnsuccessfulAttempts = 0;
    private MessageBusConnection myConnection;

    public J2EEProcessHandlerHelper(J2EEServerInstance serverInstance, CommonStrategy commonStrategy, ProcessHandler handler) {
        this.myCommonStrategy = commonStrategy;
        this.myDeploymentManager = DeploymentManagerEx.getInstanceEx(this.myCommonStrategy.getProject());
        this.myOutputProcessor = commonStrategy.createOutputProcessor(handler, serverInstance);
        this.myOutputProcessor.registerPrintingToConsoleLogListener();
        this.myServerInstance = serverInstance;
        this.myJ2EEProcess = (J2EEProcess)handler;
        this.myServerStateListener = this.myCommonStrategy.isLocal() ? null : new J2EEServerStateListener(){

            public void serverStateChanged(J2EEServerEvent event) {
                if (event.isStateDisconnected()) {
                    J2EEProcessHandlerHelper.this.myJ2EEProcess.invokeTerminate();
                }
            }
        };
    }

    public void startNotify() {
        if (this.myServerStateListener != null) {
            this.myServerInstance.addServerListener(this.myServerStateListener);
        }
        this.myOpenInBrowserFlag = this.myCommonStrategy.getSettingsBean().OPEN_IN_BROWSER;
        Project project = this.myCommonStrategy.getProject();
        this.myConnection = project.getMessageBus().connect();
        this.startPing();
    }

    private void openInBrowserWatcher() {
        int topPageResponseCode;
        if (!this.myOpenInBrowserFlag || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final String url = this.myCommonStrategy.getUrlToOpenInBrowser();
        int requestedUrlResponseCode = J2EEProcessHandlerHelper.tryToConnect(url);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response code for " + url + ": " + requestedUrlResponseCode);
        }
        if (!this.mySomeResponseWasReceived && (topPageResponseCode = J2EEProcessHandlerHelper.tryToConnect("http://" + this.myCommonStrategy.getHost() + ":" + this.myCommonStrategy.getPort())) >= 0) {
            this.mySomeResponseWasReceived = true;
        }
        if (requestedUrlResponseCode >= 0) {
            this.launchBrowser(url);
            this.myOpenInBrowserFlag = false;
        } else if (this.mySomeResponseWasReceived) {
            ++this.myUnsuccessfulAttempts;
            if (this.myUnsuccessfulAttempts == 3) {
                ++this.myUnsuccessfulAttempts;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String newUrl = Messages.showInputDialog((String)J2EEBundle.message((String)"message.text.cannot.open.url", (Object[])new Object[0]), (String)J2EEBundle.message((String)"message.title.open.url", (Object[])new Object[0]), (Icon)Messages.getWarningIcon(), (String)url, (InputValidator)new InputValidator(){

                            public boolean checkInput(String inputString) {
                                try {
                                    new URL(inputString);
                                    return true;
                                }
                                catch (MalformedURLException ignored) {
                                    return false;
                                }
                            }

                            public boolean canClose(String inputString) {
                                return this.checkInput(inputString);
                            }
                        });
                        if (newUrl != null) {
                            J2EEProcessHandlerHelper.this.myCommonStrategy.setUrlToOpenInBrowser(newUrl);
                            J2EEProcessHandlerHelper.this.myUnsuccessfulAttempts = 0;
                        }
                    }
                });
            }
        }
    }

    private void launchBrowser(String url) {
        JavaScriptDebuggerStarter starter;
        JavaeeRunConfigurationCommonSettingsBean settingsBean = this.myCommonStrategy.getSettingsBean();
        WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(settingsBean.BROWSER_ID);
        if (settingsBean.START_JAVASCRIPT_DEBUGGER && (starter = JavaScriptDebuggerStarter.Util.get((RunConfiguration)this.myCommonStrategy)) != null) {
            LOG.debug("Starting JavaScript debugger for " + url);
            starter.start(url, (RunConfiguration)this.myCommonStrategy, (Object)this.myJ2EEProcess.getServerInstance(), browser);
            return;
        }
        BrowserLauncher.getInstance().browse(url, browser, this.myCommonStrategy.getProject());
    }

    private static int tryToConnect(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/run/execution/J2EEProcessHandlerHelper", "tryToConnect"));
        }
        try {
            return (Integer)HttpRequests.request((String)url).productNameAsUserAgent().redirectLimit(1).hostNameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession session) {
                    return true;
                }
            }).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Integer>(){

                public Integer process(@NotNull HttpRequests.Request request) throws IOException {
                    if (request == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javaee/run/execution/J2EEProcessHandlerHelper$3", "process"));
                    }
                    return request.getConnection() instanceof HttpURLConnection ? ((HttpURLConnection)request.getConnection()).getResponseCode() : -1;
                }
            });
        }
        catch (IllegalArgumentException ignored) {
            return -1;
        }
        catch (IOException e) {
            if ((e.getClass().getSimpleName().startsWith("SSL") || e instanceof SocketException && StringUtil.notNullize((String)e.getMessage()).contains("recv failed")) && url.startsWith("https")) {
                return 0;
            }
            return -1;
        }
    }

    public void destroy() {
        this.myServerInstance.shutdown();
        if (this.getState() == 0) {
            this.setState(2);
        } else if (this.getState() == 1) {
            this.setState(4);
        }
    }

    public CommonStrategy getStrategy() {
        return this.myCommonStrategy;
    }

    public J2EEServerInstance getServerInstance() {
        return this.myServerInstance;
    }

    public boolean isConnected() {
        return this.myServerInstance.isConnected();
    }

    private void startPing() {
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new MyPingAction());
    }

    public void onTerminated(int exitCode) {
        if (this.myTerminated) {
            return;
        }
        this.myTerminated = true;
        final Project project = this.myCommonStrategy.getProject();
        if (!project.isDisposed() && this.myConnection != null) {
            this.myConnection.disconnect();
        }
        this.myOutputProcessor.dispose();
        if (this.myServerStateListener != null) {
            this.myServerInstance.removeServerListener(this.myServerStateListener);
        }
        ((ProcessHandler)this.myJ2EEProcess).notifyTextAvailable(J2EEBundle.message((String)"message.text.disconnected.from.server", (Object[])new Object[0]) + "\n", ProcessOutputTypes.STDOUT);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isOpen()) {
                    WindowManager.getInstance().getStatusBar(project).setInfo(J2EEBundle.message((String)"message.text.disconnected.from.server", (Object[])new Object[0]));
                }
            }
        });
    }

    private int getState() {
        return this.myState.get();
    }

    private void setState(int state) {
        this.myState.set(state);
    }

    public void disconnect() {
        this.setState(3);
    }

    private class MyPingAction
    implements Runnable {
        private int myFails = 0;

        private MyPingAction() {
        }

        @Override
        public void run() {
            LOG.debug("ping started");
            try {
                while (this.ping()) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
        }

        private boolean ping() {
            ProcessHandler processHandler = (ProcessHandler)J2EEProcessHandlerHelper.this.myJ2EEProcess;
            if (processHandler.isProcessTerminated()) {
                LOG.debug("process terminated");
                J2EEProcessHandlerHelper.this.setState(2);
                return false;
            }
            if (J2EEProcessHandlerHelper.this.getState() == 3) {
                LOG.debug("detached");
                return false;
            }
            if (J2EEProcessHandlerHelper.this.getState() == 2) {
                LOG.debug("disconnected");
                J2EEProcessHandlerHelper.this.myJ2EEProcess.terminate();
                return false;
            }
            Project project = J2EEProcessHandlerHelper.this.myCommonStrategy.getProject();
            if (!project.isDisposed() && RunAppServerInstanceManager.getInstance((Project)project).debuggerIsPaused(processHandler)) {
                return true;
            }
            this.myFails = !J2EEProcessHandlerHelper.this.isConnected() ? ++this.myFails : 0;
            if (J2EEProcessHandlerHelper.this.getState() == 1) {
                if (J2EEProcessHandlerHelper.this.myDeploymentManager.isAllModulesDeployed(J2EEProcessHandlerHelper.this.myCommonStrategy)) {
                    J2EEProcessHandlerHelper.this.openInBrowserWatcher();
                    if (this.myFails > 3) {
                        J2EEProcessHandlerHelper.this.setState(2);
                    }
                }
            } else if (J2EEProcessHandlerHelper.this.getState() == 0) {
                if (this.myFails == 0) {
                    J2EEProcessHandlerHelper.this.setState(1);
                    J2EEProcessHandlerHelper.this.myJ2EEProcess.started();
                }
            } else if (J2EEProcessHandlerHelper.this.getState() == 4 && this.myFails > 0) {
                J2EEProcessHandlerHelper.this.setState(2);
            }
            return true;
        }
    }
}

