/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution.update;

import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.execution.update.ReloadResourcesUpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReloadClassesAndResourcesUpdatingPolicy
extends UpdatingPolicy {
    @NonNls
    public static final String ID = "update-classes-and-resources";
    private static final boolean UPDATE_CLASS_FILES_ON_RELOAD = Boolean.parseBoolean(System.getProperty("idea.update.class.files.in.server.instance.on.reload", "false"));

    public static UpdatingPolicy getInstance() {
        return UpdatingRunningApplicationUtil.findPolicy(ID);
    }

    public ReloadClassesAndResourcesUpdatingPolicy() {
        super(ID);
    }

    @Override
    public String getDescription() {
        return J2EEBundle.message((String)"updating.policy.update.classes.and.resources", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailableOnFrameDeactivation() {
        return true;
    }

    @Override
    public boolean isAvailableForConfiguration(@NotNull CommonModel commonModel) {
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "com/intellij/javaee/run/execution/update/ReloadClassesAndResourcesUpdatingPolicy", "isAvailableForConfiguration"));
        }
        return UpdatingRunningApplicationUtil.isResourcesReloadingSupported(commonModel);
    }

    @Override
    public void runUpdate(final @NotNull Project project, @Nullable Executor executor, final @NotNull J2EEServerInstance serverInstance, final @NotNull ProcessHandler processHandler, final boolean onFrameDeactivation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/execution/update/ReloadClassesAndResourcesUpdatingPolicy", "runUpdate"));
        }
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/run/execution/update/ReloadClassesAndResourcesUpdatingPolicy", "runUpdate"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/javaee/run/execution/update/ReloadClassesAndResourcesUpdatingPolicy", "runUpdate"));
        }
        final List artifacts = serverInstance.getCommonModel().getDeployedArtifacts();
        UpdatingRunningApplicationUtil.updateOpenedFilesAndStartCompilation(project, artifacts, new Runnable(){

            @Override
            public void run() {
                ReloadResourcesUpdatingPolicy.UpdateResourceOnServerListener updateResourcesListener = new ReloadResourcesUpdatingPolicy.UpdateResourceOnServerListener(serverInstance, UPDATE_CLASS_FILES_ON_RELOAD);
                if (!UpdatingRunningApplicationUtil.makeAndHotSwap(project, artifacts, processHandler, updateResourcesListener, false, onFrameDeactivation)) {
                    ReloadResourcesUpdatingPolicy.UpdateResourceOnServerListener updateClassesAndResourcesListener = new ReloadResourcesUpdatingPolicy.UpdateResourceOnServerListener(serverInstance, true);
                    UpdatingRunningApplicationUtil.makeClassesAndResources(project, artifacts, updateClassesAndResourcesListener, onFrameDeactivation);
                }
            }
        });
    }
}

