/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.toolwindow.view;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.Nullable;

@State(name="JavaeeView", storages={@Storage(file="$WORKSPACE_FILE$")})
public class JavaeeViewSettings
implements PersistentStateComponent<Settings> {
    private final MessageBus myMessageBus;
    private Settings mySettings = new Settings();
    public static final Topic<Listener> TOPIC = new Topic("JavaeeViewSettings", Listener.class);

    public void fireSettingsChanged(ChangeType changeType) {
        ((Listener)this.myMessageBus.syncPublisher(TOPIC)).settingsChanged(changeType);
    }

    public static JavaeeViewSettings getInstance(Project project) {
        return (JavaeeViewSettings)ServiceManager.getService((Project)project, JavaeeViewSettings.class);
    }

    public JavaeeViewSettings(MessageBus messageBus) {
        this.myMessageBus = messageBus;
    }

    @Nullable
    public Settings getState() {
        return this.mySettings;
    }

    public void loadState(Settings settings) {
        XmlSerializerUtil.copyBean((Object)settings, (Object)this.mySettings);
    }

    public boolean isFrameworksView() {
        return this.mySettings.frameworksView;
    }

    public void setFrameworksView(boolean value) {
        this.mySettings.frameworksView = value;
    }

    public boolean isShowModules() {
        return this.mySettings.showModules;
    }

    public void setShowModules(boolean value) {
        this.mySettings.showModules = value;
    }

    public static class Settings {
        public boolean frameworksView = true;
        public boolean showModules = true;
    }

    public static enum ChangeType {
        FULL,
        UPDATE,
        FORCE_UPDATE;

    }

    public static interface Listener {
        public void settingsChanged(ChangeType var1);
    }
}

