/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.javaee.ui.packaging.EarArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedEjbArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.ui.packaging.JavaeeApplicationArtifactType;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ArtifactSourceItem;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ArtifactRootElementImpl;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;

public class ExplodedEarArtifactType
extends JavaeeApplicationArtifactType {
    public static ExplodedEarArtifactType getInstance() {
        return (ExplodedEarArtifactType)((Object)ContainerUtil.findInstance((Object[])ExplodedEarArtifactType.getAllTypes(), ExplodedEarArtifactType.class));
    }

    public ExplodedEarArtifactType() {
        super("exploded-ear", "JavaEE Application: Exploded", false);
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/intellij/javaee/ui/packaging/ExplodedEarArtifactType", "createRootElement"));
        }
        ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
        if (artifactRootElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ui/packaging/ExplodedEarArtifactType", "createRootElement"));
        }
        return artifactRootElementImpl;
    }

    @Nullable
    private static String getDefaultPathFor(@Nullable Artifact artifact) {
        if (artifact != null) {
            ArtifactType type = artifact.getArtifactType();
            String artifactName = artifact.getName();
            int i = StringUtil.findFirst((CharSequence)artifactName, (CharFilter)new CharFilter(){

                public boolean accept(char ch) {
                    return !Character.isLetterOrDigit(ch);
                }
            });
            String name = ArtifactUtil.suggestArtifactFileName((String)(i != -1 ? artifactName.substring(0, i) : artifactName));
            if (type.equals((Object)ExplodedWarArtifactType.getInstance())) {
                return "/" + name + ".war";
            }
            if (type.equals((Object)ExplodedEjbArtifactType.getInstance())) {
                return "/" + name + ".jar";
            }
        }
        return null;
    }

    @Override
    public String getDefaultPathFor(@NotNull PackagingSourceItem sourceItem) {
        String defaultPath;
        if (sourceItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceItem", "com/intellij/javaee/ui/packaging/ExplodedEarArtifactType", "getDefaultPathFor"));
        }
        if (sourceItem instanceof ArtifactSourceItem && (defaultPath = ExplodedEarArtifactType.getDefaultPathFor(((ArtifactSourceItem)sourceItem).getArtifact())) != null) {
            return defaultPath;
        }
        return super.getDefaultPathFor(sourceItem);
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType parentType) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/ui/packaging/ExplodedEarArtifactType", "getSubstitution"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javaee/ui/packaging/ExplodedEarArtifactType", "getSubstitution"));
        }
        if (parentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentType", "com/intellij/javaee/ui/packaging/ExplodedEarArtifactType", "getSubstitution"));
        }
        if (!((Object)((Object)EarArtifactType.getInstance())).equals(parentType)) {
            return null;
        }
        final ArrayList result = new ArrayList();
        CompositePackagingElement rootElement = artifact.getRootElement();
        ArtifactUtil.processElementsWithSubstitutions((List)rootElement.getChildren(), (PackagingElementResolvingContext)context, (ArtifactType)this, (PackagingElementPath)PackagingElementPath.EMPTY.appendComposite(rootElement), (PackagingElementProcessor)new PackagingElementProcessor<PackagingElement<?>>(){

            public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                return element instanceof ArtifactPackagingElement;
            }

            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                DirectoryPackagingElement directoryElement;
                String name;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/ui/packaging/ExplodedEarArtifactType$2", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javaee/ui/packaging/ExplodedEarArtifactType$2", "process"));
                }
                if (element instanceof DirectoryPackagingElement && JpsArtifactUtil.isArchiveName((String)(name = (directoryElement = (DirectoryPackagingElement)element).getName()))) {
                    CompositePackagingElement archive = PackagingElementFactory.getInstance().createArchive(name);
                    archive.addOrFindChildren((Collection)directoryElement.getChildren());
                    result.add(archive);
                    return true;
                }
                result.add(element);
                return true;
            }
        });
        return result;
    }
}

