/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.facet.FacetTypeId;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.application.JavaeeDescriptorUtil;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.javaee.ui.packaging.EarArtifactDependenciesChecker;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import icons.J2eeOpenapiIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeApplicationArtifactType
extends JavaeeArtifactTypeBase {
    public JavaeeApplicationArtifactType(@NonNls String id, String title, boolean isArchive) {
        super(id, title, isArchive, (FacetTypeId<? extends JavaeeFacet>)JavaeeApplicationFacet.ID);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = J2eeOpenapiIcons.Javaee_artifact;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ui/packaging/JavaeeApplicationArtifactType", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public String getDefaultPathFor(@NotNull PackagingSourceItem sourceItem) {
        if (sourceItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceItem", "com/intellij/javaee/ui/packaging/JavaeeApplicationArtifactType", "getDefaultPathFor"));
        }
        if (sourceItem instanceof ModuleOutputSourceItem) {
            return "/lib/" + ArtifactUtil.suggestArtifactFileName((String)((ModuleOutputSourceItem)sourceItem).getModule().getName()) + ".jar!/";
        }
        return super.getDefaultPathFor(sourceItem);
    }

    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/javaee/ui/packaging/JavaeeApplicationArtifactType", "getDefaultPathFor"));
        }
        if (kind.containsJarFiles()) {
            return "/lib";
        }
        return "/";
    }

    @Override
    protected List<? extends ArtifactTemplate> getExplodedArtifactTemplates(PackagingElementResolvingContext context) {
        return Collections.emptyList();
    }

    public void checkRootElement(@NotNull CompositePackagingElement<?> rootElement, @NotNull Artifact artifact, @NotNull ArtifactProblemsHolder manager) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/javaee/ui/packaging/JavaeeApplicationArtifactType", "checkRootElement"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/ui/packaging/JavaeeApplicationArtifactType", "checkRootElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/javaee/ui/packaging/JavaeeApplicationArtifactType", "checkRootElement"));
        }
        this.checkDescriptor(rootElement, manager);
        EarArtifactDependenciesChecker checker = new EarArtifactDependenciesChecker(this, manager);
        checker.processEar(rootElement);
    }

    private void checkDescriptor(CompositePackagingElement<?> rootElement, ArtifactProblemsHolder manager) {
        VirtualFile file = this.findDescriptor(rootElement, manager, "META-INF/application.xml");
        if (file != null) {
            Module module;
            if (file.isDirectory()) {
                manager.registerError("'META-INF/application.xml' descriptor refers to directory rather than file", "application.xml-is-directory");
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)manager.getContext().getProject()).findFile(file);
            Module module2 = module = psiFile != null ? ModuleUtil.findModuleForPsiElement((PsiElement)psiFile) : null;
            if (module == null) {
                return;
            }
            JavaeeApplication root = (JavaeeApplication)JamCommonUtil.getRootElement((PsiFile)psiFile, JavaeeApplication.class, (Module)module);
            if (root != null) {
                JavaeeDescriptorUtil.checkDescriptor(root, rootElement, manager, this);
            }
        }
    }
}

