/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.ui.packaging.JavaeeArtifactDependenciesChecker;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.javaee.ui.packaging.LibrariesAndModulesCollector;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.util.Processor;
import icons.J2eeOpenapiIcons;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class WebApplicationArtifactType
extends JavaeeArtifactTypeBase {
    public WebApplicationArtifactType(@NonNls String id, String title, boolean isArchive) {
        super(id, title, isArchive, (FacetTypeId<? extends JavaeeFacet>)WebFacet.ID);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = J2eeOpenapiIcons.Web_artifact;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ui/packaging/WebApplicationArtifactType", "getIcon"));
        }
        return icon;
    }

    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/javaee/ui/packaging/WebApplicationArtifactType", "getDefaultPathFor"));
        }
        if (kind.containsJarFiles()) {
            return "/WEB-INF/lib";
        }
        if (kind.containsDirectoriesWithClasses()) {
            return "/WEB-INF/classes";
        }
        return "/";
    }

    public void checkRootElement(@NotNull CompositePackagingElement<?> rootElement, @NotNull Artifact artifact, @NotNull ArtifactProblemsHolder manager) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/javaee/ui/packaging/WebApplicationArtifactType", "checkRootElement"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/ui/packaging/WebApplicationArtifactType", "checkRootElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/javaee/ui/packaging/WebApplicationArtifactType", "checkRootElement"));
        }
        if (!WebApplicationArtifactType.isIncludedInEar(artifact, manager.getContext())) {
            JavaeeArtifactDependenciesChecker dependenciesChecker = new JavaeeArtifactDependenciesChecker(manager, this);
            dependenciesChecker.processWebApplication(rootElement, PackagingElementPath.EMPTY, Collections.<VirtualFile, String>emptyMap(), new LibrariesAndModulesCollector[0]);
        }
    }

    private static boolean isIncludedInEar(final Artifact webArtifact, final PackagingElementResolvingContext context) {
        Artifact[] artifacts;
        for (Artifact artifact : artifacts = context.getArtifactModel().getArtifacts()) {
            boolean found;
            if (!JavaeeArtifactUtil.getInstance().isJavaeeApplication(artifact.getArtifactType())) continue;
            boolean bl = found = !ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)ArtifactElementType.ARTIFACT_ELEMENT_TYPE, (Processor)new Processor<ArtifactPackagingElement>(){

                public boolean process(ArtifactPackagingElement artifactPackagingElement) {
                    return !webArtifact.equals(artifactPackagingElement.findArtifact(context));
                }
            }, (PackagingElementResolvingContext)context, (boolean)true);
            if (!found) continue;
            return true;
        }
        return false;
    }
}

