/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.javaee.model.CommonListener;
import com.intellij.javaee.model.jam.JamFilter;
import com.intellij.javaee.model.jam.JamListener;
import com.intellij.javaee.model.jam.JamServlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.WebModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class WebModelBase
implements WebModel {
    public List<CommonServlet> getServlets() {
        return this.getMergedElements(JamServlet.SERVLET_CLASS_META, "javax.servlet.annotation.WebServlet", new Function<WebApp, List<CommonServlet>>(){

            public List<CommonServlet> fun(WebApp webApp) {
                return new ArrayList<CommonServlet>(webApp.getServlets());
            }
        });
    }

    public CommonServlet findServlet(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javaee/web/WebModelBase", "findServlet"));
        }
        return (CommonServlet)ContainerUtil.find(this.getServlets(), (Condition)new Condition<CommonServlet>(){

            public boolean value(CommonServlet o) {
                return name.equals(o.getServletName().getStringValue());
            }
        });
    }

    public CommonFilter findFilter(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javaee/web/WebModelBase", "findFilter"));
        }
        return (CommonFilter)ContainerUtil.find(this.getFilters(), (Condition)new Condition<CommonFilter>(){

            public boolean value(CommonFilter o) {
                return name.equals(o.getFilterName().getStringValue());
            }
        });
    }

    public List<CommonServletMapping<CommonServlet>> getServletMappings() {
        return this.getMergedElements(JamServlet.SERVLET_CLASS_META, "javax.servlet.annotation.WebServlet", new Function<WebApp, List<CommonServletMapping<CommonServlet>>>(){

            public List<CommonServletMapping<CommonServlet>> fun(WebApp webApp) {
                return new ArrayList<CommonServletMapping<CommonServlet>>(webApp.getServletMappings());
            }
        });
    }

    private <T> List<T> getMergedElements(JamClassMeta<? extends T> servletClassMeta, String annoName, Function<WebApp, List<T>> fun) {
        if (DumbService.isDumb((Project)this.getModule().getProject())) {
            return Collections.emptyList();
        }
        Collection<WebApp> models = this.getApps();
        ArrayList mappings = new ArrayList();
        for (WebApp model : models) {
            mappings.addAll((Collection)fun.fun((Object)model));
        }
        JamService service = JamService.getJamService((Project)this.getModule().getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)this.getModule(), (boolean)false);
        List servlets = service.getJamClassElements(servletClassMeta, annoName, scope);
        mappings.addAll(servlets);
        return mappings;
    }

    @NotNull
    protected abstract Module getModule();

    protected abstract Collection<WebApp> getApps();

    public List<CommonFilter> getFilters() {
        return this.getMergedElements(JamFilter.FILTER_CLASS_META, "javax.servlet.annotation.WebFilter", new Function<WebApp, List<CommonFilter>>(){

            public List<CommonFilter> fun(WebApp webApp) {
                return new ArrayList<CommonFilter>(webApp.getFilters());
            }
        });
    }

    public List<CommonListener> getListeners() {
        return this.getMergedElements(JamListener.LISTENER_CLASS_META, "javax.servlet.annotation.WebListener", new Function<WebApp, List<CommonListener>>(){

            public List<CommonListener> fun(WebApp webApp) {
                return new ArrayList<CommonListener>(webApp.getListeners());
            }
        });
    }
}

