/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import java.util.Collection;

public class JpaObjectDeleteHandler
extends JamDeleteHandler {
    public void addPsiElements(CommonModelElement element, Collection<PsiElement> result) {
        if (element instanceof PersistentObject) {
            PsiClass psiClass = (PsiClass)((PersistentObject)element).getClazz().getValue();
            Module module = psiClass == null ? null : ModuleUtil.findModuleForPsiElement((PsiElement)psiClass);
            ContainerUtil.addIfNotNull((Object)psiClass, result);
            if (module != null) {
                for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
                    for (PersistencePackage unit : facet.getPersistenceUnits()) {
                        for (GenericValue classValue : unit.getModelHelper().getClasses()) {
                            if (!psiClass.equals(classValue.getValue()) || !(classValue instanceof GenericDomValue)) continue;
                            ContainerUtil.addIfNotNull((Object)((GenericDomValue)classValue).getXmlTag(), result);
                        }
                    }
                }
            }
        } else if (element instanceof PersistenceListener) {
            ContainerUtil.addIfNotNull((Object)((PersistenceListener)element).getClazz().getValue(), result);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addModelElements(CommonModelElement element, Collection<CommonModelElement> result) {
        Module module;
        if (!(element instanceof PersistentObject) || !element.isValid()) {
            return;
        }
        PersistentObject persistentObject = (PersistentObject)element;
        final PsiClass clazz = (PsiClass)persistentObject.getClazz().getValue();
        Module module2 = module = clazz == null ? null : ModuleUtil.findModuleForPsiElement((PsiElement)clazz);
        if (module == null) {
            return;
        }
        Processor<PersistentObject> processor = new Processor<PersistentObject>(){

            public boolean process(PersistentObject object) {
                return !clazz.getManager().areElementsEquivalent((PsiElement)clazz, (PsiElement)object.getClazz().getValue());
            }
        };
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)facet, (PersistencePackage)unit, null);
                PersistenceMappings mappings = facet.getEntityMappings(unit);
                for (PersistentObject object : PersistenceCommonUtil.queryPersistentObjects((PersistenceMappings)mappings)) {
                    if (!processor.process((Object)object)) {
                        result.add((CommonModelElement)object);
                        continue;
                    }
                    for (PersistentAttribute attribute : browser.queryAttributes(object)) {
                        void var17_17;
                        Query query;
                        if (attribute instanceof PersistentEmbeddedAttribute) {
                            query = browser.queryTargetPersistentObjects((PersistentEmbeddedAttribute)attribute);
                        } else {
                            if (!(attribute instanceof PersistentRelationshipAttribute)) continue;
                            query = browser.queryTargetPersistentObjects((PersistentRelationshipAttribute)attribute);
                        }
                        if (var17_17.forEach((Processor)processor)) continue;
                        result.add((CommonModelElement)attribute);
                    }
                }
            }
        }
    }
}

