/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.script.QueryParametersProvider;
import com.intellij.jam.JamAttributeElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaQueryReferenceProvider;
import com.intellij.jpa.ql.psi.impl.QlFileImpl;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.util.QueryParameterResolveHelper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JpaQueryParameterReferenceProvider
extends PsiReferenceProvider {
    private final ResolveHelper myHelper = new ResolveHelper();

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/JpaQueryParameterReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jpa/JpaQueryParameterReferenceProvider", "getReferencesByElement"));
        }
        String parameterName = String.valueOf(JamCommonUtil.computeMemberValue((PsiElement)element));
        PsiReference[] psiReferenceArray = new PsiReference[]{new QueryParameterReference(element, parameterName, this.myHelper)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaQueryParameterReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/jpa/JpaQueryParameterReferenceProvider", "acceptsTarget"));
        }
        return target instanceof QlFileImpl.ParameterDefinition;
    }

    public static class QueryParameterReference
    extends JpaQueryReferenceProvider.QueryRelatedReference {
        private final String myParameterName;
        private final ResolveHelper myHelper;
        private List<Map<String, PsiElement>> myMapList;
        private boolean myUnparsable;

        public QueryParameterReference(PsiElement element, String parameterName, ResolveHelper helper) {
            super(element);
            this.myParameterName = parameterName;
            this.myHelper = helper;
        }

        private void initMapList() {
            if (this.myMapList == null) {
                this.myMapList = new ArrayList<Map<String, PsiElement>>(0);
                Ref ref = Ref.create(null);
                this.myHelper.processPossibleQueryElementsByParameter(CompletionUtil.getOriginalOrSelf((PsiElement)this.getElement()), this.myMapList, (Ref<Boolean>)ref);
                this.myUnparsable = Boolean.TRUE.equals(ref.get());
            }
        }

        public PsiElement resolve() {
            this.initMapList();
            if (this.myMapList.isEmpty()) {
                return this.getElement();
            }
            if (StringUtil.isEmpty((String)this.myParameterName)) {
                return null;
            }
            for (Map<String, PsiElement> map : this.myMapList) {
                PsiElement element = map.get(this.myParameterName);
                if (element == null) continue;
                return element;
            }
            return this.myUnparsable ? this.getElement() : null;
        }

        @NotNull
        public Object[] getVariants() {
            this.initMapList();
            if (this.myMapList.isEmpty()) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaQueryParameterReferenceProvider$QueryParameterReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            final HashMap<String, PsiElement> result = new HashMap<String, PsiElement>(this.myMapList.get(0));
            for (Map<String, PsiElement> map : this.myMapList) {
                result.keySet().retainAll(map.keySet());
            }
            Object[] objectArray = ContainerUtil.mapNotNull(result.keySet(), (Function)new Function<String, LookupElement>(){

                public LookupElement fun(String s) {
                    if (StringUtil.parseInt((String)s, (int)-1) != -1) {
                        return null;
                    }
                    return LookupElementBuilder.create((String)s).withIcon(((PsiElement)result.get(s)).getIcon(0));
                }
            }).toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaQueryParameterReferenceProvider$QueryParameterReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = JpaMessages.message((String)"cannot.resolve.query.parameter.0", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaQueryParameterReferenceProvider$QueryParameterReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }

    public static class ResolveHelper
    extends QueryParameterResolveHelper<Map<String, PsiElement>, Ref<Boolean>> {
        @Override
        protected boolean addParamMap(@NotNull PsiFile file, List<Map<String, PsiElement>> result, Ref<Boolean> context) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jpa/JpaQueryParameterReferenceProvider$ResolveHelper", "addParamMap"));
            }
            QueryParametersProvider provider = (QueryParametersProvider)QueryParametersProvider.EXTENSION.forLanguage(file.getLanguage());
            if (provider == null) {
                return false;
            }
            ContainerUtil.addIfNotNull((Object)provider.getParameters(file), result);
            if (context.isNull()) {
                context.set(file.getUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION));
            }
            return true;
        }

        @Override
        public boolean processPossibleQueryElementsByParameter(PsiElement paramElement, List<Map<String, PsiElement>> result, Ref<Boolean> context) {
            PsiMethodCallExpression expression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)paramElement, PsiMethodCallExpression.class);
            if (expression == null) {
                return false;
            }
            PsiExpression[] args = expression.getArgumentList().getExpressions();
            if (args.length > 0 && !args[0].equals(paramElement) && this.processPossibleQueryElement((PsiElement)args[0], result, ResolveHelper.initialVisitedElements(paramElement), context)) {
                return true;
            }
            return super.processPossibleQueryElementsByParameter(paramElement, result, context);
        }

        @Override
        protected boolean processPossibleQueryElement(PsiElement element, List<Map<String, PsiElement>> result, Collection<PsiElement> visitedElements, Ref<Boolean> context) {
            if (element instanceof XmlElement) {
                return this.addParamMapsByQueryElement(element, result, context);
            }
            return super.processPossibleQueryElement(element, result, visitedElements, context);
        }

        @Override
        protected boolean addParamMapsByQueryElement(@NotNull PsiElement expression, List<Map<String, PsiElement>> result, Ref<Boolean> context) {
            GenericValue queryValue;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/jpa/JpaQueryParameterReferenceProvider$ResolveHelper", "addParamMapsByQueryElement"));
            }
            JpaQueryReferenceProvider.QueryReference reference = JpaUtil.findReferenceOfType(expression.getReferences(), JpaQueryReferenceProvider.QueryReference.class);
            PersistenceQuery query = reference == null ? null : reference.resolveQuery();
            GenericValue genericValue = queryValue = query == null ? null : query.getQuery();
            if (queryValue instanceof JamAttributeElement) {
                PsiLiteralExpression literal;
                PsiAnnotationMemberValue value = ((JamAttributeElement)queryValue).getPsiElement();
                if (value instanceof PsiReferenceExpression) {
                    this.addParameterMapsByQueryReference((PsiReferenceExpression)value, result, ResolveHelper.initialVisitedElements(expression), context);
                } else if (value instanceof PsiExpression && (literal = ResolveHelper.getFirstLiteral((PsiExpression)value)) != null) {
                    this.addParamMapsByQueryElement((PsiElement)literal, result, context);
                }
                return true;
            }
            if (queryValue instanceof DomElement) {
                super.addParamMapsByQueryElement((PsiElement)((DomElement)queryValue).getXmlElement(), result, context);
                return true;
            }
            return super.addParamMapsByQueryElement(expression, result, context);
        }
    }
}

