/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(PsiElement element) {
        PsiMember member = JpaReadWriteAccessDetector.getPsiMember(element);
        return member != null && JpaReadWriteAccessDetector.findDetector((PsiElement)member) != null;
    }

    public boolean isDeclarationWriteAccess(PsiElement element) {
        PsiMember member = JpaReadWriteAccessDetector.getPsiMember(element);
        return JpaReadWriteAccessDetector.getDetectorSafe((PsiElement)member).isDeclarationWriteAccess((PsiElement)member);
    }

    public ReadWriteAccessDetector.Access getReferenceAccess(PsiElement referencedElement, PsiReference reference) {
        PsiMember member = JpaReadWriteAccessDetector.getPsiMember(referencedElement);
        return JpaReadWriteAccessDetector.getDetectorSafe((PsiElement)member).getReferenceAccess((PsiElement)member, reference);
    }

    public ReadWriteAccessDetector.Access getExpressionAccess(PsiElement expression) {
        for (ReadWriteAccessDetector detector : (ReadWriteAccessDetector[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            ReadWriteAccessDetector.Access access;
            if (detector instanceof JpaReadWriteAccessDetector || (access = detector.getExpressionAccess(expression)) == ReadWriteAccessDetector.Access.Read) continue;
            return access;
        }
        return ReadWriteAccessDetector.Access.Read;
    }

    @Nullable
    public static PsiMember getPsiMember(PsiElement element) {
        Object modelObject = JamCommonUtil.getModelObject((PsiElement)element);
        if (modelObject instanceof PersistentAttribute) {
            return ((PersistentAttribute)modelObject).getPsiMember();
        }
        return null;
    }

    @NotNull
    private static ReadWriteAccessDetector getDetectorSafe(PsiElement element) {
        ReadWriteAccessDetector readWriteAccessDetector = JpaReadWriteAccessDetector.findDetector((PsiElement)element);
        if (readWriteAccessDetector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaReadWriteAccessDetector", "getDetectorSafe"));
        }
        return readWriteAccessDetector;
    }
}

