/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.actions;

import com.intellij.jpa.generation.JpaMappingGenerator;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;

public class GenerateJpaMappingAction
extends AnAction {
    private final JpaMappingGenerator myGenerator;

    public GenerateJpaMappingAction(JpaMappingGenerator generator) {
        super(generator.getTitle(), generator.getTitle(), null);
        this.myGenerator = generator;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        boolean enabled = facet != null && this.myGenerator.isAvailableOnDataContext(dataContext);
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        GenerateJpaMappingAction.runGenerateAction(this.myGenerator.clone(), e.getDataContext());
    }

    public static void runGenerateAction(final JpaMappingGenerator generator, DataContext dataContext) {
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        if (facet != null && generator.isAvailableOnDataContext(dataContext) && generator.beforeGenerate(dataContext)) {
            Project project = facet.getModule().getProject();
            DumbService.getInstance((Project)project).runWhenSmart(new Runnable(){

                @Override
                public void run() {
                    generator.generate();
                }
            });
        }
    }
}

