/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.facet.Facet;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.engine.JpaConsole;
import com.intellij.jpa.engine.JpaEngine;
import com.intellij.jpa.engine.JpaEngineBase;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.providers.EclipseLinkProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaConsoleRunContext
implements ConsoleRunConfiguration.RunContext,
Runnable {
    public static final String MAIN_CLASS = "com.intellij.jpa.console.RemoteJpaServer";
    private final ConsoleRunConfiguration myRunConfiguration;
    private final PersistencePackagePointer myUnitFile;

    JpaConsoleRunContext(PersistencePackagePointer unitFile, ConsoleRunConfiguration runConfiguration) {
        this.myUnitFile = unitFile;
        this.myRunConfiguration = runConfiguration;
    }

    public static PersistencePackagePointer[] getPossiblePersistenceUnits(Project project) {
        ArrayList<PersistencePackageAsVirtualFileImpl> model = new ArrayList<PersistencePackageAsVirtualFileImpl>();
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets((Project)project)) {
            if (!(facet instanceof JpaFacet) || !JpaEngine.isAvailable(facet.getModule())) continue;
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                model.add(PersistencePackageAsVirtualFileImpl.findFile(unit, facet));
            }
        }
        return model.toArray(new PersistencePackagePointer[model.size()]);
    }

    public static boolean shouldAddGroovy(@Nullable Module module) {
        if (module == null) {
            return true;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("groovy.lang.GroovyShell", GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false)) == null;
    }

    public static void addDataSourceJarsToClassPath(@NotNull PathsList cp, @NotNull PersistencePackage unit, @NotNull PersistenceFacet facet) {
        Object delegate;
        if (cp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cp", "com/intellij/jpa/engine/JpaConsoleRunContext", "addDataSourceJarsToClassPath"));
        }
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/jpa/engine/JpaConsoleRunContext", "addDataSourceJarsToClassPath"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/jpa/engine/JpaConsoleRunContext", "addDataSourceJarsToClassPath"));
        }
        String dataSourceId = facet.getDataSourceId(unit);
        if (dataSourceId == null) {
            return;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)facet.getModule().getProject()).findDataSource(dataSourceId);
        Object object = delegate = dataSource == null ? null : dataSource.getDelegate();
        if (delegate instanceof LocalDataSource) {
            for (SimpleClasspathElement pathElement : ((LocalDataSource)delegate).getClasspathElements()) {
                for (String url : pathElement.getClassesRootUrls()) {
                    cp.add(PathUtil.toPresentableUrl((String)url));
                }
            }
        }
    }

    public static void addModuleClassPath(@NotNull PathsList cp, @Nullable Module module) {
        if (cp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cp", "com/intellij/jpa/engine/JpaConsoleRunContext", "addModuleClassPath"));
        }
        if (module == null) {
            return;
        }
        OrderEnumerator.orderEntries((Module)module).withoutSdk().recursively().classes().collectPaths(cp);
    }

    public Module getModule() {
        Facet facet = this.myUnitFile.getFacetPointer().getFacet();
        return facet == null ? null : facet.getModule();
    }

    public String getMainClassName() {
        return MAIN_CLASS;
    }

    public void collectClassPath(PathsList cp) throws ExecutionException {
        JdbcConsoleRunContext.addUtilJars((PathsList)cp, (boolean)JpaConsoleRunContext.shouldAddGroovy(this.getModule()));
        JdbcConsoleRunContext.addJdbcConsoleJars((PathsList)cp);
        JdbcConsoleRunContext.addClassJar((PathsList)cp, JpaEngine.class, (String)MAIN_CLASS);
        PersistencePackage unit = this.myUnitFile.findElement();
        if (unit == null) {
            throw new ExecutionException(JpaMessages.message((String)"jpa.console.unit.not.found", (Object[])new Object[0]));
        }
        PersistenceFacet facet = this.myUnitFile.getPersistenceFacet();
        if (facet == null) {
            throw new ExecutionException(JpaMessages.message((String)"jpa.console.facet.not.found", (Object[])new Object[0]));
        }
        JpaConsoleRunContext.addDataSourceJarsToClassPath(cp, unit, facet);
        JpaConsoleRunContext.addModuleClassPath(cp, this.getModule());
    }

    public void tuneParams(@NotNull SimpleJavaParameters params) throws ExecutionException {
        File tempPURoot;
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/jpa/engine/JpaConsoleRunContext", "tuneParams"));
        }
        File genPath = JpaEngineBase.getTempDirectory(this.myUnitFile.getFacetPointer().getProject());
        PersistencePackage unit = this.myUnitFile.findElement();
        JpaImplementationProvider provider = JpaUtil.findJpaProvider(this.myUnitFile.getPersistenceFacet(), unit, true);
        String path = this.myUnitFile.getFacetPointer().getModuleName().replace(' ', '_') + "-PU-" + System.currentTimeMillis();
        if (provider instanceof EclipseLinkProvider) {
            tempPURoot = new File(genPath, path + File.separator + "gen");
            params.getVMParametersList().add("-Declipselink.persistencexml=" + tempPURoot.getName() + "/META-INF/persistence.xml");
            params.getClassPath().addFirst(tempPURoot.getParentFile().getAbsolutePath());
        } else {
            tempPURoot = new File(genPath, path);
            params.getClassPath().addFirst(tempPURoot.getAbsolutePath());
        }
        tempPURoot.mkdirs();
        params.getVMParametersList().add("-Dcom.jetbrains.jpa.root=" + tempPURoot.getAbsolutePath());
    }

    @Override
    public void run() {
        JpaConsole.newConsole(this.myUnitFile).withRunConfiguration(this.myRunConfiguration).build().showConsole(true);
    }
}

