/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.JamNavigationGutterIconBuilder;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JpaClassLineMarkerProvider
implements LineMarkerProvider {
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/highlighting/JpaClassLineMarkerProvider", "getLineMarkerInfo"));
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/jpa/highlighting/JpaClassLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jpa/highlighting/JpaClassLineMarkerProvider", "collectSlowLineMarkers"));
        }
        for (PsiElement element : elements) {
            ProgressManager.checkCanceled();
            JpaClassLineMarkerProvider.annotate(element, result);
        }
    }

    public static void annotate(PsiElement element, Collection<LineMarkerInfo> result) {
        if (!(element instanceof PsiIdentifier)) {
            return;
        }
        PsiElement psiElement = element.getParent();
        if (psiElement instanceof PsiClass) {
            if (!JamCommonUtil.isPlainJavaFile((PsiElement)psiElement.getContainingFile())) {
                return;
            }
            PsiClass psiClass = (PsiClass)psiElement;
            PersistenceClassRole[] roles = PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass);
            if (roles.length == 0) {
                return;
            }
            result.add(JpaClassLineMarkerProvider.createClassLineMarkerInfo(psiClass, roles));
        } else if (psiElement instanceof PsiField || psiElement instanceof PsiMethod) {
            if (!JamCommonUtil.isPlainJavaFile((PsiElement)psiElement.getContainingFile())) {
                return;
            }
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            if (psiClass == null || PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass).length == 0) {
                return;
            }
            PsiMember member = (PsiMember)psiElement;
            List attributes = PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes(member);
            if (!attributes.isEmpty()) {
                result.add(JpaClassLineMarkerProvider.createAttributeLineMarkerInfo(member, attributes));
            }
        }
    }

    @NotNull
    private static LineMarkerInfo createAttributeLineMarkerInfo(PsiMember member, List<PersistentAttribute> attributes) {
        String tooltipTitle;
        PsiIdentifier anchor = member instanceof PsiField ? ((PsiField)member).getNameIdentifier() : (member instanceof PsiMethod ? ((PsiMethod)member).getNameIdentifier() : member);
        Collection<CommonModelElement> targets = JpaClassLineMarkerProvider.collectAttributeTargets(member);
        PersistentAttribute source = attributes.get(0);
        JamNavigationGutterIconBuilder builder = JamNavigationGutterIconBuilder.createJamGutterBuilder((Icon)ElementPresentationManager.getIcon((Object)source), CommonModelElement.class);
        if (targets.isEmpty() && (tooltipTitle = JamNavigationGutterIconBuilder.getElementString((CommonModelElement)source)) != null) {
            builder.setTooltipTitle(tooltipTitle);
        }
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.setTargets(targets).setAlignment(GutterIconRenderer.Alignment.RIGHT).setPopupTitle(JpaHighlightingMessages.message("title.popup.choose.psi.target", new Object[0])).createLineMarkerInfo((PsiElement)anchor);
        if (relatedItemLineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaClassLineMarkerProvider", "createAttributeLineMarkerInfo"));
        }
        return relatedItemLineMarkerInfo;
    }

    private static Collection<CommonModelElement> collectAttributeTargets(PsiMember member) {
        final THashSet result = new THashSet();
        for (PersistentAttribute base : PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes(member)) {
            DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)base, DomElement.class);
            ContainerUtil.addIfNotNull((Object)((PersistentAttribute)domElement), (Collection)result);
            JpaClassLineMarkerProvider.processAttributeTargets(member.getContainingClass(), base, new PairProcessor<PersistentObject, PersistentRelationshipAttribute>(){

                public boolean process(PersistentObject persistentObject, PersistentRelationshipAttribute relationshipAttribute) {
                    if (relationshipAttribute != null) {
                        result.add((Object)relationshipAttribute);
                    } else {
                        result.add((Object)persistentObject);
                    }
                    return true;
                }
            });
        }
        return result;
    }

    private static void processAttributeTargets(PsiClass psiClass, PersistentAttribute attribute, PairProcessor<PersistentObject, PersistentRelationshipAttribute> processor) {
        block5: {
            block4: {
                if (!(attribute instanceof PersistentRelationshipAttribute)) break block4;
                PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)psiClass);
                PersistentRelationshipAttribute relationshipAttribute = (PersistentRelationshipAttribute)attribute;
                for (PersistentObject object : browser.queryTargetPersistentObjects(relationshipAttribute).findAll()) {
                    PersistentEntity entity = (PersistentEntity)object;
                    Collection list = browser.queryTheOtherSideAttributes(relationshipAttribute, false).findAll();
                    if (list.isEmpty()) {
                        processor.process((Object)entity, null);
                        continue;
                    }
                    for (PersistentRelationshipAttribute targetAttribute : list) {
                        processor.process((Object)entity, (Object)targetAttribute);
                    }
                }
                break block5;
            }
            if (!(attribute instanceof PersistentEmbeddedAttribute)) break block5;
            PersistentEmbeddedAttribute embeddedAttribute = (PersistentEmbeddedAttribute)attribute;
            PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)psiClass);
            for (PersistentObject object : browser.queryTargetPersistentObjects(embeddedAttribute).findAll()) {
                processor.process((Object)object, null);
            }
        }
    }

    @NotNull
    private static LineMarkerInfo createClassLineMarkerInfo(PsiClass psiClass, PersistenceClassRole[] roles) {
        String tooltipTitle;
        PersistenceListener source;
        PersistenceClassRole role = roles[0];
        JamNavigationGutterIconBuilder builder = JamNavigationGutterIconBuilder.createJamGutterBuilder((Icon)role.getIcon(), CommonModelElement.class);
        Collection<? extends CommonModelElement> targets = JpaClassLineMarkerProvider.collectClassTargets(roles);
        Object object = source = role.getPersistentObject() == null ? role.getEntityListener() : role.getPersistentObject();
        if (targets.isEmpty() && (tooltipTitle = JamNavigationGutterIconBuilder.getElementString((CommonModelElement)source)) != null) {
            builder.setTooltipTitle(tooltipTitle);
        }
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.setTargets(targets).setAlignment(GutterIconRenderer.Alignment.RIGHT).setPopupTitle(JpaHighlightingMessages.message("title.popup.choose.psi.target", new Object[0])).createLineMarkerInfo((PsiElement)psiClass.getNameIdentifier());
        if (relatedItemLineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaClassLineMarkerProvider", "createClassLineMarkerInfo"));
        }
        return relatedItemLineMarkerInfo;
    }

    private static Collection<? extends CommonModelElement> collectClassTargets(PersistenceClassRole[] roles) {
        THashSet result = new THashSet();
        for (PersistenceClassRole role : roles) {
            Object element = role.getPersistentObject() != null ? role.getPersistentObject() : role.getEntityListener();
            DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)element, DomElement.class);
            if (domElement == null) continue;
            result.add((Object)((CommonModelElement)domElement));
        }
        return result;
    }
}

