/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.intentions;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.ide.IdeBundle;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.common.persistence.mapping.EntityListener;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.actions.GenerateEntityListenerMethods;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaAddEntityListenerAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.jpa.intentions.JpaAddEntityListenerAction");

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/intentions/JpaAddEntityListenerAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/intentions/JpaAddEntityListenerAction", "isAvailable"));
        }
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiJavaFile) || file.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (targetClass == null || !targetClass.isValid() || targetClass.getQualifiedName() == null) {
            return false;
        }
        if (!HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)targetClass).containsRange(offset, offset + 1)) {
            return false;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)targetClass, PsiErrorElement.class) != null) {
            return false;
        }
        if (targetClass.getDocComment() != null && targetClass.getDocComment().getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        String text = JpaAddEntityListenerAction.getExplanation(targetClass);
        if (text != null) {
            this.setText(text);
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = JpaMessages.message((String)"intention.persistence.add.entity.listener.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/intentions/JpaAddEntityListenerAction", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    public static String getExplanation(PsiClass member) {
        return JpaAddEntityListenerAction.findAvailableFacet(member) != null ? JpaMessages.message((String)"intention.persistence.add.entity.listener.text", (Object[])new Object[]{member.getName()}) : null;
    }

    @Nullable
    private static PersistenceClassRole findAvailableFacet(PsiClass member) {
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)member)) {
            if (role.getType() != PersistenceClassRoleEnum.ENTITY && role.getType() != PersistenceClassRoleEnum.MAPPED_SUPERCLASS) continue;
            return role;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/intentions/JpaAddEntityListenerAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/intentions/JpaAddEntityListenerAction", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        this.generateEntityListenerAnnotation(project, editor, element.getContainingFile());
    }

    private void generateEntityListenerAnnotation(final Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        PsiClass member = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        assert (member != null);
        final PsiAnnotation psiAnnotationCur = member.getModifierList().findAnnotation("javax.persistence.EntityListeners");
        List<AnnotationGenericValue<PsiClass>> list = AnnotationModelUtil.getPsiClassArrayValue(psiAnnotationCur, "value");
        final HashSet<Object> excludedClasses = new HashSet<Object>();
        for (AnnotationGenericValue<PsiClass> value : list) {
            excludedClasses.add(value.getValue());
        }
        PersistenceFacet facet = JpaAddEntityListenerAction.findAvailableFacet(member).getFacet();
        final HashSet entityListenerClasses = (HashSet)PersistenceCommonUtil.mapPersistenceRoles(new HashSet(), (Project)project, (PersistenceFacet)facet, null, (Function)new Function<PersistenceClassRole, PsiClass>(){

            public PsiClass fun(PersistenceClassRole role) {
                PsiClass aClass;
                if (role.getEntityListener() instanceof EntityListener && (aClass = (PsiClass)role.getEntityListener().getClazz().getValue()) != null && !excludedClasses.contains(aClass)) {
                    return aClass;
                }
                return null;
            }
        });
        String previousSingleValue = null;
        if (psiAnnotationCur != null && psiAnnotationCur.isValid()) {
            PsiAnnotationMemberValue annotationMemberValue = psiAnnotationCur.findAttributeValue("value");
            boolean deleteCurrentAnnotation = false;
            if (annotationMemberValue instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue psiArrayInitializerMemberValue = (PsiArrayInitializerMemberValue)annotationMemberValue;
                PsiAnnotationMemberValue[] memberValues = psiArrayInitializerMemberValue.getInitializers();
                if (memberValues.length != 0) {
                    editor.getCaretModel().moveToOffset(memberValues[memberValues.length - 1].getTextRange().getEndOffset());
                } else {
                    deleteCurrentAnnotation = true;
                }
            } else if (annotationMemberValue != null) {
                previousSingleValue = annotationMemberValue.getText();
                deleteCurrentAnnotation = true;
            } else {
                deleteCurrentAnnotation = true;
            }
            if (deleteCurrentAnnotation) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            psiAnnotationCur.delete();
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }
        Expression classExpression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return null;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return (LookupElement[])ContainerUtil.map2Array((Collection)entityListenerClasses, LookupElement.class, (Function)new Function<PsiClass, LookupElement>(){

                    public LookupElement fun(PsiClass s) {
                        return JavaClassNameCompletionContributor.createClassLookupItem((PsiClass)s, (boolean)true);
                    }
                });
            }
        };
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
        if (psiAnnotationCur != null && psiAnnotationCur.isValid()) {
            template.addTextSegment(", ");
            template.addVariable("class", classExpression, classExpression, true);
            template.addTextSegment(".class");
        } else {
            editor.getCaretModel().moveToOffset(member.getModifierList().getTextOffset());
            template.addTextSegment("@javax.persistence.EntityListeners({");
            if (previousSingleValue != null) {
                template.addTextSegment(previousSingleValue + ", ");
            }
            template.addVariable("class", classExpression, classExpression, true);
            template.addTextSegment(".class})\n");
        }
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        templateState.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

            public void beforeTemplateFinished(TemplateState state, Template template) {
                TextResult textResult = state.getVariableValue("class");
                if (textResult.getText().length() > 0) {
                    TextRange textRange = state.getVariableRange("class");
                    PsiElement psiElement = file.findElementAt(textRange.getStartOffset());
                    if (psiElement == null) {
                        return;
                    }
                    PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClassObjectAccessExpression.class);
                    if (classObjectAccessExpression == null) {
                        return;
                    }
                    PsiClassType classType = (PsiClassType)classObjectAccessExpression.getOperand().getType();
                    PsiClass psiClass = JpaAddEntityListenerAction.this.ensureEntityListenerClassExists(project, file, classType.getCanonicalText());
                    if (psiClass != null && !classType.getCanonicalText().equals(psiClass.getQualifiedName())) {
                        try {
                            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
                            classObjectAccessExpression.getOperand().replace((PsiElement)psiElementFactory.createTypeElement((PsiType)psiElementFactory.createType(psiClass)));
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
        });
    }

    @Nullable
    private PsiClass ensureEntityListenerClassExists(final Project project, PsiFile file, String className) {
        String targetPackageName;
        if (className == null) {
            return null;
        }
        PsiClass psiTargetClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass(className, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)ModuleUtil.findModuleForPsiElement((PsiElement)file)));
        if (psiTargetClass != null) {
            return psiTargetClass;
        }
        String shortClassName = PsiNameHelper.getShortClassName((String)className);
        if (shortClassName.length() < className.length()) {
            targetPackageName = className.substring(0, className.lastIndexOf(shortClassName) - 1);
        } else {
            PsiDirectory sourceDir = file.getContainingDirectory();
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(sourceDir);
            targetPackageName = aPackage != null ? aPackage.getQualifiedName() : "";
        }
        final CreateClassDialog dialog = new CreateClassDialog(project, JpaMessages.message((String)"dialog.title.new.typename", (Object[])new Object[]{JpaMessages.message((String)"persistence.entity.listener.type", (Object[])new Object[0])}), shortClassName, targetPackageName, (ClassKind)CreateClassKind.CLASS, false, ModuleUtil.findModuleForPsiElement((PsiElement)file));
        if (!dialog.showAndGet()) {
            return null;
        }
        final PsiDirectory targetDirectory = dialog.getTargetDirectory();
        if (targetDirectory == null) {
            return null;
        }
        PsiClass targetClass = (PsiClass)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
                try {
                    return JavaDirectoryService.getInstance().createClass(targetDirectory, dialog.getClassName());
                }
                catch (IncorrectOperationException e) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]), (String)StringUtil.getMessage((Throwable)e));
                        }
                    });
                    return null;
                }
            }
        });
        if (targetClass == null) {
            return null;
        }
        Editor editor1 = CodeInsightUtil.positionCursorAtLBrace((Project)project, (PsiFile)targetClass.getContainingFile(), (PsiClass)targetClass);
        if (editor1 != null) {
            new GenerateEntityListenerMethods().actionPerformedImpl(project, editor1);
        }
        return targetClass;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

