/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.jam.JamElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.common.persistence.mapping.EntityListener;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerBinding;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethod;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethodType;
import com.intellij.jpa.model.annotations.mapping.EntityBaseImpl;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.GenericValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityListenerImpl
extends CommonModelElement.PsiBase
implements EntityListener,
JamElement {
    public static final JamAnnotationMeta ENTITY_LISTENERS_ANNO_META = new JamAnnotationMeta("javax.persistence.EntityListeners").addAttribute((JamAttributeMeta)JamAttributeMeta.CLASS_COLLECTION_VALUE_META);
    public static final JamClassMeta<EntityListenerImpl> ENTITY_LISTENER_META = new JamClassMeta(null, EntityListenerImpl.class);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.jpa.model.annotations.mapping.EntityListenerImpl");
    private final PsiClass myPsiClass;

    public EntityListenerImpl(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityListenerImpl", "getPsiElement"));
        }
        return psiClass;
    }

    public boolean isValid() {
        return super.isValid() && Comparing.equal((Object)ENTITY_LISTENER_META.getJamElement((PsiModifierListOwner)this.getPsiClass()), (Object)((Object)this));
    }

    public GenericValue<PsiClass> getClazz() {
        return AnnotationGenericValue.getInstance(this.getPsiClass(), null, null);
    }

    public void processEntityListenerBindings(final Processor<EntityListenerBinding> processor) {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null || !psiClass.isValid()) {
            return;
        }
        ReferencesSearch.search((PsiElement)psiClass).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference t) {
                final PsiClassObjectAccessExpression classAccessExpression = (PsiClassObjectAccessExpression)PsiTreeUtil.getParentOfType((PsiElement)t.getElement(), PsiClassObjectAccessExpression.class);
                if (classAccessExpression != null) {
                    PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)classAccessExpression, PsiAnnotation.class);
                    final PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)classAccessExpression, PsiMember.class);
                    if (psiMember instanceof PsiClass && psiAnnotation != null && "javax.persistence.EntityListeners".equals(psiAnnotation.getQualifiedName()) && !processor.process((Object)new EntityListenerBinding(){

                        public String getEntityBaseClassName() {
                            return ((PsiClass)psiMember).getQualifiedName();
                        }

                        @NotNull
                        public PersistentEntityBase getTargetObject() {
                            PersistentEntityBase persistentEntityBase = (PersistentEntityBase)JpaUtil.getFirstPersistentObjectOfClass((PsiClass)psiMember, EntityBaseImpl.class);
                            if (persistentEntityBase == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityListenerImpl$1$1", "getTargetObject"));
                            }
                            return persistentEntityBase;
                        }

                        public void delete() {
                            try {
                                PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)classAccessExpression, PsiAnnotation.class);
                                if (psiAnnotation != null && AnnotationModelUtil.getPsiClassArrayValue(psiAnnotation, "value").size() == 1) {
                                    psiAnnotation.delete();
                                } else {
                                    classAccessExpression.delete();
                                }
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    })) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    public void processEntityListenerMethods(@Nullable PsiClass currentClass, Processor<EntityListenerMethod> processor) {
        boolean processDeep;
        PsiClass topClass = this.getPsiClass();
        boolean bl = processDeep = currentClass == null;
        if (topClass == null || !processDeep && topClass != currentClass && !topClass.isInheritor(currentClass, true)) {
            return;
        }
        EntityListenerImpl.processEntityListenerMethodsImpl(processDeep ? topClass : currentClass, processor, processDeep);
    }

    static void processEntityListenerMethodsImpl(PsiClass interceptorClass, final Processor<EntityListenerMethod> processor, boolean processDeep) {
        block0: for (final EntityListenerMethodType type : EntityListenerMethodType.values()) {
            PsiClass annotationClass = JavaPsiFacade.getInstance((Project)interceptorClass.getProject()).findClass(type.getMethodAnnotation(), interceptorClass.getResolveScope());
            if (annotationClass == null) continue;
            for (final PsiClass currentClass : JamCommonUtil.getSuperClassList((PsiClass)interceptorClass)) {
                AnnotatedMembersSearch.search((PsiClass)annotationClass, (SearchScope)GlobalSearchScope.fileScope((PsiFile)currentClass.getContainingFile())).forEach((Processor)new Processor<PsiMember>(){

                    public boolean process(PsiMember t) {
                        return !(t instanceof PsiMethod) || t.getContainingClass() != currentClass || processor.process((Object)new MyEntityListenerMethod(t, type));
                    }
                });
                if (processDeep) continue;
                continue block0;
            }
        }
    }

    private static class MyEntityListenerMethod
    implements EntityListenerMethod {
        private final PsiMember myT;
        private final EntityListenerMethodType myType;

        public MyEntityListenerMethod(PsiMember t, EntityListenerMethodType type) {
            this.myT = t;
            this.myType = type;
        }

        @Nullable
        public PsiMethod getMethod() {
            return (PsiMethod)this.myT;
        }

        public EntityListenerMethodType getType() {
            return this.myType;
        }

        public void delete() throws IncorrectOperationException {
            PsiAnnotation psiAnnotation = this.getDefiningElement();
            if (psiAnnotation != null) {
                psiAnnotation.delete();
            }
        }

        public PsiAnnotation getDefiningElement() {
            return this.myT.getModifierList().findAnnotation(this.myType.getMethodAnnotation());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyEntityListenerMethod that = (MyEntityListenerMethod)o;
            if (this.myT != null ? !this.myT.equals(that.myT) : that.myT != null) {
                return false;
            }
            return this.myType == that.myType;
        }

        public int hashCode() {
            int result = this.myT != null ? this.myT.hashCode() : 0;
            result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
            return result;
        }
    }
}

