/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.model.common.persistence.mapping.CollectionTable;
import com.intellij.javaee.model.common.persistence.mapping.JoinTable;
import com.intellij.javaee.model.common.persistence.mapping.SecondaryTable;
import com.intellij.javaee.model.common.persistence.mapping.Table;
import com.intellij.jpa.model.annotations.mapping.ColumnImpl;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.annotations.mapping.PersistentObjectImpl;
import com.intellij.jpa.model.annotations.mapping.UniqueConstraintImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.persistence.facet.PersistencePackageDefaults;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.xml.GenericValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableBaseImpl
extends CommonModelElement.PsiBase
implements Table,
JamElement {
    public static final JamStringAttributeMeta.Single<String> CATALOG_VALUE_META = JamAttributeMeta.singleString((String)"catalog", ColumnImpl.UNQUOTING_CONVERTER);
    public static final JamStringAttributeMeta.Single<String> SCHEMA_VALUE_META = JamAttributeMeta.singleString((String)"schema", ColumnImpl.UNQUOTING_CONVERTER);
    public static final JamAttributeMeta<List<UniqueConstraintImpl>> UNIQUE_CONSTRAINTS_VALUE_META = JamAttributeMeta.annoCollection((String)"uniqueConstraints", (JamAnnotationMeta)UniqueConstraintImpl.UNIQUE_CONSTRAINT_ANNO_META, UniqueConstraintImpl.class);
    public static final JamAnnotationArchetype TABLE_ANNO_ARCHETYPE = new JamAnnotationArchetype().addAttribute(ColumnImpl.NAME_STRING_VALUE_META).addAttribute(CATALOG_VALUE_META).addAttribute(SCHEMA_VALUE_META).addAttribute(UNIQUE_CONSTRAINTS_VALUE_META);
    public static final JamAnnotationMeta TABLE_ANNO_META = new JamAnnotationMeta("javax.persistence.Table", TABLE_ANNO_ARCHETYPE);
    public static final JamAttributeMeta<List<ColumnImpl.PkJoinColumnImpl>> PK_JOIN_COLUMNS_VALUE_META = JamAttributeMeta.annoCollection((String)"pkJoinColumns", (JamAnnotationMeta)ColumnImpl.PK_JOIN_COLUMN_ANNO_META, ColumnImpl.PkJoinColumnImpl.class);
    public static final JamAttributeMeta<List<ColumnImpl.JoinColumnImpl>> JOIN_COLUMNS_VALUE_META = JamAttributeMeta.annoCollection((String)"joinColumns", (JamAnnotationMeta)ColumnImpl.JOIN_COLUMN_ANNO_META, ColumnImpl.JoinColumnImpl.class);
    public static final JamAttributeMeta<List<ColumnImpl.JoinColumnImpl>> INVERSE_JOIN_COLUMNS_VALUE_META = JamAttributeMeta.annoCollection((String)"inverseJoinColumns", (JamAnnotationMeta)ColumnImpl.JOIN_COLUMN_ANNO_META, ColumnImpl.JoinColumnImpl.class);
    public static final JamAnnotationMeta SECONDARY_TABLE_ANNO_META = new JamAnnotationMeta("javax.persistence.SecondaryTable", TABLE_ANNO_ARCHETYPE).addAttribute(PK_JOIN_COLUMNS_VALUE_META);
    public static final JamAnnotationMeta JOIN_TABLE_ANNO_META = new JamAnnotationMeta("javax.persistence.JoinTable", TABLE_ANNO_ARCHETYPE).addAttribute(JOIN_COLUMNS_VALUE_META).addAttribute(INVERSE_JOIN_COLUMNS_VALUE_META);
    public static final JamAnnotationMeta COLLECTION_TABLE_ANNO_META = new JamAnnotationMeta("javax.persistence.CollectionTable", TABLE_ANNO_ARCHETYPE).addAttribute(JOIN_COLUMNS_VALUE_META);
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private final PsiMember myPsiMember;

    public TableBaseImpl(PsiMember psiMember) {
        this.myPsiAnnotation = this.getAnnoMeta().getAnnotationRef((PsiModifierListOwner)psiMember);
        this.myPsiMember = psiMember;
    }

    public TableBaseImpl(PsiElementRef<PsiAnnotation> psiAnnotation) {
        this.myPsiAnnotation = psiAnnotation;
        this.myPsiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation.getRoot(), PsiMember.class, (boolean)false);
    }

    protected abstract JamAnnotationMeta getAnnoMeta();

    @NotNull
    public PsiElement getPsiElement() {
        PsiMember psiMember = this.myPsiMember;
        if (psiMember == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/TableBaseImpl", "getPsiElement"));
        }
        return psiMember;
    }

    public PsiMember getPsiMember() {
        return this.myPsiMember;
    }

    public PsiElementRef<PsiAnnotation> getAnnoRef() {
        return this.myPsiAnnotation;
    }

    public GenericValue<String> getTableName() {
        return ColumnImpl.NAME_STRING_VALUE_META.getJam(this.myPsiAnnotation, (Factory)new Factory<String>(){

            @Nullable
            public String create() {
                return TableBaseImpl.this.getDefaultTableName();
            }
        });
    }

    public GenericValue<String> getCatalog() {
        return CATALOG_VALUE_META.getJam(this.myPsiAnnotation, (Factory)new Factory<String>(){

            @Nullable
            public String create() {
                return PersistentObjectImpl.getDefaultValue(TableBaseImpl.this.getPsiMember(), new NullableFunction<PersistencePackageDefaults, String>(){

                    public String fun(PersistencePackageDefaults persistenceUnitDefaults) {
                        return persistenceUnitDefaults.getCatalog();
                    }
                });
            }
        });
    }

    public GenericValue<String> getSchema() {
        return SCHEMA_VALUE_META.getJam(this.myPsiAnnotation, (Factory)new Factory<String>(){

            @Nullable
            public String create() {
                return PersistentObjectImpl.getDefaultValue(TableBaseImpl.this.getPsiMember(), new NullableFunction<PersistencePackageDefaults, String>(){

                    public String fun(PersistencePackageDefaults persistenceUnitDefaults) {
                        return persistenceUnitDefaults.getSchema();
                    }
                });
            }
        });
    }

    public List<ColumnImpl.PkJoinColumnImpl> getPrimaryKeyJoinColumns() {
        return (List)PK_JOIN_COLUMNS_VALUE_META.getJam(this.myPsiAnnotation);
    }

    public List<ColumnImpl.JoinColumnImpl> getJoinColumns() {
        return (List)JOIN_COLUMNS_VALUE_META.getJam(this.myPsiAnnotation);
    }

    public List<ColumnImpl.JoinColumnImpl> getInverseJoinColumns() {
        return (List)INVERSE_JOIN_COLUMNS_VALUE_META.getJam(this.myPsiAnnotation);
    }

    public List<UniqueConstraintImpl> getUniqueConstraints() {
        return (List)UNIQUE_CONSTRAINTS_VALUE_META.getJam(this.myPsiAnnotation);
    }

    @Nullable
    private String getDefaultTableName() {
        EntityImpl entity = (EntityImpl)JamService.getJamService((Project)this.getPsiElement().getProject()).getJamElement((PsiElement)this.getPsiMember(), new JamMemberMeta[]{EntityImpl.ENTITY_META});
        return entity != null ? (String)entity.getName().getValue() : null;
    }

    public static final class CollectionTableImpl
    extends TableBaseImpl
    implements CollectionTable {
        public CollectionTableImpl(PsiElementRef<PsiAnnotation> psiAnnotation) {
            super(psiAnnotation);
        }

        @Override
        protected JamAnnotationMeta getAnnoMeta() {
            return COLLECTION_TABLE_ANNO_META;
        }
    }

    public static final class JoinTableImpl
    extends TableBaseImpl
    implements JoinTable {
        public JoinTableImpl(PsiElementRef<PsiAnnotation> psiAnnotation) {
            super(psiAnnotation);
        }

        @Override
        protected JamAnnotationMeta getAnnoMeta() {
            return JOIN_TABLE_ANNO_META;
        }
    }

    public static class SecondaryTableImpl
    extends TableBaseImpl
    implements SecondaryTable {
        public SecondaryTableImpl(PsiElementRef<PsiAnnotation> psiAnnotation) {
            super(psiAnnotation);
        }

        @Override
        protected JamAnnotationMeta getAnnoMeta() {
            return SECONDARY_TABLE_ANNO_META;
        }
    }

    public static final class TableImpl
    extends TableBaseImpl {
        public TableImpl(PsiElementRef<PsiAnnotation> psiAnnotation) {
            super(psiAnnotation);
        }

        @Override
        protected JamAnnotationMeta getAnnoMeta() {
            return TABLE_ANNO_META;
        }
    }
}

