/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.manipulators;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.IntentionFilterOwner;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiTypeCodeFragmentImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeNameDialog
extends DialogWrapper {
    private JTextField myNameField;
    private JCheckBox myFieldAccessCheckBox;
    private JLabel myNameLabel;
    private JLabel myTypeLabel;
    private JLabel myMappedByLabel;
    private JComboBox myMappedByComboBox;
    private JPanel myMainPanel;
    private JCheckBox myInverseCheckBox;
    private JCheckBox myGeneratedCheckBox;
    private EditorTextField myTypeEditor;
    private final PersistentObject myObject;
    private final Function<PsiType, String> myTypeValidator;
    private PsiTypeCodeFragmentImpl myTypeFragment;
    private final PersistentAttributeType myAttributeType;
    private final RelationshipType myRelationshipType;
    private RangeHighlighter myRangeHighlighter;
    private final Set<String> myExistingNames;

    public AttributeNameDialog(PersistentObject object, PersistentAttributeType attributeType, RelationshipType relationshipType, Function<PsiType, String> typeValidator, String title, String defaultName) {
        super(object.getPsiManager().getProject(), true);
        this.myAttributeType = attributeType;
        this.myRelationshipType = relationshipType;
        this.myObject = object;
        this.myTypeValidator = typeValidator;
        this.setTitle(title);
        this.$$$setupUI$$$();
        this.init();
        this.setupControls();
        this.myNameField.setText(defaultName);
        this.myExistingNames = ContainerUtil.map2Set((Collection)this.myObject.getObjectModelHelper().getAttributes(), (Function)new NullableFunction<PersistentAttribute, String>(){

            public String fun(PersistentAttribute persistentAttribute) {
                return persistentAttribute.getName().getStringValue();
            }
        });
    }

    protected ValidationInfo doValidate() {
        PsiDocumentManager.getInstance((Project)this.myTypeFragment.getProject()).commitAllDocuments();
        String p1 = this.getNameProblems();
        if (p1 != null) {
            return new ValidationInfo(p1, (JComponent)this.myNameField);
        }
        String p2 = this.getTypeProblems();
        if (p2 != null) {
            return new ValidationInfo(p2, (JComponent)this.myTypeEditor);
        }
        String p3 = this.getTargetAttributeProblems();
        if (p3 != null) {
            return new ValidationInfo(p3, (JComponent)this.myMappedByComboBox);
        }
        return super.doValidate();
    }

    private void setupControls() {
        String name;
        this.myMappedByComboBox.setModel(new DefaultComboBoxModel());
        this.myNameLabel.setLabelFor(this.myNameField);
        this.myTypeLabel.setLabelFor((Component)this.myTypeEditor);
        this.myMappedByLabel.setLabelFor(this.myMappedByComboBox);
        this.myMappedByComboBox.setVisible(this.myRelationshipType != null);
        this.myMappedByLabel.setVisible(this.myRelationshipType != null);
        this.myInverseCheckBox.setVisible(this.myRelationshipType != null);
        this.myGeneratedCheckBox.setVisible(this.myAttributeType.isIdAttribute() && this.myAttributeType.accepts(PersistentAttributeType.AttributeComponent.SINGLE, PersistentAttributeType.ComponentType.BASIC));
        String ATTR_BASE = "attribute";
        int i = 0;
        while (true) {
            String string = name = i == 0 ? "attribute" : "attribute" + i;
            if (!this.hasAttribute(name)) break;
            ++i;
        }
        this.myNameField.setText(name);
        this.myFieldAccessCheckBox.setSelected(this.myObject.getObjectModelHelper().getDefaultAccessMode() == PropertyMemberType.FIELD);
        this.myFieldAccessCheckBox.setEnabled(!this.myObject.getObjectModelHelper().isAccessModeFixed());
        this.myTypeEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                AttributeNameDialog.this.updateMappedByVariants();
            }
        });
    }

    private void updateMappedByVariants() {
        PsiClass targetClass;
        if (!this.myMappedByComboBox.isVisible()) {
            return;
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.myMappedByComboBox.getModel();
        model.removeAllElements();
        PsiType type = this.getAttributeType();
        PsiType entityType = PersistenceCommonUtil.getTargetEntityType((PsiType)type);
        PsiClass psiClass = targetClass = entityType instanceof PsiClassType ? ((PsiClassType)entityType).resolve() : null;
        if (type == null || targetClass == null) {
            return;
        }
        String objectClassName = this.myObject.getClazz().getStringValue();
        THashSet attributeNames = new THashSet();
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)targetClass)) {
            if (role.getType() != PersistenceClassRoleEnum.ENTITY) continue;
            for (PersistentAttribute attribute : ((PersistentEntity)role.getPersistentObject()).getObjectModelHelper().getAttributes()) {
                PersistentRelationshipAttribute relationshipAttribute;
                GenericValue entityClass;
                String entityClassName;
                if (!(attribute instanceof PersistentRelationshipAttribute) || !StringUtil.isNotEmpty((String)(entityClassName = (entityClass = (relationshipAttribute = (PersistentRelationshipAttribute)attribute).getTargetEntityClass()).getStringValue())) || !Comparing.equal((String)entityClassName, (String)objectClassName) || !this.myRelationshipType.corresponds(relationshipAttribute.getAttributeModelHelper().getRelationshipType())) continue;
                ContainerUtil.addIfNotNull((Object)attribute.getName().getValue(), (Collection)attributeNames);
            }
        }
        for (String attributeName : attributeNames) {
            model.addElement(attributeName);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    @Nullable
    private String getTypeProblems() {
        String errorMsg;
        PsiType type = this.getAttributeType();
        String string = errorMsg = this.myTypeValidator == null ? null : (String)this.myTypeValidator.fun((Object)type);
        if (errorMsg != null && this.myRangeHighlighter == null) {
            if (this.myTypeEditor.getDocument().getLineCount() > 0) {
                MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.myTypeEditor.getDocument(), (Project)this.myTypeFragment.getProject(), (boolean)true);
                TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlightInfoType.ERROR.getAttributesKey());
                this.myRangeHighlighter = markupModel.addLineHighlighter(0, 5000, attributes);
            }
        } else if (errorMsg == null && this.myRangeHighlighter != null) {
            this.myRangeHighlighter.dispose();
            this.myRangeHighlighter = null;
        }
        return errorMsg;
    }

    @Nullable
    private String getTargetAttributeProblems() {
        String errorMessage = null;
        String name = (String)this.myMappedByComboBox.getEditor().getItem();
        if (StringUtil.isNotEmpty((String)name) && !PsiNameHelper.getInstance((Project)this.myObject.getPsiManager().getProject()).isIdentifier(name)) {
            errorMessage = JpaMessages.message((String)"attribute.0.not.identifier", (Object[])new Object[]{name});
        }
        return errorMessage;
    }

    @Nullable
    private String getNameProblems() {
        String errorMessage = null;
        if (!PsiNameHelper.getInstance((Project)this.myObject.getPsiManager().getProject()).isIdentifier(this.myNameField.getText())) {
            errorMessage = JpaMessages.message((String)"attribute.0.not.identifier", (Object[])new Object[]{this.myNameField.getText()});
        } else if (this.hasAttribute(this.myNameField.getText())) {
            errorMessage = JpaMessages.message((String)"attribute.0.already.exists", (Object[])new Object[]{this.myNameField.getText()});
        }
        return errorMessage;
    }

    private void createUIComponents() {
        PsiManager psiManager;
        PsiClassType stringType;
        String defaultType = this.myRelationshipType != null ? "" : (this.myTypeValidator.fun((Object)(stringType = PsiType.getJavaLangString((PsiManager)(psiManager = this.myObject.getPsiManager()), (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiManager.getProject())))) == null ? "java.lang.String" : "java.lang.Object");
        PsiManager manager = this.myObject.getPsiManager();
        PsiClass psiClass = (PsiClass)this.myObject.getClazz().getValue();
        Project project = manager.getProject();
        PsiNamedElement context = (PsiNamedElement)(psiClass != null ? psiClass : JavaPsiFacade.getInstance((Project)project).findPackage(""));
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        this.myTypeFragment = (PsiTypeCodeFragmentImpl)factory.createTypeCodeFragment(defaultType, (PsiElement)context, true);
        this.myTypeFragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        this.myTypeFragment.putUserData(ModuleUtil.KEY_MODULE, (Object)this.myObject.getModule());
        this.myTypeFragment.setIntentionActionsFilter(IntentionFilterOwner.IntentionActionsFilter.EVERYTHING_AVAILABLE);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)this.myTypeFragment);
        this.myTypeEditor = new EditorTextField(document, project, (FileType)StdFileTypes.JAVA, false);
    }

    private boolean hasAttribute(String name) {
        return !StringUtil.isNotEmpty((String)name) && this.myExistingNames.contains(name);
    }

    public String getAttributeName() {
        return this.myNameField.getText();
    }

    @Nullable
    public PsiType getAttributeType() {
        try {
            return this.myTypeFragment.getType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isFieldAccess() {
        return this.myFieldAccessCheckBox.isSelected();
    }

    public boolean isInverse() {
        return this.myInverseCheckBox.isSelected();
    }

    public boolean isGenerated() {
        return this.myGeneratedCheckBox.isSelected();
    }

    @Nullable
    public String getTargetAttributeName() {
        return !this.myMappedByComboBox.isVisible() ? null : (String)this.myMappedByComboBox.getEditor().getItem();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/manipulators/AttributeNameDialog", "createActions"));
        }
        return actionArray;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JComboBox jComboBox;
        JCheckBox jCheckBox3;
        JLabel jLabel;
        JLabel jLabel2;
        JTextField jTextField;
        JLabel jLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(4, 8, 4, 8), -1, -1, false, false));
        this.myNameLabel = jLabel3 = new JLabel();
        jLabel3.setText("Name");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setColumns(40);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Type");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMappedByLabel = jLabel = new JLabel();
        jLabel.setText("Mapped By");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFieldAccessCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Field Access");
        jCheckBox3.setMnemonic('F');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMappedByComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myGeneratedCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Generated");
        jCheckBox2.setMnemonic('G');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInverseCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Inverse");
        jCheckBox.setMnemonic('I');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 3, 1, 2, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 3, 1, 2, 0, 1, 6, 1, null, null, null));
        EditorTextField editorTextField = this.myTypeEditor;
        jPanel.add((Component)editorTextField, new GridConstraints(1, 1, 1, 4, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

