/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.QlFileType;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.model.QlModelProvider;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlInputParameter;
import com.intellij.jpa.ql.psi.QlQueryExpression;
import com.intellij.jpa.ql.psi.QlRecursiveVisitor;
import com.intellij.jpa.ql.psi.QlSelectStatement;
import com.intellij.lang.Language;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QlFileImpl
extends PsiFileBase
implements QlFile {
    private final CachedValue<Map<String, PsiElement>> myParameters = CachedValuesManager.getManager((Project)this.getManager().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, PsiElement>>(){

        public CachedValueProvider.Result<Map<String, PsiElement>> compute() {
            THashMap map = new THashMap();
            QlFileImpl.this.accept(new QlRecursiveVisitor((Map)map){
                final /* synthetic */ Map val$map;
                {
                    this.val$map = map;
                }

                @Override
                public void visitInputParameter(@NotNull QlInputParameter o) {
                    String realName;
                    if (o == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/psi/impl/QlFileImpl$1$1", "visitInputParameter"));
                    }
                    String name = QlFileImpl.getParameterName(o);
                    String string = realName = StringUtil.isEmpty((String)name) ? String.valueOf(this.val$map.size()) : name;
                    if (!this.val$map.containsKey(realName)) {
                        this.val$map.put(realName, new ParameterDefinition(o));
                    }
                }
            });
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{QlFileImpl.this});
        }
    }, false);

    public QlFileImpl(FileViewProvider fileViewProvider) {
        this(fileViewProvider, JpqlLanguage.JPQL);
    }

    protected QlFileImpl(FileViewProvider provider, Language language) {
        super(provider, language);
    }

    private static String getParameterName(QlInputParameter o) {
        return o.getText().substring(1).trim();
    }

    @NotNull
    public FileType getFileType() {
        QlFileType qlFileType = QlFileType.JPQL_FILE_TYPE;
        if (qlFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlFileImpl", "getFileType"));
        }
        return qlFileType;
    }

    @Override
    public QlQueryExpression getQuery() {
        PsiElement child = this.getFirstChild();
        QlExpression expression = child instanceof QlSelectStatement ? ((QlSelectStatement)child).getExpression() : null;
        return expression instanceof QlQueryExpression ? (QlQueryExpression)expression : null;
    }

    @Nullable
    public static QlModel getPersistenceModel(PsiElement element) {
        PsiElement originalElement = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        for (QlModelProvider provider : (QlModelProvider[])Extensions.getExtensions(QlModelProvider.EP_NAME)) {
            QlModel model = provider.getQlModel(originalElement);
            if (model == null) continue;
            return model;
        }
        return null;
    }

    @Override
    @NotNull
    public final QlModel getQlModel() {
        QlModel model;
        PsiElement context = this.getContext();
        QlModel qlModel = model = context != null ? (QlModel)context.getUserData(PERSISTENCE_MODEL_KEY) : null;
        if (model == null) {
            model = (QlModel)this.getUserData(PERSISTENCE_MODEL_KEY);
        }
        if (model == null) {
            model = (QlModel)this.getOriginalFile().getUserData(PERSISTENCE_MODEL_KEY);
        }
        if (model == null) {
            model = QlFileImpl.getPersistenceModel((PsiElement)this.getOriginalFile());
            if (model == null) {
                model = QlModel.EMPTY_MODEL;
            }
            this.putUserData(PERSISTENCE_MODEL_KEY, model);
        }
        QlModel qlModel2 = model;
        if (qlModel2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlFileImpl", "getQlModel"));
        }
        return qlModel2;
    }

    @Override
    @NotNull
    public Map<String, PsiElement> getParameterDeclarations() {
        Map map = (Map)this.myParameters.getValue();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlFileImpl", "getParameterDeclarations"));
        }
        return map;
    }

    public class ParameterDefinition
    extends RenameableFakePsiElement
    implements PsiNamedElement,
    NavigationItem {
        private final QlInputParameter myUsage;

        public ParameterDefinition(QlInputParameter o) {
            super((PsiElement)QlFileImpl.this);
            this.myUsage = o;
        }

        public String getName() {
            return QlFileImpl.getParameterName(this.myUsage);
        }

        @Nullable
        public TextRange getTextRange() {
            return this.myUsage.getTextRange();
        }

        @NotNull
        public PsiElement getNavigationElement() {
            QlInputParameter qlInputParameter = this.myUsage;
            if (qlInputParameter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/psi/impl/QlFileImpl$ParameterDefinition", "getNavigationElement"));
            }
            return qlInputParameter;
        }

        public PsiElement getParent() {
            return this.getContainingFile();
        }

        public String getTypeName() {
            return "Query Parameter";
        }

        @Nullable
        public Icon getIcon() {
            return PlatformIcons.PARAMETER_ICON;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ParameterDefinition that = (ParameterDefinition)((Object)o);
            return this.myUsage.equals(that.myUsage);
        }

        public int hashCode() {
            return this.myUsage.hashCode();
        }

        public boolean isValid() {
            return super.isValid() && QlFileImpl.this.getParameterDeclarations().containsValue((Object)this);
        }
    }
}

