/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view.nodes;

import com.intellij.facet.Facet;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.tree.JamTreeParameters;
import com.intellij.javaee.module.view.common.editor.FacetAsVirtualFileImpl;
import com.intellij.javaee.module.view.nodes.JavaeeDeploymentDescriptorNodeDescriptor;
import com.intellij.jpa.view.nodes.PersistenceUnitNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.util.descriptors.ConfigFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class PersistenceFacetNodeDescriptor
extends JamNodeDescriptor<PersistenceFacet> {
    public PersistenceFacetNodeDescriptor(PersistenceFacet facet, NodeDescriptor parentDescriptor, Object parameters) {
        super(facet.getModule().getProject(), parentDescriptor, parameters, (Object)facet);
    }

    public int getWeight() {
        return Integer.MAX_VALUE;
    }

    protected String getNewNodeText() {
        if (this.getFacet().isDisposed()) {
            return null;
        }
        return ((PersistenceFacet)this.getElement()).getModule().getName();
    }

    private Facet getFacet() {
        return (Facet)this.getElement();
    }

    public boolean isValid() {
        return !this.getFacet().isDisposed();
    }

    protected Icon getNewIcon() {
        return this.getFacet().getType().getIcon();
    }

    private static List<JamNodeDescriptor> getChildrenDescriptors(PersistenceFacet facet, NodeDescriptor parent, Object parameters, boolean includeDeploymentItems) {
        JamTreeParameters moduleParameters = (JamTreeParameters)parameters;
        if (facet == null || !moduleParameters.showMembers()) {
            return Collections.emptyList();
        }
        ArrayList<JamNodeDescriptor> result = new ArrayList<JamNodeDescriptor>();
        if (includeDeploymentItems) {
            for (ConfigFile descriptor : facet.getDescriptors()) {
                JavaeeDeploymentDescriptorNodeDescriptor nodeDescriptor;
                if (descriptor.getPsiFile() == null || !moduleParameters.isNodeEnabled((NodeDescriptor)(nodeDescriptor = new JavaeeDeploymentDescriptorNodeDescriptor(descriptor, parent, (Object)moduleParameters)))) continue;
                result.add((JamNodeDescriptor)nodeDescriptor);
            }
        }
        for (PersistencePackage unit : facet.getPersistenceUnits()) {
            PersistenceUnitNodeDescriptor nodeDescriptor = new PersistenceUnitNodeDescriptor(unit, parent, (Object)moduleParameters);
            if (!moduleParameters.isNodeEnabled((NodeDescriptor)nodeDescriptor)) continue;
            result.add(nodeDescriptor);
        }
        return result;
    }

    public JamNodeDescriptor[] getChildren() {
        return PersistenceFacetNodeDescriptor.getChildrenDescriptors((PersistenceFacet)this.getElement(), (NodeDescriptor)this, this.getParameters(), true).toArray(JamNodeDescriptor.EMPTY_ARRAY);
    }

    public Object getData(String dataId) {
        if (PersistenceDataKeys.PERSISTENCE_FACET_CONTEXT.is(dataId) || PersistenceDataKeys.PERSISTENCE_FACET.is(dataId)) {
            return this.getElement();
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            return ((PersistenceFacet)this.getElement()).getModule();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return FacetAsVirtualFileImpl.fileByPath(this.getFacet());
        }
        return super.getData(dataId);
    }

    public boolean expandOnDoubleClick() {
        return false;
    }
}

