/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.jsp.impl.CustomTagDescriptorBaseImpl;
import com.intellij.jsp.impl.CustomTagSupportUtil;
import com.intellij.jsp.impl.JspElementDescriptorEx;
import com.intellij.jsp.impl.MyTEI;
import com.intellij.jsp.impl.TldAttributeDescriptorImpl;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.jsp.impl.TldTagFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import javax.servlet.jsp.tagext.TagExtraInfo;

public class TldTagFileDescriptorImpl
extends CustomTagDescriptorBaseImpl
implements TldTagFileDescriptor,
JspElementDescriptorEx {
    private volatile XmlTag myDclTag;

    public TldTagFileDescriptorImpl() {
    }

    public TldTagFileDescriptorImpl(XmlTag dcl, TldDescriptor nsDescriptor) {
        this.myNsDescriptor = nsDescriptor;
        this.init((PsiElement)dcl);
    }

    @Override
    protected XmlAttributeDescriptor[] doCalculateAttributes() {
        XmlTag[] attributes = this.myTag != null && JspPsiUtil.isInJspFile((PsiElement)this.myTag.getContainingFile()) ? JspPsiUtil.getJspFile((PsiElement)this.myTag.getContainingFile()).getDirectiveTags(JspDirectiveKind.ATTRIBUTE, true) : XmlTag.EMPTY;
        XmlAttributeDescriptor[] xmlAttributeDescriptors = new XmlAttributeDescriptor[attributes.length];
        for (int i = 0; i < xmlAttributeDescriptors.length; ++i) {
            xmlAttributeDescriptors[i] = new TldAttributeDescriptorImpl(attributes[i], CustomTagSupportUtil.ValueAccessor.ATTRIBUTE_ACCESSOR);
        }
        return xmlAttributeDescriptors;
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(XmlTag context) {
        return (XmlAttributeDescriptor[])myAttributeDescriptorsCache.get((Object)this);
    }

    public PsiElement getDeclaration() {
        return this.myDclTag.isPhysical() ? this.myDclTag : (this.myTag != null ? this.myTag.getContainingFile() : null);
    }

    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
        XmlTag dcl;
        this.myDclTag = dcl = (XmlTag)element;
        XmlTag pathTag = dcl.findFirstSubTag("path");
        String tagFilePath = pathTag != null ? pathTag.getValue().getTrimmedText() : null;
        XmlTag nameTag = dcl.findFirstSubTag("name");
        this.myName = nameTag != null ? nameTag.getValue().getTrimmedText() : null;
        XmlFile xmlFile = null;
        if (tagFilePath != null && this.myName != null) {
            if (pathTag.isPhysical()) {
                PsiReference[] references = pathTag.getReferences();
                if (references.length > 0) {
                    PsiElement psiElement = references[references.length - 1].resolve();
                    if (psiElement instanceof XmlFile) {
                        xmlFile = (XmlFile)psiElement;
                    } else {
                        VirtualFile virtualFileForJar;
                        PsiFile containingFile = element.getContainingFile();
                        VirtualFile virtualFile = containingFile.getVirtualFile();
                        if (virtualFile != null && virtualFile.getFileSystem() instanceof JarFileSystem && (virtualFileForJar = ((JarFileSystem)virtualFile.getFileSystem()).getVirtualFileForJar(virtualFile)) != null) {
                            PsiFile file;
                            String fileUrl = VirtualFileManager.constructUrl((String)"jar", (String)virtualFileForJar.getPath()) + "!/" + (tagFilePath.length() > 0 ? tagFilePath.substring(1) : "");
                            VirtualFile relativeFile = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
                            if (relativeFile != null && (file = pathTag.getManager().findFile(relativeFile)) instanceof XmlFile) {
                                xmlFile = (XmlFile)file;
                            }
                        }
                    }
                }
            } else {
                xmlFile = XmlUtil.findXmlFile((PsiFile)element.getContainingFile(), (String)tagFilePath);
            }
        }
        if (!(xmlFile instanceof JspFile)) {
            return;
        }
        PsiFile pageTags = ((JspFile)xmlFile).getDirectiveTags(JspDirectiveKind.PAGE, true);
        ArrayList<PsiFile> directivesList = new ArrayList<PsiFile>(((XmlTag[])pageTags).length);
        for (PsiFile pageTag : pageTags) {
            if (!pageTag.getName().endsWith("tag") && !pageTag.getName().endsWith("tagx")) continue;
            directivesList.add(pageTag);
        }
        XmlTag[] directiveTags = directivesList.toArray(new XmlTag[directivesList.size()]);
        if (directiveTags.length > 0) {
            this.myTag = directiveTags[0];
        }
        XmlTag rootTag = xmlFile.getDocument().getRootTag();
        if (this.myTag != null) {
            String bodyContent = this.myTag.getAttributeValue("body-content");
            this.myContentType = this.getContentType(bodyContent);
            String dynamicAttributes = this.myTag.getAttributeValue("dynamic-attributes");
            if (dynamicAttributes != null && dynamicAttributes.length() > 0) {
                this.myDynamicAttributes = true;
            }
        } else {
            this.myTag = rootTag;
        }
        XmlTag[] vars = ((JspFile)xmlFile).getDirectiveTags(JspDirectiveKind.VARIABLE, true);
        CustomTagSupportUtil.configureVariables(this.myTLDVars, vars, CustomTagSupportUtil.ValueAccessor.ATTRIBUTE_ACCESSOR);
        XmlTag[] attributes = ((JspFile)xmlFile).getDirectiveTags(JspDirectiveKind.ATTRIBUTE, true);
        CustomTagSupportUtil.configureAttributes(this.myTLDAttributes, attributes, CustomTagSupportUtil.ValueAccessor.ATTRIBUTE_ACCESSOR);
    }

    public Object[] getDependences() {
        return new Object[]{this.myTag, this.myDclTag, ExternalResourceManager.getInstance()};
    }

    @Override
    public TagExtraInfo getExtraInfo(Module module) {
        return new MyTEI(this.myTLDVars, this);
    }

    public XmlTag getRealDeclaration() {
        return this.myTag;
    }

    @Override
    public XmlTag findVariableWithName(String name) {
        XmlTag[] variableDirectives = JspPsiUtil.getJspFile((PsiElement)this.myTag).getDirectiveTags(JspDirectiveKind.VARIABLE, true);
        return this.findVariableWithName(variableDirectives, name, CustomTagSupportUtil.ValueAccessor.ATTRIBUTE_ACCESSOR);
    }
}

