/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jspx;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.lang.jsp.JspFormattingModelBuilder;
import com.intellij.lang.jspx.InlineTagContributor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.xml.XmlTag;

public class JspFormattingPolicy
extends HtmlPolicy {
    public JspFormattingPolicy(CodeStyleSettings settings, FormattingDocumentModel documentModel) {
        super(settings, documentModel);
    }

    protected boolean shouldBeWrapped(XmlTag tag) {
        String name = tag.getName();
        return name.length() != 0 && (JspFormattingPolicy.isScriptletObject(tag) || JspUtil.getDirectiveKindByTag((XmlTag)tag) != null);
    }

    protected boolean isInlineTag(XmlTag tag) {
        return this.checkName(tag, this.mySettings.HTML_INLINE_ELEMENTS) || JspFormattingPolicy.checkInlineTag(tag) || "jsp:expression".equals(tag.getName());
    }

    private static boolean checkInlineTag(XmlTag tag) {
        for (InlineTagContributor inlineTagContributor : (InlineTagContributor[])Extensions.getExtensions(InlineTagContributor.EP_NAME)) {
            if (!inlineTagContributor.accepted(tag)) continue;
            return inlineTagContributor.isInlineTag(tag);
        }
        return tag.getNamespacePrefix().length() > 0 && !JspFormattingPolicy.isScriptletObject(tag);
    }

    private static boolean isScriptletObject(XmlTag tag) {
        return "http://java.sun.com/JSP/Page".equals(tag.getNamespace());
    }

    public int getTextWrap(XmlTag tag) {
        return tag.getContainingFile() instanceof JspFile ? 0 : this.mySettings.HTML_TEXT_WRAP;
    }

    protected XmlFormattingPolicy getPolicy(final XmlBlock result) {
        JspFormattingModelBuilder.XmlPolicyWithJspXmlTag xmlPolicy = new JspFormattingModelBuilder.XmlPolicyWithJspXmlTag(this.mySettings, this.myDocumentModel){
            final XmlFormattingPolicy policy;
            {
                super(settings, documentModel);
                this.policy = result.getPolicy();
            }

            public boolean keepWhiteSpacesInsideTag(XmlTag xmlTag) {
                return this.policy.keepWhiteSpacesInsideTag(xmlTag);
            }
        };
        result.setXmlFormattingPolicy((XmlFormattingPolicy)xmlPolicy);
        return xmlPolicy;
    }
}

