/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.el.impl;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.jsp.el.impl.ELReference;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELLiteralExpression;
import com.intellij.psi.jsp.el.ELSliceExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.jsp.el.ElLiteralCustomReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class ElReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/psi/impl/source/jsp/el/impl/ElReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(ELExpression.class), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/el/impl/ElReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/el/impl/ElReferenceContributor$1", "getReferencesByElement"));
                }
                if (element instanceof ELVariable) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new ELReference((ELExpression)element)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/el/impl/ElReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (element instanceof ELLiteralExpression) {
                    PsiReference[] psiReferenceArray = ElReferenceContributor.getLiteralExpressionReferences((ELLiteralExpression)element);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/el/impl/ElReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/el/impl/ElReferenceContributor$1", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }

    private static PsiReference[] getLiteralExpressionReferences(ELLiteralExpression expression) {
        for (ElLiteralCustomReferenceProvider provider : (ElLiteralCustomReferenceProvider[])Extensions.getExtensions((ExtensionPointName)ElLiteralCustomReferenceProvider.EP_NAME)) {
            if (!provider.accept(expression)) continue;
            return provider.createReferences(expression);
        }
        PsiElement parent = expression.getParent();
        ELSliceExpression sliceParent = null;
        while (!(parent instanceof ELExpressionHolder)) {
            if (parent instanceof ELSliceExpression) {
                sliceParent = (ELSliceExpression)parent;
                break;
            }
            if (parent instanceof ELExpression) break;
            parent = parent.getParent();
        }
        if (sliceParent != null && expression.getText().length() > 2) {
            ELReference elReference = new ELReference((ELExpression)expression);
            return new PsiReference[]{elReference};
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

