/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.impl;

import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.module.view.web.WebRootFileUrl;
import com.intellij.javaee.module.view.web.WebView;
import com.intellij.javaee.web.artifact.WebFacetContextEvaluationService;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebDirectoryElementImpl
extends PsiElementBase
implements WebDirectoryElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.impl.WebDirectoryElementImpl");
    private final PsiManager myManager;
    private final WebFacet myWebFacet;
    private String myPath;
    private boolean myIsDirectory;
    private final WebFacetContextEvaluationService myWebFacetContextService;

    public WebDirectoryElementImpl(WebFacet webFacet, @NotNull String path, boolean isDirectory) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "<init>"));
        }
        this.myWebFacet = webFacet;
        String canonicalPath = PathUtil.getCanonicalPath((String)path);
        this.myPath = DeploymentUtil.appendToPath((String)"/", (String)(canonicalPath == null ? path : canonicalPath));
        this.myManager = PsiManager.getInstance((Project)webFacet.getModule().getProject());
        this.myIsDirectory = isDirectory;
        this.myWebFacetContextService = WebFacetContextEvaluationService.getInstance(this.myManager.getProject());
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getPath"));
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    @NotNull
    public List<VirtualFile> getOriginalVirtualFiles() {
        Module module = this.myWebFacet.getModule();
        if (module.isDisposed()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getOriginalVirtualFiles"));
            }
            return list;
        }
        List<VirtualFile> list = this.myWebFacetContextService.getOutputFiles(this.myWebFacet, this.myPath);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getOriginalVirtualFiles"));
        }
        return list;
    }

    public VirtualFile getOriginalVirtualFile() {
        List<VirtualFile> originalVirtualFiles = this.getOriginalVirtualFiles();
        if (originalVirtualFiles.size() >= 1) {
            return originalVirtualFiles.get(0);
        }
        return null;
    }

    public PsiFile getOriginalFile() {
        VirtualFile virtualFile = this.getOriginalVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return this.myManager.findFile(virtualFile);
    }

    @NotNull
    public String getName() {
        int lastSeparatorIndex = this.getPath().lastIndexOf(47);
        if (lastSeparatorIndex >= 0) {
            String string = this.getPath().substring(lastSeparatorIndex + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getName"));
            }
            return string;
        }
        String string = this.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getName"));
        }
        return string;
    }

    @Nullable
    private String getParentPath() {
        if (this.getPath().equals("/")) {
            return null;
        }
        return this.getPath().substring(0, this.getPath().lastIndexOf(47));
    }

    public boolean isWritable() {
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        for (VirtualFile virtualFile : virtualFiles) {
            if (virtualFile.isWritable()) continue;
            return false;
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "accept"));
        }
    }

    public boolean isValid() {
        return this.myManager != null && WebDirectoryUtil.getWebDirectoryUtil(this.myManager.getProject()).findWebDirectoryElementByPath(this.getPath(), this.myWebFacet) != null;
    }

    @Nullable
    public WebDirectoryElement getParent() {
        if ("/".equals(this.getPath())) {
            return null;
        }
        return WebDirectoryUtil.getWebDirectoryUtil(this.myManager.getProject()).findWebDirectoryElementByPath(this.getParentPath(), this.myWebFacet);
    }

    public WebDirectoryElement getParentDirectory() {
        return this.getParent();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.getOriginalVirtualFile();
    }

    @Nullable
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "setName"));
        }
        this.checkSetName(name);
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        for (VirtualFile file : virtualFiles) {
            PsiDirectory directory = this.myManager.findDirectory(file);
            if (directory == null) continue;
            directory.setName(name);
        }
        String parentPath = this.getParentPath();
        String newPath = parentPath == null ? name : DeploymentUtil.appendToPath((String)parentPath, (String)name);
        newPath = DeploymentUtil.appendToPath((String)"/", (String)newPath);
        return WebDirectoryUtil.resolveAbsolutePath(newPath, this.myWebFacet);
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        for (VirtualFile file : virtualFiles) {
            PsiDirectory directory = this.myManager.findDirectory(file);
            if (directory == null) continue;
            directory.checkSetName(name);
        }
    }

    @NotNull
    public Language getLanguage() {
        Language language = StdFileTypes.JAVA.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getLanguage"));
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    @NotNull
    public WebDirectoryElement[] getChildren() {
        if (!this.isDirectory()) {
            if (WebDirectoryElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getChildren"));
            }
            return WebDirectoryElement.EMPTY_ARRAY;
        }
        THashSet children = new THashSet();
        this.processChildren(new WebDirectoryElement.WebDirectoryProcessor((Set)children){
            final /* synthetic */ Set val$children;
            {
                this.val$children = set;
            }

            public boolean execute(String name, boolean isDirectory) throws Exception {
                WebDirectoryElementImpl.this.addChild(name, isDirectory, this.val$children);
                return true;
            }
        });
        WebDirectoryElement[] webDirectoryElementArray = children.toArray(new WebDirectoryElement[children.size()]);
        if (webDirectoryElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getChildren"));
        }
        return webDirectoryElementArray;
    }

    public boolean processChildren(final PsiElementProcessor<PsiFileSystemItem> processor) {
        final WebDirectoryElementImpl element = new WebDirectoryElementImpl(this.myWebFacet, "", false);
        return this.processChildren(new WebDirectoryElement.WebDirectoryProcessor(){

            public boolean execute(String name, boolean isDirectory) throws Exception {
                if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(name, isDirectory)) {
                    return true;
                }
                element.myIsDirectory = isDirectory;
                element.myPath = DeploymentUtil.appendToPath((String)"/", (String)PathUtil.getCanonicalPath((String)DeploymentUtil.appendToPath((String)WebDirectoryElementImpl.this.getPath(), (String)name)));
                return processor.execute((PsiElement)element);
            }
        });
    }

    public boolean processChildren(@NotNull WebDirectoryElement.WebDirectoryProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "processChildren"));
        }
        try {
            return this.myWebFacetContextService.processChildren(this.myWebFacet, this.myPath, processor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private void addChild(String name, boolean isDirectory, Collection<WebDirectoryElement> children) {
        WebDirectoryElement child = this.createElement(name, isDirectory);
        if (child != null) {
            children.add(child);
        }
    }

    public WebDirectoryElement createElement(String name, boolean isDirectory) {
        if (!FileTypeManager.getInstance().isFileIgnored(name)) {
            WebDirectoryElementImpl element = new WebDirectoryElementImpl(this.myWebFacet, DeploymentUtil.appendToPath((String)this.getPath(), (String)name), isDirectory);
            if (!isDirectory || element.isValid()) {
                return element;
            }
        }
        return null;
    }

    @NotNull
    public WebDirectoryElement[] getSubDirectories() {
        if (!this.isDirectory()) {
            if (WebDirectoryElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getSubDirectories"));
            }
            return WebDirectoryElement.EMPTY_ARRAY;
        }
        final ArrayList result = new ArrayList();
        this.processChildren(new WebDirectoryElement.WebDirectoryProcessor(){

            public boolean execute(String name, boolean isDirectory) throws Exception {
                if (isDirectory) {
                    WebDirectoryElementImpl.this.addChild(name, isDirectory, result);
                }
                return true;
            }
        });
        WebDirectoryElement[] webDirectoryElementArray = result.toArray(new WebDirectoryElement[result.size()]);
        if (webDirectoryElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getSubDirectories"));
        }
        return webDirectoryElementArray;
    }

    public PsiElement resolveRelative(String path) {
        WebDirectoryUtil webDirectoryUtil = WebDirectoryUtil.getWebDirectoryUtil(this.myManager.getProject());
        if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
            return webDirectoryUtil.findFileByPath(path, this.myWebFacet);
        }
        String localName = PathUtil.getCanonicalPath((String)DeploymentUtil.appendToPath((String)this.getPath(), (String)path));
        if (localName == null) {
            return null;
        }
        return webDirectoryUtil.findFileByPath("/" + localName, this.myWebFacet);
    }

    @NotNull
    public List<PsiDirectory> getSourcePsiDirectories() {
        ArrayList<PsiDirectory> result = new ArrayList<PsiDirectory>();
        if (!this.isDirectory()) {
            ArrayList<PsiDirectory> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getSourcePsiDirectories"));
            }
            return arrayList;
        }
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        Module module = this.myWebFacet.getModule();
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        VirtualFile compilerOutputPath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
        VirtualFile[] sourceRoots = moduleRootManager.getSourceRoots();
        if (compilerOutputPath == null) {
            ArrayList<PsiDirectory> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getSourcePsiDirectories"));
            }
            return arrayList;
        }
        for (VirtualFile virtualFile : virtualFiles) {
            String relativePathInOutput = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)compilerOutputPath, (char)'/');
            if (relativePathInOutput == null) continue;
            for (VirtualFile sourceRoot : sourceRoots) {
                PsiDirectory directory;
                VirtualFile sourceDir = sourceRoot.findFileByRelativePath(relativePathInOutput);
                PsiDirectory psiDirectory = directory = sourceDir == null ? null : psiManager.findDirectory(sourceDir);
                if (directory == null) continue;
                result.add(directory);
            }
        }
        ArrayList<PsiDirectory> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getSourcePsiDirectories"));
        }
        return arrayList;
    }

    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    @Nullable
    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        return -1;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return -1;
    }

    @Nullable
    public String getText() {
        return null;
    }

    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "textToCharArray"));
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "textMatches"));
        }
        return false;
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "textMatches"));
        }
        return false;
    }

    public PsiElement copy() {
        LOG.error("method not implemented");
        return null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "add"));
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "addBefore"));
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "addAfter"));
        }
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "checkAdd"));
        }
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        for (VirtualFile file : virtualFiles) {
            try {
                file.delete((Object)this.myManager);
            }
            catch (IOException e) {
                throw new IncorrectOperationException((Throwable)e);
            }
        }
    }

    public void checkDelete() throws IncorrectOperationException {
        List<VirtualFile> virtualFiles = this.getOriginalVirtualFiles();
        for (VirtualFile file : virtualFiles) {
            CheckUtil.checkDelete((VirtualFile)file);
        }
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "replace"));
        }
        throw new IncorrectOperationException();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        WebDirectoryElement[] packs;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        for (WebDirectoryElement element : packs = this.getChildren()) {
            WebDirectoryElement toProcess;
            Object object = toProcess = element.isDirectory() ? element : element.getOriginalFile();
            if (toProcess == null || processor.execute((PsiElement)toProcess, state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiFile file = this.getOriginalFile();
        WebDirectoryElementImpl webDirectoryElementImpl = file == null ? this : file;
        if (webDirectoryElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/impl/WebDirectoryElementImpl", "getNavigationElement"));
        }
        return webDirectoryElementImpl;
    }

    public boolean canNavigate() {
        return this.isDirectory() || super.canNavigate();
    }

    public void navigate(boolean requestFocus) {
        PsiDirectory directory;
        if (!this.isDirectory()) {
            super.navigate(requestFocus);
            return;
        }
        VirtualFile virtualFile = this.getOriginalVirtualFile();
        PsiFile psiElement = null;
        if (virtualFile != null && virtualFile.isDirectory() && (directory = PsiManager.getInstance((Project)this.getProject()).findDirectory(virtualFile)) != null) {
            psiElement = directory;
        }
        PsiFile file = this.getOriginalFile();
        if (psiElement == null && file != null) {
            psiElement = file;
        }
        if (psiElement == null) {
            return;
        }
        Object[] path = WebRootFileUrl.getPath((PsiElement)psiElement);
        WebView.select(this.getProject(), path, requestFocus);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return WebDirectoryElementImpl.this.getPath();
            }

            public String getLocationString() {
                return "(" + WebDirectoryElementImpl.this.myWebFacet.getName() + ")";
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    public boolean isPhysical() {
        return true;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof WebDirectoryElementImpl && ((WebDirectoryElementImpl)((Object)object)).getPath().equals(this.getPath()) && ((WebDirectoryElementImpl)((Object)object)).myManager.equals(this.myManager) && ((WebDirectoryElementImpl)((Object)object)).myWebFacet.equals((Object)this.myWebFacet);
    }

    public String toString() {
        return "Web directory '" + this.getPath() + "' in Web facet '" + JavaeeUtil.getFacetWithModuleName((JavaeeFacet)this.myWebFacet) + "'";
    }

    public ASTNode getNode() {
        return null;
    }
}

