/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.UriUtil;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SetContextFolderFix;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebFileReferenceHelper
extends FileReferenceHelper {
    private static final int MAX_DEPTH = 2;

    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "trimUrl"));
        }
        String string = WebUtil.trimURL((String)url);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "trimUrl"));
        }
        return string;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference) {
        SetContextFolderFix[] contextFolderFix;
        Pair<VirtualFile, String> pair;
        ArrayList<LocalQuickFix> list = new ArrayList<LocalQuickFix>();
        FileReferenceSet fileReferenceSet = reference.getFileReferenceSet();
        int count = fileReferenceSet.getAllReferences().length;
        WebFacet webFacet = this.getWebFacet(reference);
        if (webFacet != null && count != 0 && reference.getIndex() == count - 1 && fileReferenceSet.isAbsolutePathReference() && (pair = this.findWebRootCandidate(fileReferenceSet.getPathString(), webFacet)) != null) {
            list.add(this.doRegisterFix(pair, webFacet));
        }
        if (webFacet != null && (contextFolderFix = SetContextFolderFix.create(reference, webFacet)) != null) {
            for (SetContextFolderFix fix : contextFolderFix) {
                list.add(fix);
            }
        }
        ArrayList<LocalQuickFix> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "registerFixes"));
        }
        return arrayList;
    }

    public WebDirectoryElement getPsiFileSystemItem(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "getPsiFileSystemItem"));
        }
        WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)project);
        if (webFacet == null) {
            return null;
        }
        return WebDirectoryUtil.getWebDirectoryUtil(project).findWebDirectoryByFile(file, webFacet);
    }

    public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "findRoot"));
        }
        WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)project);
        if (webFacet == null) {
            return null;
        }
        return WebDirectoryUtil.getWebDirectoryUtil(project).findWebDirectoryElementByPath("/", webFacet);
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module thisModule) {
        if (thisModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisModule", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "getRoots"));
        }
        final WebDirectoryUtil util = WebDirectoryUtil.getWebDirectoryUtil(thisModule.getProject());
        final ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
        WebUtil.getWebUtil().visitAllFacets(thisModule, (Consumer)new Consumer<WebFacet>(){

            public void consume(WebFacet facet) {
                WebDirectoryElement directoryElement = util.findWebDirectoryElementByPath("/", facet);
                if (directoryElement != null) {
                    list.add(directoryElement);
                }
            }
        });
        ArrayList<PsiFileSystemItem> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "getRoots"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        Module module;
        WebDirectoryElement parent;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "getContexts"));
        }
        WebDirectoryElement item = this.getPsiFileSystemItem(project, file);
        if (item != null && (parent = item.getParent()) != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null) {
            String path = parent.getPath();
            Collection collection = WebUtil.getWebUtil().getContextsByPath(path, module);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "getContexts"));
            }
            return collection;
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "getContexts"));
        }
        return list;
    }

    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "isMine"));
        }
        return WebUtil.isInsideWebRoots((VirtualFile)file, (Project)project);
    }

    @Nullable
    protected Pair<VirtualFile, String> findWebRootCandidate(String path, WebFacet webFacet) {
        ContentEntry[] contentEntries;
        List webRoots = webFacet.getWebRoots();
        Module module = webFacet.getModule();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (ContentEntry entry : contentEntries = rootManager.getContentEntries()) {
            VirtualFile webRootCandidate;
            VirtualFile virtualFile = entry.getFile();
            if (virtualFile == null || (webRootCandidate = WebFileReferenceHelper.scan(virtualFile, path.split("/"), entry, webRoots, 0)) == null) continue;
            VirtualFile base = webRootCandidate;
            String mapTo = "/";
            int pos = 0;
            for (WebRoot webRoot : webRoots) {
                if (!webRoot.getRelativePath().equals(mapTo)) continue;
                if ((pos = path.indexOf(47, pos + 1)) == -1) {
                    return null;
                }
                mapTo = path.substring(0, pos);
                webRootCandidate = UriUtil.findRelativeFile((String)mapTo, (VirtualFile)base);
                if (webRootCandidate != null) continue;
                return null;
            }
            return Pair.create((Object)webRootCandidate, (Object)mapTo);
        }
        return null;
    }

    @Nullable
    protected WebFacet getWebFacet(FileReference reference) {
        PsiElement element = reference.getElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        Iterator iterator = WebFacet.getInstances((Module)module).iterator();
        return iterator.hasNext() ? (WebFacet)iterator.next() : null;
    }

    protected LocalQuickFix doRegisterFix(Pair<VirtualFile, String> pair, WebFacet webFacet) {
        return new AddWebRootIntentionAction((VirtualFile)pair.first, (String)pair.second, webFacet);
    }

    @Nullable
    private static VirtualFile scan(@NotNull VirtualFile file, String[] path, ContentEntry contentEntry, List<WebRoot> webRoots, int depth) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "scan"));
        }
        if (!file.isDirectory()) {
            return null;
        }
        boolean containsWebRoot = false;
        for (WebRoot root : webRoots) {
            VirtualFile rootFile = root.getFile();
            if (Comparing.equal((Object)file, (Object)rootFile)) {
                return null;
            }
            if (rootFile == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)rootFile, (boolean)false)) continue;
            containsWebRoot = true;
            break;
        }
        if (!containsWebRoot && WebFileReferenceHelper.findRelativeFile(path, file) != null) {
            boolean valid = true;
            for (VirtualFile entry : contentEntry.getExcludeFolderFiles()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)entry, (boolean)false)) continue;
                valid = false;
                break;
            }
            if (valid) {
                return file;
            }
        }
        if (depth < 2) {
            for (VirtualFile child : file.getChildren()) {
                VirtualFile result = WebFileReferenceHelper.scan(child, path, contentEntry, webRoots, depth + 1);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static VirtualFile findRelativeFile(@NotNull String[] path, @NotNull VirtualFile base) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "findRelativeFile"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper", "findRelativeFile"));
        }
        VirtualFile result = base;
        for (String file : path) {
            if ((result = result.findChild(file)) != null) continue;
            return base;
        }
        return base;
    }

    private static class AddWebRootIntentionAction
    implements IntentionAction,
    LocalQuickFix {
        private final VirtualFile myWebRootCandidate;
        private final String myMapTo;
        private final WebFacet myWebFacet;

        public AddWebRootIntentionAction(@NotNull VirtualFile webRootCandidate, @NotNull String mapTo, @NotNull WebFacet webFacet) {
            if (webRootCandidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webRootCandidate", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction", "<init>"));
            }
            if (mapTo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapTo", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction", "<init>"));
            }
            if (webFacet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction", "<init>"));
            }
            this.myWebRootCandidate = webRootCandidate;
            this.myMapTo = mapTo;
            this.myWebFacet = webFacet;
        }

        @NotNull
        public String getText() {
            String string = J2EEBundle.message((String)"add.web.root", (Object[])new Object[]{this.myWebRootCandidate.getPath()});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction", "getText"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = J2EEBundle.message((String)"web.root.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction", "applyFix"));
            }
            this.invoke(project, null, null);
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction", "isAvailable"));
            }
            return true;
        }

        public final void invoke(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction", "invoke"));
            }
            new WriteCommandAction.Simple(project, new PsiFile[0]){

                protected void run() throws Throwable {
                    AddWebRootIntentionAction.this.myWebFacet.addWebRoot(AddWebRootIntentionAction.this.myWebRootCandidate, AddWebRootIntentionAction.this.myMapTo);
                }
            }.execute();
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

