/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang.jsp.extractTag;

import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.refactoring.lang.jsp.extractInclude.ExtractJspIncludeFileHandler;
import com.intellij.refactoring.lang.jsp.extractTag.ExtractTagHandler;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nullable;

public class ExtractJspxTagHandler
extends ExtractTagHandler {
    @Override
    protected boolean acceptFile(BaseJspFile file) {
        return file.getLanguage() == StdLanguages.JSPX;
    }

    @Override
    public boolean isAvailableOnSelection(Editor editor, PsiFile file) {
        if (!super.isAvailableOnSelection(editor, file)) {
            return false;
        }
        return ExtractJspxTagHandler.getSelectedPair(editor, file) != null;
    }

    @Nullable
    protected static Pair<XmlTagChild, XmlTagChild> getSelectedPair(Editor editor, PsiFile file) {
        int start = editor.getSelectionModel().getSelectionStart();
        int end = editor.getSelectionModel().getSelectionEnd();
        return XmlUtil.findTagChildrenInRange((PsiFile)file, (int)start, (int)end);
    }

    @Override
    public String getTagFileText(Editor editor, PsiFile file) {
        Pair<XmlTagChild, XmlTagChild> pair = ExtractJspxTagHandler.getSelectedPair(editor, file);
        return pair == null ? null : ExtractJspIncludeFileHandler.getNewFileText((XmlTagChild)((XmlTagChild)pair.first), (XmlTagChild)((XmlTagChild)pair.second), (String)super.getTagFileText(editor, file));
    }

    @Override
    public String getTagExtension() {
        return "tagx";
    }

    @Override
    public void addDeclaration(XmlTag rootTag, BaseJspFile jspFile, String prefix, String tagdir) {
        rootTag.setAttribute("xmlns:" + prefix, this.getNamespace(tagdir));
    }

    protected String getNamespace(String tagdir) {
        return "urn:jsptagdir:" + tagdir;
    }

    @Override
    public String getExistingPrefix(BaseJspFile jspFile, String tagdir) {
        return XmlUtil.findNamespacePrefixByURI((XmlFile)jspFile, (String)this.getNamespace(tagdir));
    }
}

