/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseTopics;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.MessageBusUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.messages.Topic;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleRequestBroker
implements DataBus.Producing,
DataBus.Consuming {
    private final MessageBus myMessageBus;
    private final DataRequest.OwnerEx myOwnerEx;
    private final List<DataProducer> myProducers;

    public static SimpleRequestBroker newInstance(@NotNull Project project, @NotNull String title) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/SimpleRequestBroker", "newInstance"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/SimpleRequestBroker", "newInstance"));
        }
        MessageBus messageBus = MessageBusFactory.newMessageBus((Object)title, (MessageBus)DataBus.getDataBus(project));
        final Disposable messageBusDisposable = MessageBusUtil.newMessageBusDisposer((MessageBus)messageBus);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)messageBusDisposable);
        return new SimpleRequestBroker(null, messageBus){

            @Override
            public void afterProducerRemove(@NotNull DataProducer dataProducer) {
                if (dataProducer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProducer", "com/intellij/database/SimpleRequestBroker$1", "afterProducerRemove"));
                }
                if (!this.hasNoProducers()) {
                    return;
                }
                DbUIUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Disposer.dispose((Disposable)messageBusDisposable);
                    }
                });
            }
        };
    }

    SimpleRequestBroker(@Nullable DataRequest.OwnerEx ownerEx, @NotNull MessageBus messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/SimpleRequestBroker", "<init>"));
        }
        this.myProducers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myOwnerEx = ownerEx;
        this.myMessageBus = messageBus;
        this.subscribe(DatabaseTopics.REQUEST_TOPIC, new DataProducer(){

            @Override
            public void processRequest(@NotNull DataRequest request) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/SimpleRequestBroker$2", "processRequest"));
                }
                for (DataProducer producer : SimpleRequestBroker.this.myProducers) {
                    producer.processRequest(request);
                }
            }
        });
    }

    boolean hasNoProducers() {
        return this.myProducers.isEmpty();
    }

    @Override
    public DataBus.Consuming filterFor(@NotNull DataRequest.OwnerEx owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/SimpleRequestBroker", "filterFor"));
        }
        return new SimpleRequestBroker(owner, this.myMessageBus);
    }

    @Override
    public DataProducer getDataProducer() {
        return (DataProducer)this.myMessageBus.syncPublisher(DatabaseTopics.REQUEST_TOPIC);
    }

    @Override
    public DataAuditor getDataAuditor() {
        return (DataAuditor)this.myMessageBus.syncPublisher(DatabaseTopics.AUDIT_TOPIC);
    }

    @Override
    public DataConsumer getDataConsumer() {
        return (DataConsumer)this.myMessageBus.syncPublisher(DatabaseTopics.RESPONSE_TOPIC);
    }

    @Override
    public void addProducer(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProducer", "com/intellij/database/SimpleRequestBroker", "addProducer"));
        }
        this.myProducers.add(dataProducer);
    }

    @Override
    public void beforeProducerRemove(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProducer", "com/intellij/database/SimpleRequestBroker", "beforeProducerRemove"));
        }
        this.myProducers.remove(dataProducer);
    }

    @Override
    public void afterProducerRemove(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProducer", "com/intellij/database/SimpleRequestBroker", "afterProducerRemove"));
        }
    }

    @Override
    public void addConsumer(@NotNull DataConsumer dataConsumer) {
        if (dataConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataConsumer", "com/intellij/database/SimpleRequestBroker", "addConsumer"));
        }
        this.subscribe(DatabaseTopics.RESPONSE_TOPIC, this.myOwnerEx == null ? dataConsumer : new DataConsumer.Wrapper(dataConsumer){

            @Override
            public boolean accepts(@NotNull DataRequest.Owner owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/SimpleRequestBroker$3", "accepts"));
                }
                return owner == SimpleRequestBroker.this.myOwnerEx;
            }
        });
    }

    @Override
    public void addAuditor(@NotNull DataAuditor dataAuditor) {
        if (dataAuditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataAuditor", "com/intellij/database/SimpleRequestBroker", "addAuditor"));
        }
        this.subscribe(DatabaseTopics.AUDIT_TOPIC, this.myOwnerEx == null ? dataAuditor : new DataAuditor.Wrapper(dataAuditor){

            @Override
            public boolean accepts(DataRequest.Owner owner) {
                return owner == SimpleRequestBroker.this.myOwnerEx;
            }

            @Override
            public void txCompleted(@NotNull DataRequest.Context context, boolean committed) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/SimpleRequestBroker$4", "txCompleted"));
                }
                if (SimpleRequestBroker.this.myOwnerEx.getCurrentTx() == context.txMarker || this.accepts(context) || this.accepts(context.txMarker.getOwner())) {
                    this.delegate.txCompleted(context, committed);
                }
            }
        });
    }

    private <L> void subscribe(Topic<L> topic, L listener) {
        DataAuditor target;
        MessageBusConnection busConnection = this.myOwnerEx == null ? this.myMessageBus.connect() : this.myMessageBus.connect((Disposable)this.myOwnerEx);
        busConnection.subscribe(topic, listener);
        DataAuditor dataAuditor = listener instanceof DataAuditor.Wrapper ? ((DataAuditor.Wrapper)listener).delegate : (target = listener instanceof DataConsumer.Wrapper ? ((DataConsumer.Wrapper)listener).delegate : listener);
        if (target instanceof Disposable) {
            Disposer.register((Disposable)((Disposable)target), (Disposable)busConnection);
        }
    }
}

