/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ThrowableConsumer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;

public abstract class ConnectionProvider {
    private int myUseCounter;
    protected Connection myConnection;
    protected ResultSet myResultSet;
    protected Exception myLastException;

    public abstract Connection acquireImpl();

    public Connection getConnection() {
        return this.myConnection;
    }

    public int getUseCounter() {
        return this.myUseCounter;
    }

    public Exception getLastException() {
        Exception exception = this.myLastException;
        this.myLastException = null;
        return exception;
    }

    public boolean acquire() {
        if (this.myUseCounter++ == 0) {
            this.myConnection = this.acquireImpl();
        }
        return this.myConnection != null;
    }

    public void release() {
        this.releaseResultSet();
        if (--this.myUseCounter == 0) {
            this.forceRelease();
        }
    }

    public void forceRelease() {
        JdbcUtil.closeConnectionSafe((Connection)this.myConnection);
        this.myConnection = null;
    }

    private void releaseResultSet() {
        JdbcUtil.closeResultSetSafe((ResultSet)this.myResultSet);
        this.myResultSet = null;
    }

    public ResultSet executeQuery(String query, Object ... params) throws Exception {
        assert (this.myConnection != null);
        this.releaseResultSet();
        Statement st = this.myConnection.createStatement();
        this.myResultSet = st.executeQuery(String.format(query, params));
        return this.myResultSet;
    }

    public static ConnectionProvider forElement(final DbElement element) {
        return new ConnectionProvider(){

            @Override
            public Connection acquireImpl() {
                try {
                    return DbImplUtil.getConnection(element);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Exception e) {
                    this.myLastException = e;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithProvider(@NotNull DbElement element, @NotNull ThrowableConsumer<ConnectionProvider, Exception> runnable) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/access/ConnectionProvider", "runWithProvider"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/access/ConnectionProvider", "runWithProvider"));
        }
        ConnectionProvider provider = ConnectionProvider.forElement(element);
        try {
            Exception exception;
            if (!provider.acquire() && (exception = provider.getLastException()) != null) {
                throw exception;
            }
            runnable.consume((Object)provider);
        }
        finally {
            provider.release();
            assert (provider.getUseCounter() == 0);
            assert (provider.getConnection() == null);
        }
    }
}

