/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.csv.ui.FormatsListAndPreviewPanel;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.editor.CsvTableFileEditorProvider;
import com.intellij.database.editor.FragmentTableFileEditorProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditAsTableAction
extends DumbAwareAction {
    private static final String CSV_FORMAT_DIALOG_DIMENSION_SERVICE_KEY = "editAsTableFormatDialogDimension";

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (project == null || file == null || !EditorUtil.isRealFileEditor((Editor)editor)) {
            e.getPresentation().setText(this.getTemplatePresentation().getText());
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
        boolean isDml = EditAsTableAction.getSelection(editor) != null && language instanceof SqlLanguageDialect;
        boolean isCsv = language == PlainTextLanguage.INSTANCE;
        e.getPresentation().setText(this.getTemplatePresentation().getText() + (isDml ? "" : "..."));
        e.getPresentation().setEnabled(true);
        e.getPresentation().setVisible(isDml || isCsv || "EditorPopup" != e.getPlace());
    }

    public void actionPerformed(AnActionEvent e) {
        Language language;
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        final VirtualFile file = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
        Document document = editor.getDocument();
        final TextRange selection = EditAsTableAction.getSelection(editor);
        if (selection != null && (language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) instanceof SqlLanguageDialect) {
            FragmentTableFileEditorProvider.openFragmentEditor(project, file, selection, (SqlLanguageDialect)language);
            return;
        }
        final CsvFormat format = this.showDataFormatEditorDialog(project, file, document, selection);
        if (format != null) {
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    if (selection == null) {
                        CsvTableFileEditorProvider.openEditor(project, file, format);
                    } else {
                        FragmentTableFileEditorProvider.openFragmentEditor(project, file, selection, format);
                    }
                }
            });
        }
    }

    @Nullable
    private static TextRange getSelection(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        TextRange range = EditorUtil.getSelectionInAnyMode((Editor)editor);
        return range.isEmpty() ? null : range;
    }

    @Nullable
    private CsvFormat showDataFormatEditorDialog(@NotNull Project project, @NotNull VirtualFile file, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/EditAsTableAction", "showDataFormatEditorDialog"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/EditAsTableAction", "showDataFormatEditorDialog"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/actions/EditAsTableAction", "showDataFormatEditorDialog"));
        }
        Disposable disposable = Disposer.newDisposable();
        String text = range == null ? document.getText() : range.subSequence(document.getCharsSequence()).toString();
        CsvFormatsSelectionUI formatsForm = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(disposable);
        CsvFormat selectedFormat = (CsvFormat)ObjectUtils.assertNotNull((Object)formatsForm.getSelectedFormat());
        TableCsvFormatPreview preview = new TableCsvFormatPreview(project, selectedFormat, text, disposable);
        FormatsListAndPreviewPanel panel = new FormatsListAndPreviewPanel(formatsForm, preview);
        panel.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        DialogBuilder dialog = new DialogBuilder(project).title(this.getTemplatePresentation().getText() + ": '" + file.getName() + "'" + (range != null ? " Fragment" : "") + " Format").centerPanel((JComponent)panel).dimensionKey(CSV_FORMAT_DIALOG_DIMENSION_SERVICE_KEY);
        dialog.setHelpId("edit.as.table.format.configuration.dialog");
        Disposer.register((Disposable)dialog, (Disposable)disposable);
        return dialog.showAndGet() ? formatsForm.getSelectedFormat() : null;
    }
}

